/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.JoinedGroupPacket;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.Group;
import de.maxhenkel.voicechat.voice.server.PlayerStateManager;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_3222;

public class GroupManager {
    private final Map<UUID, Group> groups;
    private final Server server;

    public GroupManager(Server server) {
        this.server = server;
        this.groups = new ConcurrentHashMap<UUID, Group>();
        CommonCompatibilityManager.INSTANCE.getNetManager().joinGroupChannel.setServerListener((srv, player, handler, packet) -> {
            if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
                return;
            }
            this.joinGroup(this.groups.get(packet.getGroup()), player, packet.getPassword());
        });
        CommonCompatibilityManager.INSTANCE.getNetManager().createGroupChannel.setServerListener((srv, player, handler, packet) -> {
            if (!Voicechat.SERVER_CONFIG.groupsEnabled.get().booleanValue()) {
                return;
            }
            this.addGroup(new Group(UUID.randomUUID(), packet.getName(), packet.getPassword()), player);
        });
        CommonCompatibilityManager.INSTANCE.getNetManager().leaveGroupChannel.setServerListener((srv, player, handler, packet) -> this.leaveGroup(player));
    }

    private PlayerStateManager getStates() {
        return this.server.getPlayerStateManager();
    }

    public void addGroup(Group group, class_3222 player) {
        if (PluginManager.instance().onCreateGroup(player, group)) {
            return;
        }
        this.groups.put(group.getId(), group);
        PlayerStateManager manager = this.getStates();
        manager.setGroup(player.field_13995, player, group.toClientGroup());
        NetManager.sendToClient(player, new JoinedGroupPacket(group.toClientGroup()));
    }

    public void joinGroup(@Nullable Group group, class_3222 player, @Nullable String password) {
        if (PluginManager.instance().onJoinGroup(player, group)) {
            return;
        }
        if (group == null) {
            NetManager.sendToClient(player, new JoinedGroupPacket(null));
            return;
        }
        if (group.getPassword() != null && !group.getPassword().equals(password)) {
            NetManager.sendToClient(player, new JoinedGroupPacket(null));
            return;
        }
        PlayerStateManager manager = this.getStates();
        manager.setGroup(player.field_13995, player, group.toClientGroup());
        NetManager.sendToClient(player, new JoinedGroupPacket(group.toClientGroup()));
    }

    public void leaveGroup(class_3222 player) {
        if (PluginManager.instance().onLeaveGroup(player)) {
            return;
        }
        PlayerStateManager manager = this.getStates();
        manager.setGroup(player.field_13995, player, null);
        this.cleanEmptyGroups();
    }

    public void cleanEmptyGroups() {
        PlayerStateManager manager = this.getStates();
        List usedGroups = manager.getStates().stream().filter(PlayerState::hasGroup).map(state -> state.getGroup().getId()).distinct().collect(Collectors.toList());
        List groupsToRemove = this.groups.keySet().stream().filter(uuid -> !usedGroups.contains(uuid)).collect(Collectors.toList());
        for (UUID uuid2 : groupsToRemove) {
            this.groups.remove(uuid2);
        }
    }

    @Nullable
    public Group getGroup(UUID groupID) {
        return this.groups.get(groupID);
    }

    @Nullable
    public Group getPlayerGroup(class_3222 player) {
        PlayerState state = this.server.getPlayerStateManager().getState(player.method_5667());
        if (state == null) {
            return null;
        }
        ClientGroup group = state.getGroup();
        if (group == null) {
            return null;
        }
        return this.getGroup(group.getId());
    }
}

