/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.CreateGroupScreen;
import de.maxhenkel.voicechat.gui.EnterPasswordScreen;
import de.maxhenkel.voicechat.gui.GroupScreen;
import de.maxhenkel.voicechat.gui.JoinGroupScreen;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ClientPlayerStateManager {
    private boolean muted;
    private PlayerState state;
    private Map<UUID, PlayerState> states;

    public ClientPlayerStateManager() {
        this.muted = VoicechatClient.CLIENT_CONFIG.muted.get();
        this.state = this.getDefaultState();
        this.states = new HashMap<UUID, PlayerState>();
        CommonCompatibilityManager.INSTANCE.getNetManager().playerStateChannel.setClientListener((client, handler, packet) -> {
            this.states.put(packet.getPlayerState().getGameProfile().getId(), packet.getPlayerState());
            if (packet.getPlayerState().getGameProfile().getId().equals(this.state.getGameProfile().getId())) {
                this.state.setGroup(packet.getPlayerState().getGroup());
                Voicechat.logDebug("Setting own state: {}", this.state);
            } else {
                Voicechat.logDebug("Got state for {}: {}", packet.getPlayerState().getGameProfile().getName(), packet.getPlayerState());
            }
        });
        CommonCompatibilityManager.INSTANCE.getNetManager().playerStatesChannel.setClientListener((client, handler, packet) -> {
            this.states = packet.getPlayerStates();
            Voicechat.logDebug("Received {} states", this.states.size());
        });
        CommonCompatibilityManager.INSTANCE.getNetManager().joinedGroupChannel.setClientListener((client, handler, packet) -> {
            class_437 screen = class_310.method_1551().field_1755;
            if (packet.getGroup() == null) {
                if (screen instanceof JoinGroupScreen || screen instanceof CreateGroupScreen || screen instanceof EnterPasswordScreen) {
                    class_310.method_1551().method_1507(null);
                }
                client.field_1724.method_7353((class_2561)new class_2588("message.voicechat.wrong_password").method_27692(class_124.field_1079), true);
                return;
            }
            if (screen instanceof JoinGroupScreen || screen instanceof CreateGroupScreen || screen instanceof EnterPasswordScreen) {
                class_310.method_1551().method_1507((class_437)new GroupScreen(packet.getGroup()));
            }
        });
        ClientCompatibilityManager.INSTANCE.onVoiceChatConnected(this::onVoiceChatConnected);
        ClientCompatibilityManager.INSTANCE.onVoiceChatDisconnected(this::onVoiceChatDisconnected);
        ClientCompatibilityManager.INSTANCE.onDisconnect(this::onDisconnect);
    }

    private PlayerState getDefaultState() {
        return new PlayerState(VoicechatClient.CLIENT_CONFIG.disabled.get(), true, class_310.method_1551().method_1548().method_1677());
    }

    public void onVoiceChatDisconnected() {
        this.state.setDisconnected(true);
        this.syncOwnState();
    }

    public void onVoiceChatConnected(ClientVoicechatConnection client) {
        this.state.setDisconnected(false);
        this.syncOwnState();
    }

    private void onDisconnect() {
        this.clearStates();
        this.state = this.getDefaultState();
    }

    public boolean isPlayerDisabled(class_1657 player) {
        PlayerState playerState = this.states.get(player.method_5667());
        if (playerState == null) {
            return false;
        }
        return playerState.isDisabled();
    }

    public boolean isPlayerDisconnected(class_1657 player) {
        PlayerState playerState = this.states.get(player.method_5667());
        if (playerState == null) {
            return true;
        }
        return playerState.isDisconnected();
    }

    public void syncOwnState() {
        NetManager.sendToServer(new PlayerStatePacket(this.state));
        Voicechat.logDebug("Sent own state to server: {}", this.state);
    }

    public boolean isDisabled() {
        return this.state.isDisabled();
    }

    public boolean isDisconnected() {
        return this.state.isDisconnected();
    }

    public void setDisabled(boolean disabled) {
        this.state.setDisabled(disabled);
        VoicechatClient.CLIENT_CONFIG.disabled.set(disabled).save();
        this.syncOwnState();
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
        VoicechatClient.CLIENT_CONFIG.muted.set(muted).save();
    }

    public boolean isInGroup() {
        return this.getGroup() != null;
    }

    public boolean isInGroup(class_1657 player) {
        PlayerState state = this.states.get(player.method_5667());
        if (state == null) {
            return false;
        }
        return state.hasGroup();
    }

    @Nullable
    public ClientGroup getGroup(class_1657 player) {
        PlayerState state = this.states.get(player.method_5667());
        if (state == null) {
            return null;
        }
        return state.getGroup();
    }

    @Nullable
    public ClientGroup getGroup() {
        return this.state.getGroup();
    }

    public List<PlayerState> getPlayerStates() {
        return new ArrayList<PlayerState>(this.states.values());
    }

    @Nullable
    public PlayerState getState(UUID player) {
        return this.states.get(player);
    }

    public void clearStates() {
        this.states.clear();
    }
}

