/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.RawUdpPacket;
import de.maxhenkel.voicechat.api.VoicechatSocket;
import de.maxhenkel.voicechat.plugins.impl.RawUdpPacketImpl;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;

public class VoicechatSocketImpl
implements VoicechatSocket {
    private DatagramSocket socket;

    @Override
    public void open(int port, String bindAddress) throws Exception {
        if (this.socket != null) {
            throw new IllegalStateException("Socket already opened");
        }
        this.checkCorrectHost();
        InetAddress address = null;
        try {
            if (!bindAddress.isEmpty()) {
                address = InetAddress.getByName(bindAddress);
            }
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to parse bind IP address '{}'", (Object)bindAddress);
            e.printStackTrace();
            Voicechat.LOGGER.info("Binding to default IP address");
        }
        try {
            try {
                this.socket = new DatagramSocket(port, address);
            }
            catch (BindException e) {
                if (address == null || bindAddress.equals("0.0.0.0")) {
                    throw e;
                }
                Voicechat.LOGGER.fatal("Failed to bind to address '{}', binding to '0.0.0.0' instead", (Object)bindAddress);
                this.socket = new DatagramSocket(port);
            }
            this.socket.setTrafficClass(4);
        }
        catch (BindException e) {
            Voicechat.LOGGER.error("Failed to bind to address '0.0.0.0', make sure no other application is running at UDP port {}", (Object)port);
            e.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void checkCorrectHost() {
        String host = Voicechat.SERVER_CONFIG.voiceHost.get();
        if (!host.isEmpty()) {
            try {
                new URI("voicechat://" + host);
            }
            catch (URISyntaxException e) {
                Voicechat.LOGGER.warn("Failed to parse voice host: {}", (Object)e.getMessage());
                System.exit(1);
            }
        }
    }

    @Override
    public RawUdpPacket read() throws Exception {
        return RawUdpPacketImpl.read(this.socket);
    }

    @Override
    public void send(byte[] data, SocketAddress address) throws Exception {
        this.socket.send(new DatagramPacket(data, data.length, address));
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }
}

