/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.Channel;
import de.maxhenkel.voicechat.net.CreateGroupPacket;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.net.JoinedGroupPacket;
import de.maxhenkel.voicechat.net.LeaveGroupPacket;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.net.PlayerStatePacket;
import de.maxhenkel.voicechat.net.PlayerStatesPacket;
import de.maxhenkel.voicechat.net.RequestSecretPacket;
import de.maxhenkel.voicechat.net.SecretPacket;
import io.netty.buffer.Unpooled;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;

public abstract class NetManager {
    public Channel<PlayerStatePacket> playerStateChannel;
    public Channel<PlayerStatesPacket> playerStatesChannel;
    public Channel<SecretPacket> secretChannel;
    public Channel<RequestSecretPacket> requestSecretChannel;
    public Channel<JoinGroupPacket> joinGroupChannel;
    public Channel<CreateGroupPacket> createGroupChannel;
    public Channel<LeaveGroupPacket> leaveGroupChannel;
    public Channel<JoinedGroupPacket> joinedGroupChannel;

    public void init() {
        this.playerStateChannel = this.registerReceiver(PlayerStatePacket.class, true, true);
        this.playerStatesChannel = this.registerReceiver(PlayerStatesPacket.class, true, false);
        this.secretChannel = this.registerReceiver(SecretPacket.class, true, false);
        this.requestSecretChannel = this.registerReceiver(RequestSecretPacket.class, false, true);
        this.joinGroupChannel = this.registerReceiver(JoinGroupPacket.class, false, true);
        this.createGroupChannel = this.registerReceiver(CreateGroupPacket.class, false, true);
        this.leaveGroupChannel = this.registerReceiver(LeaveGroupPacket.class, false, true);
        this.joinedGroupChannel = this.registerReceiver(JoinedGroupPacket.class, true, false);
    }

    public abstract <T extends Packet<T>> Channel<T> registerReceiver(Class<T> var1, boolean var2, boolean var3);

    public static void sendToServer(Packet<?> packet) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        packet.toBytes(buffer);
        class_634 connection = class_310.method_1551().method_1562();
        if (connection != null) {
            connection.method_2883((class_2596)new class_2817(packet.getIdentifier(), buffer));
        }
    }

    public static void sendToClient(class_3222 player, Packet<?> packet) {
        if (!Voicechat.SERVER.isCompatible(player)) {
            return;
        }
        class_2540 buffer = new class_2540(Unpooled.buffer());
        packet.toBytes(buffer);
        player.field_13987.method_14364((class_2596)new class_2658(packet.getIdentifier(), buffer));
    }

    public static interface ClientReceiver<T extends Packet<T>> {
        public void onPacket(class_310 var1, class_634 var2, T var3);
    }

    public static interface ServerReceiver<T extends Packet<T>> {
        public void onPacket(MinecraftServer var1, class_3222 var2, class_3244 var3, T var4);
    }
}

