/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.gui.EnterPasswordScreen;
import de.maxhenkel.voicechat.gui.SkinUtils;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.widgets.WidgetBase;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;

public class JoinGroupList
extends WidgetBase {
    private static final class_2960 TEXTURE = new class_2960("voicechat", "textures/gui/gui_join_group.png");
    private static final class_2960 LOCK = new class_2960("voicechat", "textures/icons/lock.png");
    protected int offset;
    private final VoiceChatScreenBase.HoverArea[] hoverAreas;
    private final int columnHeight;
    private final int columnCount;

    public JoinGroupList(VoiceChatScreenBase screen, int posX, int posY, int xSize, int ySize) {
        super(screen, posX, posY, xSize, ySize);
        this.columnHeight = 22;
        this.columnCount = 4;
        this.hoverAreas = new VoiceChatScreenBase.HoverArea[this.columnCount];
        for (int i = 0; i < this.hoverAreas.length; ++i) {
            this.hoverAreas[i] = new VoiceChatScreenBase.HoverArea(0, i * this.columnHeight, xSize, this.columnHeight);
        }
    }

    public List<Group> getGroups() {
        HashMap<UUID, Group> groups = new HashMap<UUID, Group>();
        List<PlayerState> playerStates = ClientManager.getPlayerStateManager().getPlayerStates();
        for (PlayerState state : playerStates) {
            if (!state.hasGroup()) continue;
            Group group = groups.getOrDefault(state.getGroup().getId(), new Group(state.getGroup()));
            group.members.add(state);
            group.members.sort(Comparator.comparing(o -> o.getGameProfile().getName()));
            groups.put(state.getGroup().getId(), group);
        }
        return new ArrayList<Group>(groups.values());
    }

    @Override
    public void drawGuiContainerForegroundLayer(class_4587 matrixStack, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        List<Group> entries = this.getGroups();
        for (int i = this.getOffset(); i < entries.size() && i < this.getOffset() + this.columnCount; ++i) {
            int pos = i - this.getOffset();
            VoiceChatScreenBase.HoverArea hoverArea = this.hoverAreas[pos];
            int startY = this.guiTop + pos * this.columnHeight;
            Group group = entries.get(i);
            boolean hasPassword = group.group.hasPassword();
            if (hasPassword) {
                matrixStack.method_22903();
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (class_2960)LOCK);
                class_437.method_25290((class_4587)matrixStack, (int)(this.guiLeft + 3), (int)(startY + 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                matrixStack.method_22909();
            }
            class_2585 groupName = new class_2585(group.group.getName());
            this.mc.field_1772.method_30883(matrixStack, (class_2561)groupName, (float)(this.guiLeft + 3 + (hasPassword ? 19 : 0)), (float)(startY + 7), 0);
            int textWidth = this.mc.field_1772.method_27525((class_5348)groupName) + (hasPassword ? 19 : 0);
            int headsPerRow = (this.xSize - (3 + textWidth + 3 + 3)) / 9;
            for (int j = 0; j < group.members.size(); ++j) {
                PlayerState state = group.members.get(j);
                int headXIndex = j % headsPerRow;
                int headYIndex = j / headsPerRow;
                if (headYIndex > 1) break;
                int headPosX = this.guiLeft + this.xSize - 8 - 2 - headXIndex * 9;
                int headPosY = startY + 2 + 10 - 10 * headYIndex;
                matrixStack.method_22903();
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderTexture((int)0, (class_2960)SkinUtils.getSkin(state.getGameProfile().getId()));
                matrixStack.method_22904((double)headPosX, (double)headPosY, 0.0);
                class_437.method_25290((class_4587)matrixStack, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
                class_437.method_25290((class_4587)matrixStack, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
                matrixStack.method_22909();
            }
            if (!hoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) continue;
            ArrayList<class_5481> tooltip = new ArrayList<class_5481>();
            tooltip.add(new class_2588("message.voicechat.group_members").method_27692(class_124.field_1068).method_30937());
            for (PlayerState state : group.members) {
                tooltip.add(new class_2585("- " + state.getGameProfile().getName()).method_27692(class_124.field_1080).method_30937());
            }
            this.screen.method_25417(matrixStack, tooltip, mouseX, mouseY);
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(class_4587 matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        List<Group> entries = this.getGroups();
        for (int i = this.getOffset(); i < entries.size() && i < this.getOffset() + this.columnCount; ++i) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            int pos = i - this.getOffset();
            VoiceChatScreenBase.HoverArea hoverArea = this.hoverAreas[pos];
            boolean hovered = hoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY);
            int startY = this.guiTop + pos * this.columnHeight;
            Group group = entries.get(i);
            if (hovered) {
                class_437.method_25290((class_4587)matrixStack, (int)this.guiLeft, (int)startY, (float)195.0f, (float)39.0f, (int)160, (int)this.columnHeight, (int)512, (int)512);
                continue;
            }
            class_437.method_25290((class_4587)matrixStack, (int)this.guiLeft, (int)startY, (float)195.0f, (float)17.0f, (int)160, (int)this.columnHeight, (int)512, (int)512);
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        if (entries.size() > this.columnCount) {
            float h = this.ySize - 17;
            float perc = (float)this.getOffset() / (float)(entries.size() - this.columnCount);
            int posY = this.guiTop + (int)(h * perc);
            class_437.method_25290((class_4587)matrixStack, (int)(this.guiLeft + this.xSize + 6), (int)posY, (float)195.0f, (float)0.0f, (int)12, (int)17, (int)512, (int)512);
        } else {
            class_437.method_25290((class_4587)matrixStack, (int)(this.guiLeft + this.xSize + 6), (int)this.guiTop, (float)207.0f, (float)0.0f, (int)12, (int)17, (int)512, (int)512);
        }
    }

    public int getOffset() {
        List<Group> entries = this.getGroups();
        if (entries.size() <= this.columnCount) {
            this.offset = 0;
        } else if (this.offset > entries.size() - this.columnCount) {
            this.offset = entries.size() - this.columnCount;
        }
        return this.offset;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        List<Group> entries = this.getGroups();
        if (entries.size() > this.columnCount) {
            this.offset = delta < 0.0 ? Math.min(this.getOffset() + 1, entries.size() - this.columnCount) : Math.max(this.getOffset() - 1, 0);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        List<Group> entries = this.getGroups();
        for (int i = 0; i < this.hoverAreas.length && this.getOffset() + i < entries.size(); ++i) {
            if (!this.hoverAreas[i].isHovered(this.guiLeft, this.guiTop, (int)mouseX, (int)mouseY)) continue;
            Group group = entries.get(this.getOffset() + i);
            this.mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            if (group.group.hasPassword()) {
                this.mc.method_1507((class_437)new EnterPasswordScreen(group.group));
                continue;
            }
            NetManager.sendToServer(new JoinGroupPacket(group.group.getId(), null));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public static class Group {
        private final ClientGroup group;
        private final List<PlayerState> members;

        public Group(ClientGroup group) {
            this.group = group;
            this.members = new ArrayList<PlayerState>();
        }
    }
}

