/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.mixin;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import dev.emi.trinkets.TrinketPlayerScreenHandler;
import dev.emi.trinkets.TrinketsNetwork;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.event.TrinketDropCallback;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_3545;
import net.minecraft.class_5131;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    private final Map<String, class_1799> lastEquippedTrinkets = new HashMap<String, class_1799>();

    @Shadow
    protected abstract class_5131 method_6127();

    private LivingEntityMixin() {
        super(null, null);
    }

    @Inject(at={@At(value="HEAD")}, method={"canFreeze"}, cancellable=true)
    private void canFreeze(CallbackInfoReturnable<Boolean> cir) {
        Optional<TrinketComponent> component = TrinketsApi.getTrinketComponent((class_1309)this);
        if (component.isPresent()) {
            for (class_3545<SlotReference, class_1799> equipped : component.get().getAllEquipped()) {
                if (!((class_1799)equipped.method_15441()).method_31573((class_3494)class_3489.field_28041)) continue;
                cir.setReturnValue((Object)false);
                break;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"dropInventory"})
    private void dropInventory(CallbackInfo info) {
        class_1309 entity = (class_1309)this;
        boolean keepInv = entity.field_6002.method_8450().method_8355(class_1928.field_19389);
        TrinketsApi.getTrinketComponent(entity).ifPresent(trinkets -> trinkets.forEach((ref, stack) -> {
            if (stack.method_7960()) {
                return;
            }
            TrinketEnums.DropRule dropRule = TrinketsApi.getTrinket(stack.method_7909()).getDropRule((class_1799)stack, (SlotReference)ref, entity);
            dropRule = ((TrinketDropCallback)TrinketDropCallback.EVENT.invoker()).drop(dropRule, (class_1799)stack, (SlotReference)ref, entity);
            TrinketInventory inventory = ref.inventory();
            if (dropRule == TrinketEnums.DropRule.DEFAULT) {
                dropRule = inventory.getSlotType().getDropRule();
            }
            if (dropRule == TrinketEnums.DropRule.DEFAULT) {
                dropRule = keepInv && entity.method_5864() == class_1299.field_6097 ? TrinketEnums.DropRule.KEEP : (class_1890.method_8221((class_1799)stack) ? TrinketEnums.DropRule.DESTROY : TrinketEnums.DropRule.DROP);
            }
            switch (dropRule) {
                case DROP: {
                    this.method_5775((class_1799)stack);
                }
                case DESTROY: {
                    inventory.method_5447(ref.index(), class_1799.field_8037);
                    break;
                }
            }
        }));
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        class_1309 entity = (class_1309)this;
        TrinketsApi.getTrinketComponent(entity).ifPresent(trinkets -> {
            HashMap newlyEquippedTrinkets = new HashMap();
            HashMap contentUpdates = new HashMap();
            trinkets.clearCachedModifiers();
            trinkets.forEach((ref, stack) -> {
                TrinketInventory inventory = ref.inventory();
                SlotType slotType = inventory.getSlotType();
                int index = ref.index();
                class_1799 oldStack = this.getOldStack(slotType, index);
                class_1799 newStack = inventory.method_5438(index);
                class_1799 copy = newStack.method_7972();
                String newRef = slotType.getGroup() + "/" + slotType.getName() + "/" + index;
                newlyEquippedTrinkets.put(newRef, copy);
                if (!class_1799.method_7973((class_1799)newStack, (class_1799)oldStack)) {
                    if (!this.field_6002.field_9236) {
                        SlotAttributes.SlotEntityAttribute slotAttr;
                        HashSet toRemove;
                        HashMultimap slotMap;
                        Multimap<class_1320, class_1322> map;
                        Trinket trinket;
                        contentUpdates.put(newRef, copy);
                        UUID uuid = SlotAttributes.getUuid(ref);
                        if (!oldStack.method_7960()) {
                            trinket = TrinketsApi.getTrinket(oldStack.method_7909());
                            map = trinket.getModifiers(oldStack, (SlotReference)ref, entity, uuid);
                            slotMap = HashMultimap.create();
                            toRemove = Sets.newHashSet();
                            for (class_1320 attr : map.keySet()) {
                                if (!(attr instanceof SlotAttributes.SlotEntityAttribute)) continue;
                                slotAttr = (SlotAttributes.SlotEntityAttribute)attr;
                                slotMap.putAll((Object)slotAttr.slot, (Iterable)map.get((Object)attr));
                                toRemove.add(slotAttr);
                            }
                            for (class_1320 attr : toRemove) {
                                map.removeAll((Object)attr);
                            }
                            this.method_6127().method_26847(map);
                            trinkets.removeModifiers((Multimap<String, class_1322>)slotMap);
                        }
                        if (!newStack.method_7960()) {
                            trinket = TrinketsApi.getTrinket(newStack.method_7909());
                            map = trinket.getModifiers(newStack, (SlotReference)ref, entity, uuid);
                            slotMap = HashMultimap.create();
                            toRemove = Sets.newHashSet();
                            for (class_1320 attr : map.keySet()) {
                                if (!(attr instanceof SlotAttributes.SlotEntityAttribute)) continue;
                                slotAttr = (SlotAttributes.SlotEntityAttribute)attr;
                                slotMap.putAll((Object)slotAttr.slot, (Iterable)map.get((Object)attr));
                                toRemove.add(slotAttr);
                            }
                            for (class_1320 attr : toRemove) {
                                map.removeAll((Object)attr);
                            }
                            this.method_6127().method_26854(map);
                            trinkets.addTemporaryModifiers((Multimap<String, class_1322>)slotMap);
                        }
                    }
                    if (!newStack.method_7929(oldStack)) {
                        TrinketsApi.getTrinket(oldStack.method_7909()).onUnequip(oldStack, (SlotReference)ref, entity);
                        TrinketsApi.getTrinket(newStack.method_7909()).onEquip(newStack, (SlotReference)ref, entity);
                    }
                }
            });
            if (!this.field_6002.field_9236) {
                Set<TrinketInventory> inventoriesToSend = trinkets.getTrackingUpdates();
                if (!contentUpdates.isEmpty() || !inventoriesToSend.isEmpty()) {
                    class_2540 buf = PacketByteBufs.create();
                    buf.writeInt(entity.method_5628());
                    class_2487 tag = new class_2487();
                    for (TrinketInventory trinketInventory : inventoriesToSend) {
                        tag.method_10566(trinketInventory.getSlotType().getGroup() + "/" + trinketInventory.getSlotType().getName(), (class_2520)trinketInventory.getSyncTag());
                    }
                    buf.method_10794(tag);
                    tag = new class_2487();
                    for (Map.Entry entry : contentUpdates.entrySet()) {
                        tag.method_10566((String)entry.getKey(), (class_2520)((class_1799)entry.getValue()).method_7953(new class_2487()));
                    }
                    buf.method_10794(tag);
                    for (class_3222 class_32222 : PlayerLookup.tracking((class_1297)entity)) {
                        ServerPlayNetworking.send((class_3222)class_32222, (class_2960)TrinketsNetwork.SYNC_INVENTORY, (class_2540)buf);
                    }
                    if (entity instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)entity;
                        ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)TrinketsNetwork.SYNC_INVENTORY, (class_2540)buf);
                        if (!inventoriesToSend.isEmpty()) {
                            ((TrinketPlayerScreenHandler)serverPlayer.field_7498).updateTrinketSlots(false);
                        }
                    }
                    inventoriesToSend.clear();
                }
            }
            this.lastEquippedTrinkets.clear();
            this.lastEquippedTrinkets.putAll(newlyEquippedTrinkets);
        });
    }

    @Unique
    private class_1799 getOldStack(SlotType type, int index) {
        return this.lastEquippedTrinkets.getOrDefault(type.getGroup() + "/" + type.getName() + "/" + index, class_1799.field_8037);
    }
}

