/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets;

import dev.emi.trinkets.TrinketsClient;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_490;

public class TrinketSlot
extends class_1735 {
    private final SlotGroup group;
    private final SlotType type;
    private final boolean alwaysVisible;
    private final int slotOffset;
    private final TrinketInventory trinketInventory;

    public TrinketSlot(TrinketInventory inventory, int index, int x, int y, SlotGroup group, SlotType type, int slotOffset, boolean alwaysVisible) {
        super((class_1263)inventory, index, x, y);
        this.group = group;
        this.type = type;
        this.slotOffset = slotOffset;
        this.alwaysVisible = alwaysVisible;
        this.trinketInventory = inventory;
    }

    public boolean isTrinketFocused() {
        if (TrinketsClient.activeGroup == this.group) {
            return this.slotOffset == 0 || TrinketsClient.activeType == this.type;
        }
        if (TrinketsClient.quickMoveGroup == this.group) {
            return this.slotOffset == 0 || TrinketsClient.quickMoveType == this.type && TrinketsClient.quickMoveTimer > 0;
        }
        return false;
    }

    public class_2960 getBackgroundIdentifier() {
        return this.type.getIcon();
    }

    public boolean method_7680(class_1799 stack) {
        return TrinketSlot.canInsert(stack, new SlotReference(this.trinketInventory, this.slotOffset), this.trinketInventory.getComponent().getEntity());
    }

    public static boolean canInsert(class_1799 stack, SlotReference slotRef, class_1309 entity) {
        boolean res = TrinketsApi.evaluatePredicateSet(slotRef.inventory().getSlotType().getValidatorPredicates(), stack, slotRef, entity);
        if (res) {
            return TrinketsApi.getTrinket(stack.method_7909()).canEquip(stack, slotRef, entity);
        }
        return false;
    }

    public boolean method_7674(class_1657 player) {
        class_1799 stack = this.method_7677();
        return TrinketsApi.getTrinket(stack.method_7909()).canUnequip(stack, new SlotReference(this.trinketInventory, this.slotOffset), (class_1309)player);
    }

    public boolean method_7682() {
        if (this.alwaysVisible) {
            if (this.field_7873 < 0 && this.trinketInventory.getComponent().getEntity().field_6002.field_9236) {
                class_490 screen;
                class_310 client = class_310.method_1551();
                class_437 s = client.field_1755;
                if (s instanceof class_490 && (screen = (class_490)s).method_2659().method_2605()) {
                    return false;
                }
            }
            return true;
        }
        return this.isTrinketFocused();
    }

    public SlotType getType() {
        return this.type;
    }
}

