/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vertices;

import java.nio.ByteBuffer;

public class QuadView {
    private ByteBuffer buffer;
    private int writeOffset;
    private int stride = 48;

    public void setup(ByteBuffer buffer, int writeOffset, int stride) {
        this.buffer = buffer;
        this.writeOffset = writeOffset;
        this.stride = stride;
    }

    public float x(int index) {
        return this.buffer.getFloat(this.writeOffset - this.stride * (4 - index));
    }

    public float y(int index) {
        return this.buffer.getFloat(this.writeOffset + 4 - this.stride * (4 - index));
    }

    public float z(int index) {
        return this.buffer.getFloat(this.writeOffset + 8 - this.stride * (4 - index));
    }

    public float u(int index) {
        return this.buffer.getFloat(this.writeOffset + 16 - this.stride * (4 - index));
    }

    public float v(int index) {
        return this.buffer.getFloat(this.writeOffset + 20 - this.stride * (4 - index));
    }
}

