/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms.transforms;

import net.coderbot.iris.gl.uniform.FloatSupplier;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.SystemTimeUniforms;

public class SmoothedFloat
implements FloatSupplier {
    private static final double LN_OF_2 = Math.log(2.0);
    private final float decayConstant;
    private final FloatSupplier unsmoothed;
    private float accumulator;
    private boolean hasInitialValue;

    public SmoothedFloat(float halfLife, FloatSupplier unsmoothed, FrameUpdateNotifier updateNotifier) {
        double timeConstant = (double)(halfLife *= 0.1f) / LN_OF_2;
        this.decayConstant = (float)(1.0 / timeConstant);
        this.unsmoothed = unsmoothed;
        updateNotifier.addListener(this::update);
    }

    private void update() {
        if (!this.hasInitialValue) {
            this.accumulator = this.unsmoothed.getAsFloat();
            this.hasInitialValue = true;
            return;
        }
        float newValue = this.unsmoothed.getAsFloat();
        float lastFrameTime = SystemTimeUniforms.TIMER.getLastFrameTime();
        float smoothingFactor = 1.0f - SmoothedFloat.exponentialDecayFactor(this.decayConstant, lastFrameTime);
        this.accumulator = SmoothedFloat.lerp(this.accumulator, newValue, smoothingFactor);
    }

    @Override
    public float getAsFloat() {
        if (!this.hasInitialValue) {
            return this.unsmoothed.getAsFloat();
        }
        return this.accumulator;
    }

    private static float exponentialDecayFactor(float k, float t) {
        return (float)Math.exp(-k * t);
    }

    private static float lerp(float v0, float v1, float t) {
        return (1.0f - t) * v0 + t * v1;
    }
}

