/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.rendertarget;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.rendertarget.DepthTexture;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.minecraft.class_276;

public class RenderTargets {
    private final RenderTarget[] targets;
    private final DepthTexture depthTexture;
    private final DepthTexture noTranslucents;
    private final DepthTexture noHand;
    private final List<GlFramebuffer> ownedFramebuffers;
    private int cachedWidth;
    private int cachedHeight;
    private boolean fullClearRequired;
    private boolean destroyed = false;

    public RenderTargets(class_276 reference, PackRenderTargetDirectives directives) {
        this(reference.field_1482, reference.field_1481, directives.getRenderTargetSettings());
    }

    public RenderTargets(int width, int height, Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> renderTargets) {
        this.targets = new RenderTarget[renderTargets.size()];
        renderTargets.forEach((index, settings) -> {
            this.targets[index.intValue()] = RenderTarget.builder().setDimensions(width, height).setInternalFormat(settings.getRequestedFormat()).build();
        });
        this.depthTexture = new DepthTexture(width, height);
        this.noTranslucents = new DepthTexture(width, height);
        this.noHand = new DepthTexture(width, height);
        this.cachedWidth = width;
        this.cachedHeight = height;
        this.ownedFramebuffers = new ArrayList<GlFramebuffer>();
        this.fullClearRequired = true;
    }

    public void destroy() {
        this.destroyed = true;
        for (GlFramebuffer owned : this.ownedFramebuffers) {
            owned.destroy();
        }
        for (RenderTarget target : this.targets) {
            target.destroy();
        }
        this.depthTexture.destroy();
        this.noTranslucents.destroy();
        this.noHand.destroy();
    }

    public int getRenderTargetCount() {
        return this.targets.length;
    }

    public RenderTarget get(int index) {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed RenderTargets");
        }
        return this.targets[index];
    }

    public DepthTexture getDepthTexture() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed RenderTargets");
        }
        return this.depthTexture;
    }

    public DepthTexture getDepthTextureNoTranslucents() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed RenderTargets");
        }
        return this.noTranslucents;
    }

    public DepthTexture getDepthTextureNoHand() {
        return this.noHand;
    }

    public void resizeIfNeeded(int newWidth, int newHeight) {
        if (newWidth == this.cachedWidth && newHeight == this.cachedHeight) {
            return;
        }
        this.cachedWidth = newWidth;
        this.cachedHeight = newHeight;
        for (RenderTarget target : this.targets) {
            target.resize(newWidth, newHeight);
        }
        this.depthTexture.resize(newWidth, newHeight);
        this.noTranslucents.resize(newWidth, newHeight);
        this.noHand.resize(newWidth, newHeight);
        this.fullClearRequired = true;
    }

    public boolean isFullClearRequired() {
        return this.fullClearRequired;
    }

    public void onFullClear() {
        this.fullClearRequired = false;
    }

    public GlFramebuffer createFramebufferWritingToMain(int[] drawBuffers) {
        return this.createFullFramebuffer(false, drawBuffers);
    }

    public GlFramebuffer createFramebufferWritingToAlt(int[] drawBuffers) {
        return this.createFullFramebuffer(true, drawBuffers);
    }

    private ImmutableSet<Integer> invert(ImmutableSet<Integer> base, int[] relevant) {
        ImmutableSet.Builder inverted = ImmutableSet.builder();
        for (int i : relevant) {
            if (base.contains((Object)i)) continue;
            inverted.add((Object)i);
        }
        return inverted.build();
    }

    public GlFramebuffer createGbufferFramebuffer(ImmutableSet<Integer> stageWritesToAlt, int[] drawBuffers) {
        if (drawBuffers.length == 0) {
            throw new IllegalArgumentException("Framebuffer must have at least one color buffer");
        }
        ImmutableSet<Integer> stageWritesToMain = this.invert(stageWritesToAlt, drawBuffers);
        GlFramebuffer framebuffer = this.createColorFramebuffer(stageWritesToMain, drawBuffers);
        framebuffer.addDepthAttachment(this.getDepthTexture().getTextureId());
        return framebuffer;
    }

    private GlFramebuffer createFullFramebuffer(boolean clearsAlt, int[] drawBuffers) {
        if (drawBuffers.length == 0) {
            throw new IllegalArgumentException("Framebuffer must have at least one color buffer");
        }
        ImmutableSet<Integer> stageWritesToMain = ImmutableSet.of();
        if (!clearsAlt) {
            stageWritesToMain = this.invert((ImmutableSet<Integer>)ImmutableSet.of(), drawBuffers);
        }
        return this.createColorFramebufferWithDepth(stageWritesToMain, drawBuffers);
    }

    public GlFramebuffer createColorFramebufferWithDepth(ImmutableSet<Integer> stageWritesToMain, int[] drawBuffers) {
        GlFramebuffer framebuffer = this.createColorFramebuffer(stageWritesToMain, drawBuffers);
        framebuffer.addDepthAttachment(this.getDepthTexture().getTextureId());
        return framebuffer;
    }

    public GlFramebuffer createColorFramebuffer(ImmutableSet<Integer> stageWritesToMain, int[] drawBuffers) {
        if (drawBuffers.length == 0) {
            throw new IllegalArgumentException("Framebuffer must have at least one color buffer");
        }
        GlFramebuffer framebuffer = new GlFramebuffer();
        this.ownedFramebuffers.add(framebuffer);
        int[] actualDrawBuffers = new int[drawBuffers.length];
        for (int i = 0; i < drawBuffers.length; ++i) {
            actualDrawBuffers[i] = i;
            if (drawBuffers[i] >= this.getRenderTargetCount()) {
                throw new IllegalStateException("Render target with index " + drawBuffers[i] + " is not supported, only " + this.getRenderTargetCount() + " render targets are supported.");
            }
            RenderTarget target = this.get(drawBuffers[i]);
            int textureId = stageWritesToMain.contains((Object)drawBuffers[i]) ? target.getMainTexture() : target.getAltTexture();
            framebuffer.addColorAttachment(i, textureId);
        }
        framebuffer.drawBuffers(actualDrawBuffers);
        framebuffer.readBuffer(0);
        if (!framebuffer.isComplete()) {
            throw new IllegalStateException("Unexpected error while creating framebuffer");
        }
        return framebuffer;
    }

    public int getCurrentWidth() {
        return this.cachedWidth;
    }

    public int getCurrentHeight() {
        return this.cachedHeight;
    }
}

