/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import wraith.waystones.Waystones;
import wraith.waystones.util.Config;
import wraith.waystones.util.Utils;

public final class WaystonesWorldgen {
    public static final HashSet<class_2960> WAYSTONE_STRUCTURES = new HashSet();
    public static final HashMap<class_2960, class_2960> VANILLA_VILLAGES = new HashMap();

    private WaystonesWorldgen() {
    }

    public static void registerVillage(MinecraftServer server, class_2960 village, class_2960 waystone) {
        if (Config.getInstance().generateInVillages()) {
            Waystones.LOGGER.info("Adding waystone " + waystone.toString() + " to village " + village.toString());
            Utils.addToStructurePool(server, village, waystone, 5);
        }
    }

    public static void registerVanillaVillageWorldgen(MinecraftServer server) {
        for (Map.Entry<class_2960, class_2960> entry : VANILLA_VILLAGES.entrySet()) {
            WaystonesWorldgen.registerVillage(server, entry.getKey(), entry.getValue());
        }
    }

    static {
        WAYSTONE_STRUCTURES.add(new class_2960("waystones:desert_village_waystone"));
        WAYSTONE_STRUCTURES.add(new class_2960("waystones:mossy_stone_brick_village_waystone"));
        WAYSTONE_STRUCTURES.add(new class_2960("waystones:nether_brick_village_waystone"));
        WAYSTONE_STRUCTURES.add(new class_2960("waystones:red_desert_village_waystone"));
        WAYSTONE_STRUCTURES.add(new class_2960("waystones:red_nether_brick_village_waystone"));
        WAYSTONE_STRUCTURES.add(new class_2960("waystones:stone_brick_village_waystone"));
        WAYSTONE_STRUCTURES.add(new class_2960("waystones:village_waystone"));
        VANILLA_VILLAGES.put(new class_2960("village/plains/houses"), new class_2960("waystones:village_waystone"));
        VANILLA_VILLAGES.put(new class_2960("village/desert/houses"), new class_2960("waystones:desert_village_waystone"));
        VANILLA_VILLAGES.put(new class_2960("village/savanna/houses"), new class_2960("waystones:village_waystone"));
        VANILLA_VILLAGES.put(new class_2960("village/taiga/houses"), new class_2960("waystones:village_waystone"));
        VANILLA_VILLAGES.put(new class_2960("village/snowy/houses"), new class_2960("waystones:village_waystone"));
    }
}

