/*
 * Decompiled with CFR 0.152.
 */
package win.baruna.blockmeter.measurebox;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import win.baruna.blockmeter.BlockMeterClient;
import win.baruna.blockmeter.ModConfig;
import win.baruna.blockmeter.measurebox.MeasureBox;

public class ClientMeasureBox
extends MeasureBox {
    private class_238 box;

    protected ClientMeasureBox(class_2338 blockStart, class_2338 blockEnd, class_2960 dimension, class_1767 color, boolean finished, int mode, int orientation) {
        super(blockStart, blockEnd, dimension, color, finished, mode, orientation);
        this.updateBoundingBox();
    }

    protected ClientMeasureBox(class_2540 attachedData) {
        super(attachedData);
        this.updateBoundingBox();
    }

    public static ClientMeasureBox getBox(class_2338 block, class_2960 dimension) {
        ClientMeasureBox box = new ClientMeasureBox(block, block, dimension, ClientMeasureBox.getSelectedColor(), false, 0, 0);
        ClientMeasureBox.incrementColor();
        return box;
    }

    public void setBlockEnd(class_2338 block) {
        this.blockEnd = block;
        this.updateBoundingBox();
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished() {
        this.finished = true;
    }

    public void setColor(class_1767 color) {
        this.color = color;
    }

    public boolean isCorner(class_2338 block) {
        return !(block.method_10263() != this.blockStart.method_10263() && block.method_10263() != this.blockEnd.method_10263() || block.method_10264() != this.blockStart.method_10264() && block.method_10264() != this.blockEnd.method_10264() || block.method_10260() != this.blockStart.method_10260() && block.method_10260() != this.blockEnd.method_10260());
    }

    public void loosenCorner(class_2338 block) {
        int x = this.blockStart.method_10263() == block.method_10263() ? this.blockEnd.method_10263() : this.blockStart.method_10263();
        int y = this.blockStart.method_10264() == block.method_10264() ? this.blockEnd.method_10264() : this.blockStart.method_10264();
        int z = this.blockStart.method_10260() == block.method_10260() ? this.blockEnd.method_10260() : this.blockStart.method_10260();
        this.blockStart = new class_2338(x, y, z);
        this.blockEnd = block;
        this.finished = false;
    }

    public void render(class_4184 camera, class_4587 stack, class_2960 currentDimension) {
        this.render(camera, stack, currentDimension, null);
    }

    public void render(class_4184 camera, class_4587 stack, class_2960 currentDimension, class_2561 boxCreatorName) {
        if (!currentDimension.equals((Object)this.dimension)) {
            return;
        }
        class_243 pos = camera.method_19326();
        RenderSystem.lineWidth((float)2.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.disableBlend();
        stack.method_22903();
        stack.method_22904(-pos.field_1352, -pos.field_1351, -pos.field_1350);
        class_1159 model = stack.method_23760().method_23761();
        class_289 tess = class_289.method_1348();
        class_287 buffer = tess.method_1349();
        float[] color = this.color.method_7787();
        float r = color[0];
        float g = color[1];
        float b = color[2];
        float a = 0.8f;
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        buffer.method_22918(model, (float)this.box.field_1323, (float)this.box.field_1322, (float)this.box.field_1321).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1320, (float)this.box.field_1322, (float)this.box.field_1321).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1320, (float)this.box.field_1322, (float)this.box.field_1324).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1323, (float)this.box.field_1322, (float)this.box.field_1324).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1323, (float)this.box.field_1322, (float)this.box.field_1321).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1323, (float)this.box.field_1325, (float)this.box.field_1321).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1323, (float)this.box.field_1325, (float)this.box.field_1321).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1320, (float)this.box.field_1325, (float)this.box.field_1321).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1320, (float)this.box.field_1325, (float)this.box.field_1324).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1323, (float)this.box.field_1325, (float)this.box.field_1324).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1323, (float)this.box.field_1325, (float)this.box.field_1321).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1323, (float)this.box.field_1325, (float)this.box.field_1324).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1323, (float)this.box.field_1322, (float)this.box.field_1324).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1320, (float)this.box.field_1322, (float)this.box.field_1324).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1320, (float)this.box.field_1325, (float)this.box.field_1324).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1320, (float)this.box.field_1325, (float)this.box.field_1321).method_22915(r, g, b, 0.8f).method_1344();
        buffer.method_22918(model, (float)this.box.field_1320, (float)this.box.field_1322, (float)this.box.field_1321).method_22915(r, g, b, 0.8f).method_1344();
        tess.method_1350();
        if (((ModConfig)BlockMeterClient.getConfigManager().getConfig()).innerDiagonal) {
            buffer.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
            buffer.method_22918(model, (float)this.box.field_1323, (float)this.box.field_1322, (float)this.box.field_1321).method_22915(r, g, b, 0.8f).method_1344();
            buffer.method_22918(model, (float)this.box.field_1320, (float)this.box.field_1325, (float)this.box.field_1324).method_22915(r, g, b, 0.8f).method_1344();
            tess.method_1350();
        }
        RenderSystem.enableTexture();
        RenderSystem.lineWidth((float)1.0f);
        this.drawLengths(camera, stack, boxCreatorName);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        stack.method_22909();
    }

    private void updateBoundingBox() {
        int ax = this.blockStart.method_10263();
        int ay = this.blockStart.method_10264();
        int az = this.blockStart.method_10260();
        int bx = this.blockEnd.method_10263();
        int by = this.blockEnd.method_10264();
        int bz = this.blockEnd.method_10260();
        this.box = new class_238((double)Math.min(ax, bx), (double)Math.min(ay, by), (double)Math.min(az, bz), (double)(Math.max(ax, bx) + 1), (double)(Math.max(ay, by) + 1), (double)(Math.max(az, bz) + 1));
    }

    private void drawLengths(class_4184 camera, class_4587 stack, class_2561 boxCreatorName) {
        String playerNameStr;
        int lengthX = (int)this.box.method_17939();
        int lengthY = (int)this.box.method_17940();
        int lengthZ = (int)this.box.method_17941();
        class_243 boxCenter = this.box.method_1005();
        double diagonalLength = new class_243(this.box.field_1323, this.box.field_1322, this.box.field_1321).method_1022(new class_243(this.box.field_1320, this.box.field_1325, this.box.field_1324));
        float yaw = camera.method_19330();
        float pitch = camera.method_19329();
        class_243 pos = camera.method_19326();
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(new Line(new class_238(this.box.field_1323, this.box.field_1322, this.box.field_1321, this.box.field_1323, this.box.field_1322, this.box.field_1324), pos));
        lines.add(new Line(new class_238(this.box.field_1323, this.box.field_1325, this.box.field_1321, this.box.field_1323, this.box.field_1325, this.box.field_1324), pos));
        lines.add(new Line(new class_238(this.box.field_1320, this.box.field_1322, this.box.field_1321, this.box.field_1320, this.box.field_1322, this.box.field_1324), pos));
        lines.add(new Line(new class_238(this.box.field_1320, this.box.field_1325, this.box.field_1321, this.box.field_1320, this.box.field_1325, this.box.field_1324), pos));
        Collections.sort(lines);
        class_243 lineZ = ((Line)lines.get((int)0)).line.method_1005();
        lines.clear();
        lines.add(new Line(new class_238(this.box.field_1323, this.box.field_1322, this.box.field_1321, this.box.field_1323, this.box.field_1325, this.box.field_1321), pos));
        lines.add(new Line(new class_238(this.box.field_1323, this.box.field_1322, this.box.field_1324, this.box.field_1323, this.box.field_1325, this.box.field_1324), pos));
        lines.add(new Line(new class_238(this.box.field_1320, this.box.field_1322, this.box.field_1321, this.box.field_1320, this.box.field_1325, this.box.field_1321), pos));
        lines.add(new Line(new class_238(this.box.field_1320, this.box.field_1322, this.box.field_1324, this.box.field_1320, this.box.field_1325, this.box.field_1324), pos));
        Collections.sort(lines);
        class_243 lineY = ((Line)lines.get((int)0)).line.method_1005();
        lines.clear();
        lines.add(new Line(new class_238(this.box.field_1323, this.box.field_1322, this.box.field_1321, this.box.field_1320, this.box.field_1322, this.box.field_1321), pos));
        lines.add(new Line(new class_238(this.box.field_1323, this.box.field_1322, this.box.field_1324, this.box.field_1320, this.box.field_1322, this.box.field_1324), pos));
        lines.add(new Line(new class_238(this.box.field_1323, this.box.field_1325, this.box.field_1321, this.box.field_1320, this.box.field_1325, this.box.field_1321), pos));
        lines.add(new Line(new class_238(this.box.field_1323, this.box.field_1325, this.box.field_1324, this.box.field_1320, this.box.field_1325, this.box.field_1324), pos));
        Collections.sort(lines);
        class_243 lineX = ((Line)lines.get((int)0)).line.method_1005();
        String string = playerNameStr = boxCreatorName == null ? "" : boxCreatorName.getString() + " : ";
        if (((ModConfig)BlockMeterClient.getConfigManager().getConfig()).innerDiagonal) {
            this.drawText(stack, boxCenter.field_1352, boxCenter.field_1351, boxCenter.field_1350, yaw, pitch, playerNameStr + String.format("%.2f", diagonalLength), pos);
        }
        this.drawText(stack, lineX.field_1352, lineX.field_1351, lineX.field_1350, yaw, pitch, playerNameStr + String.valueOf(lengthX), pos);
        this.drawText(stack, lineY.field_1352, lineY.field_1351, lineY.field_1350, yaw, pitch, playerNameStr + String.valueOf(lengthY), pos);
        this.drawText(stack, lineZ.field_1352, lineZ.field_1351, lineZ.field_1350, yaw, pitch, playerNameStr + String.valueOf(lengthZ), pos);
    }

    private void drawText(class_4587 stack, double x, double y, double z, float yaw, float pitch, String text, class_243 playerPos) {
        float dist;
        class_327 textRenderer = class_310.method_1551().field_1772;
        class_2585 literalText = new class_2585(text);
        float size = 0.03f;
        int constDist = 10;
        if (((ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig()).minimalLabelSize && (dist = (float)Math.sqrt((x - playerPos.field_1352) * (x - playerPos.field_1352) + (y - playerPos.field_1351) * (y - playerPos.field_1351) + (z - playerPos.field_1350) * (z - playerPos.field_1350))) > 10.0f) {
            size = dist * size / 10.0f;
        }
        stack.method_22903();
        stack.method_22904(x, y + 0.15, z);
        stack.method_22907(class_1160.field_20705.method_23214(180.0f - yaw));
        stack.method_22907(class_1160.field_20703.method_23214(-pitch));
        stack.method_22905(size, -size, 0.001f);
        int width = textRenderer.method_27525((class_5348)literalText);
        stack.method_22904((double)(-width / 2), 0.0, 0.0);
        class_1159 model = stack.method_23760().method_23761();
        class_287 buffer = class_289.method_1348().method_1349();
        int textColor = this.color.method_16357();
        ModConfig conf = (ModConfig)BlockMeterClient.getConfigManager().getConfig();
        if (conf.backgroundForLabels) {
            float[] colors = this.color.method_7787();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            buffer.method_22918(model, -1.0f, -1.0f, 0.0f).method_22915(colors[0], colors[1], colors[2], 0.8f).method_1344();
            buffer.method_22918(model, -1.0f, 8.0f, 0.0f).method_22915(colors[0], colors[1], colors[2], 0.8f).method_1344();
            buffer.method_22918(model, (float)width, 8.0f, 0.0f).method_22915(colors[0], colors[1], colors[2], 0.8f).method_1344();
            buffer.method_22918(model, (float)width, -1.0f, 0.0f).method_22915(colors[0], colors[1], colors[2], 0.8f).method_1344();
            class_289.method_1348().method_1350();
            float[] components = this.color.method_7787();
            float luminance = 0.299f * components[0] + 0.587f * components[1] + 0.114f * components[2];
            textColor = luminance < 0.4f ? class_1767.field_7952.method_16357() : class_1767.field_7963.method_16357();
        }
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)buffer);
        textRenderer.method_30882((class_2561)literalText, 0.0f, 0.0f, textColor, !conf.backgroundForLabels, model, (class_4597)immediate, true, 0, 0xF000F0);
        immediate.method_22993();
        stack.method_22909();
    }

    private static void incrementColor() {
        ModConfig conf = (ModConfig)BlockMeterClient.getConfigManager().getConfig();
        if (conf.incrementColor) {
            ClientMeasureBox.setColorIndex(conf.colorIndex + 1);
        }
    }

    private static class_1767 getSelectedColor() {
        ModConfig conf = (ModConfig)BlockMeterClient.getConfigManager().getConfig();
        return class_1767.method_7791((int)conf.colorIndex);
    }

    public static void setColorIndex(int newColor) {
        ((ModConfig)BlockMeterClient.getConfigManager().getConfig()).colorIndex = Math.floorMod(newColor, class_1767.values().length);
        BlockMeterClient.getConfigManager().save();
    }

    public static ClientMeasureBox fromPacketByteBuf(class_2540 attachedData) {
        return new ClientMeasureBox(attachedData);
    }

    private class Line
    implements Comparable<Line> {
        class_238 line;
        double distance;

        Line(class_238 line, class_243 pos) {
            this.line = line;
            this.distance = line.method_1005().method_1022(pos);
        }

        @Override
        public int compareTo(Line l) {
            return Double.compare(this.distance, l.distance);
        }
    }
}

