/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics;

import com.sonicether.soundphysics.SoundPhysics;
import com.sonicether.soundphysics.SoundPhysicsMod;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class RaycastFix {
    private static long lastUpdate = 0L;
    private static final Map<Long, class_265> shapeCache = new Long2ObjectOpenHashMap(65536, 0.75f);
    private static final class_310 mc = class_310.method_1551();

    public static void updateCache() {
        long gameTime = class_310.method_1551().field_1687.method_8510();
        if (lastUpdate != gameTime) {
            if (!shapeCache.isEmpty() && SoundPhysicsMod.CONFIG.performanceLogging.get().booleanValue()) {
                SoundPhysics.LOGGER.info("Clearing {} raycasting block cache entries", (Object)shapeCache.size());
            }
            shapeCache.clear();
            lastUpdate = gameTime;
        }
    }

    public static class_3965 fixedRaycast(class_243 start, class_243 end, @Nullable class_2338 ignore) {
        class_3959 context = new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1345, (class_1297)RaycastFix.mc.field_1724);
        return RaycastFix.traverseBlocks(context.method_17750(), context.method_17747(), context, (c, pos) -> {
            double fluidLocation;
            if (new class_2338((class_2382)pos).equals((Object)ignore)) {
                return null;
            }
            class_2680 blockState = RaycastFix.mc.field_1687.method_8320(pos);
            class_3610 fluidState = RaycastFix.mc.field_1687.method_8316(pos);
            class_265 blockShape = shapeCache.computeIfAbsent(pos.method_10063(), key -> blockState.method_26220((class_1922)RaycastFix.mc.field_1687, pos));
            class_3965 blockHit = RaycastFix.mc.field_1687.method_17745(start, end, pos, blockShape, blockState);
            class_265 fluidShape = shapeCache.computeIfAbsent(pos.method_10063(), key -> context.method_17749(fluidState, (class_1922)RaycastFix.mc.field_1687, pos));
            class_3965 fluidHit = fluidShape.method_1092(start, end, pos);
            if (fluidHit == null) {
                return blockHit;
            }
            if (blockHit == null) {
                return fluidHit;
            }
            double blockLocation = start.method_1025(blockHit.method_17784());
            return blockLocation <= (fluidLocation = start.method_1025(fluidHit.method_17784())) ? blockHit : fluidHit;
        }, c -> class_3965.method_17778((class_243)context.method_17747(), null, (class_2338)new class_2338(context.method_17747())));
    }

    private static <T, C> T traverseBlocks(class_243 start, class_243 end, C context, BiFunction<C, class_2338, T> blockHitFactory, Function<C, T> missFactory) {
        int k;
        int j;
        if (start.equals((Object)end)) {
            return missFactory.apply(context);
        }
        double d0 = class_3532.method_16436((double)-1.0E-7, (double)end.field_1352, (double)start.field_1352);
        double d1 = class_3532.method_16436((double)-1.0E-7, (double)end.field_1351, (double)start.field_1351);
        double d2 = class_3532.method_16436((double)-1.0E-7, (double)end.field_1350, (double)start.field_1350);
        double d3 = class_3532.method_16436((double)-1.0E-7, (double)start.field_1352, (double)end.field_1352);
        double d4 = class_3532.method_16436((double)-1.0E-7, (double)start.field_1351, (double)end.field_1351);
        double d5 = class_3532.method_16436((double)-1.0E-7, (double)start.field_1350, (double)end.field_1350);
        int i = class_3532.method_15357((double)d3);
        class_2338.class_2339 pos = new class_2338.class_2339(i, j = class_3532.method_15357((double)d4), k = class_3532.method_15357((double)d5));
        T t = blockHitFactory.apply(context, (class_2338)pos);
        if (t != null) {
            return t;
        }
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        int l = class_3532.method_17822((double)d6);
        int i1 = class_3532.method_17822((double)d7);
        int j1 = class_3532.method_17822((double)d8);
        double d9 = l == 0 ? Double.MAX_VALUE : (double)l / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l > 0 ? 1.0 - class_3532.method_15385((double)d3) : class_3532.method_15385((double)d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - class_3532.method_15385((double)d4) : class_3532.method_15385((double)d4));
        double d14 = d11 * (j1 > 0 ? 1.0 - class_3532.method_15385((double)d5) : class_3532.method_15385((double)d5));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    i += l;
                    d12 += d9;
                } else {
                    k += j1;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                j += i1;
                d13 += d10;
            } else {
                k += j1;
                d14 += d11;
            }
            if ((t1 = blockHitFactory.apply(context, (class_2338)pos.method_10103(i, j, k))) == null) continue;
            return t1;
        }
        return missFactory.apply(context);
    }
}

