/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client.config;

import com.google.common.collect.ImmutableMap;
import ladysnake.illuminations.client.data.AuraSettings;
import ladysnake.illuminations.client.data.BiomeSettings;
import ladysnake.illuminations.client.enums.BiomeCategory;
import ladysnake.illuminations.client.enums.EyesInTheDarkSpawnRate;
import ladysnake.illuminations.client.enums.FireflySpawnRate;
import ladysnake.illuminations.client.enums.GlowwormSpawnRate;
import ladysnake.illuminations.client.enums.HalloweenFeatures;
import ladysnake.illuminations.client.enums.PlanktonSpawnRate;
import ladysnake.illuminations.client.enums.WillOWispsSpawnRate;

public final class DefaultConfig {
    public static final HalloweenFeatures HALLOWEEN_FEATURES = HalloweenFeatures.ENABLE;
    public static final EyesInTheDarkSpawnRate EYES_IN_THE_DARK_SPAWN_RATE = EyesInTheDarkSpawnRate.MEDIUM;
    public static final WillOWispsSpawnRate WILL_O_WISPS_SPAWN_RATE = WillOWispsSpawnRate.MEDIUM;
    public static final int CHORUS_PETALS_SPAWN_MULTIPLIER = 1;
    public static final int DENSITY = 100;
    public static final boolean FIREFLY_SPAWN_ALWAYS = false;
    public static final boolean FIREFLY_SPAWN_UNDERGROUND = false;
    public static final int FIREFLY_WHITE_ALPHA = 100;
    public static final boolean FIREFLY_RAINBOW = false;
    public static final boolean AUTO_UPDATE = false;
    public static final boolean DEBUG_MODE = false;
    public static final boolean VIEW_AURAS_FP = false;
    public static final boolean DISPLAY_GREETING_SCREEN = true;
    public static final boolean DISPLAY_DONATION_TOAST = true;
    public static final ImmutableMap<BiomeCategory, BiomeSettings> BIOME_SETTINGS = ImmutableMap.builder().put((Object)BiomeCategory.FOREST, (Object)new BiomeSettings(FireflySpawnRate.MEDIUM, 0xBFFF00, GlowwormSpawnRate.MEDIUM, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.TAIGA, (Object)new BiomeSettings(FireflySpawnRate.LOW, 0xBFFF00, GlowwormSpawnRate.LOW, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.SNOWY, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 49151, GlowwormSpawnRate.DISABLE, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.PLAINS, (Object)new BiomeSettings(FireflySpawnRate.LOW, 0xBFFF00, GlowwormSpawnRate.LOW, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.DESERT, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 16754517, GlowwormSpawnRate.DISABLE, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.SAVANNA, (Object)new BiomeSettings(FireflySpawnRate.LOW, 0xBFFF00, GlowwormSpawnRate.LOW, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.JUNGLE, (Object)new BiomeSettings(FireflySpawnRate.LOW, 65313, GlowwormSpawnRate.LOW, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.BEACH, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0xBFFF00, GlowwormSpawnRate.DISABLE, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.SWAMP, (Object)new BiomeSettings(FireflySpawnRate.HIGH, 40704, GlowwormSpawnRate.HIGH, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.RIVER, (Object)new BiomeSettings(FireflySpawnRate.MEDIUM, 0xBFFF00, GlowwormSpawnRate.MEDIUM, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.OCEAN, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0xBFFF00, GlowwormSpawnRate.DISABLE, PlanktonSpawnRate.HIGH)).put((Object)BiomeCategory.WARM_OCEAN, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0xBFFF00, GlowwormSpawnRate.DISABLE, PlanktonSpawnRate.HIGH)).put((Object)BiomeCategory.BADLANDS, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0xBFFF00, GlowwormSpawnRate.DISABLE, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.MOUNTAINS, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0xBFFF00, GlowwormSpawnRate.DISABLE, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.DRIPSTONE_CAVES, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0xBFFF00, GlowwormSpawnRate.DISABLE, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.LUSH_CAVES, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 15436081, GlowwormSpawnRate.DISABLE, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.MUSHROOM, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0xFF7F8F, GlowwormSpawnRate.DISABLE, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.THE_VOID, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0x8000FF, GlowwormSpawnRate.DISABLE, PlanktonSpawnRate.DISABLE)).put((Object)BiomeCategory.NETHER_WASTES, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0xFF8000, null, null)).put((Object)BiomeCategory.CRIMSON_FOREST, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0xFF8000, null, null)).put((Object)BiomeCategory.WARPED_FOREST, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 32896, null, null)).put((Object)BiomeCategory.SOUL_SAND_VALLEY, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 65535, null, null)).put((Object)BiomeCategory.BASALT_DELTAS, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0xFF8000, null, null)).put((Object)BiomeCategory.THE_END, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0x8000FF, null, null)).put((Object)BiomeCategory.SMALL_END_ISLANDS, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0x8000FF, null, null)).put((Object)BiomeCategory.END_MIDLANDS, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0x8000FF, null, null)).put((Object)BiomeCategory.END_HIGHLANDS, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0x8000FF, null, null)).put((Object)BiomeCategory.END_BARRENS, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0x8000FF, null, null)).put((Object)BiomeCategory.OTHER, (Object)new BiomeSettings(FireflySpawnRate.DISABLE, 0xBFFF00, GlowwormSpawnRate.DISABLE, PlanktonSpawnRate.DISABLE)).build();
    public static final ImmutableMap<String, AuraSettings> AURA_SETTINGS = ImmutableMap.builder().put((Object)"twilight", (Object)new AuraSettings(0.1f, 1)).put((Object)"ghostly", (Object)new AuraSettings(0.1f, 1)).put((Object)"chorus", (Object)new AuraSettings(0.1f, 1)).put((Object)"autumn_leaves", (Object)new AuraSettings(0.3f, 1)).put((Object)"sculk_tendrils", (Object)new AuraSettings(0.1f, 1)).put((Object)"shadowbringer_soul", (Object)new AuraSettings(0.1f, 1)).put((Object)"goldenrod", (Object)new AuraSettings(0.4f, 1)).put((Object)"confetti", (Object)new AuraSettings(0.1f, 1)).put((Object)"prismatic_confetti", (Object)new AuraSettings(0.1f, 1)).put((Object)"prismarine", (Object)new AuraSettings(0.1f, 1)).build();

    private DefaultConfig() {
        throw new UnsupportedOperationException();
    }

    public static BiomeSettings getBiomeSettings(BiomeCategory biome) {
        return (BiomeSettings)BIOME_SETTINGS.get((Object)biome);
    }

    public static AuraSettings getAuraSettings(String aura) {
        return (AuraSettings)AURA_SETTINGS.get((Object)aura);
    }
}

