/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client;

import com.google.common.base.CaseFormat;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.HashMap;
import ladysnake.illuminations.client.config.Config;
import ladysnake.illuminations.client.config.DefaultConfig;
import ladysnake.illuminations.client.data.BiomeSettings;
import ladysnake.illuminations.client.enums.BiomeCategory;
import ladysnake.illuminations.client.enums.EyesInTheDarkSpawnRate;
import ladysnake.illuminations.client.enums.FireflySpawnRate;
import ladysnake.illuminations.client.enums.GlowwormSpawnRate;
import ladysnake.illuminations.client.enums.HalloweenFeatures;
import ladysnake.illuminations.client.enums.PlanktonSpawnRate;
import ladysnake.illuminations.client.enums.WillOWispsSpawnRate;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5348;

public class IlluminationsModMenuIntegration
implements ModMenuApi {
    private ConfigBuilder builder;
    private ConfigEntryBuilder entryBuilder;

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            Config.load();
            this.builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)new class_2588("title.illuminations.config"));
            this.builder.setSavingRunnable(Config::save);
            this.entryBuilder = this.builder.entryBuilder();
            this.GenerateGeneralSettings();
            this.GenerateBiomeSettings();
            return this.builder.build();
        };
    }

    private void GenerateGeneralSettings() {
        ConfigCategory general = this.builder.getOrCreateCategory((class_2561)new class_2588("category.illuminations.general"));
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startEnumSelector((class_2561)new class_2588("option.illuminations.halloweenFeatures"), HalloweenFeatures.class, (Enum)Config.getHalloweenFeatures()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.halloweenFeatures"), new class_2588("option.tooltip.illuminations.halloweenFeatures.default"), new class_2588("option.tooltip.illuminations.halloweenFeatures.enable"), new class_2588("option.tooltip.illuminations.halloweenFeatures.disable"), new class_2588("option.tooltip.illuminations.halloweenFeatures.always")}).setSaveConsumer(Config::setHalloweenFeatures).setDefaultValue((Enum)DefaultConfig.HALLOWEEN_FEATURES).build());
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startEnumSelector((class_2561)new class_2588("option.illuminations.eyesInTheDarkSpawnRate"), EyesInTheDarkSpawnRate.class, (Enum)Config.getEyesInTheDarkSpawnRate()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.eyesInTheDarkSpawnRate"), new class_2588("option.tooltip.illuminations.eyesInTheDarkSpawnRate.default"), new class_2588("option.tooltip.illuminations.eyesInTheDarkSpawnRate.low"), new class_2588("option.tooltip.illuminations.eyesInTheDarkSpawnRate.medium"), new class_2588("option.tooltip.illuminations.eyesInTheDarkSpawnRate.high")}).setSaveConsumer(Config::setEyesInTheDarkSpawnRate).setDefaultValue((Enum)DefaultConfig.EYES_IN_THE_DARK_SPAWN_RATE).build());
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startEnumSelector((class_2561)new class_2588("option.illuminations.willOWispsSpawnRate"), WillOWispsSpawnRate.class, (Enum)Config.getWillOWispsSpawnRate()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.willOWispsSpawnRate"), new class_2588("option.tooltip.illuminations.willOWispsSpawnRate.default"), new class_2588("option.tooltip.illuminations.willOWispsSpawnRate.disable"), new class_2588("option.tooltip.illuminations.willOWispsSpawnRate.low"), new class_2588("option.tooltip.illuminations.willOWispsSpawnRate.medium"), new class_2588("option.tooltip.illuminations.willOWispsSpawnRate.high")}).setSaveConsumer(Config::setWillOWispsSpawnRate).setDefaultValue((Enum)DefaultConfig.WILL_O_WISPS_SPAWN_RATE).build());
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startIntSlider((class_2561)new class_2588("option.illuminations.chorusPetalsSpawnMultiplier"), Config.getChorusPetalsSpawnMultiplier(), 0, 10).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.chorusPetalsSpawnMultiplier"), new class_2588("option.tooltip.illuminations.chorusPetalsSpawnMultiplier.lowest"), new class_2588("option.tooltip.illuminations.chorusPetalsSpawnMultiplier.highest")}).setSaveConsumer(Config::setChorusPetalsSpawnMultiplier).setDefaultValue(1).build());
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startIntSlider((class_2561)new class_2588("option.illuminations.density"), Config.getDensity(), 0, 1000).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.density"), new class_2588("option.tooltip.illuminations.density.lowest"), new class_2588("option.tooltip.illuminations.density.highest")}).setSaveConsumer(Config::setDensity).setDefaultValue(100).build());
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startBooleanToggle((class_2561)new class_2588("option.illuminations.fireflySpawnAlways"), Config.doesFireflySpawnAlways()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.fireflySpawnAlways")}).setSaveConsumer(Config::setFireflySpawnAlways).setDefaultValue(false).build());
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startBooleanToggle((class_2561)new class_2588("option.illuminations.fireflySpawnUnderground"), Config.doesFireflySpawnUnderground()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.fireflySpawnUnderground")}).setSaveConsumer(Config::setFireflySpawnUnderground).setDefaultValue(false).build());
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startIntSlider((class_2561)new class_2588("option.illuminations.fireflyWhiteAlpha"), Config.getFireflyWhiteAlpha(), 0, 100).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.fireflyWhiteAlpha")}).setSaveConsumer(Config::setFireflyWhiteAlpha).setDefaultValue(100).build());
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startBooleanToggle((class_2561)new class_2588("option.illuminations.fireflyRainbow"), Config.getFireflyRainbow()).setSaveConsumer(Config::setFireflyRainbow).setDefaultValue(false).build());
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startBooleanToggle((class_2561)new class_2588("option.illuminations.autoUpdate"), Config.isAutoUpdate()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.autoUpdate")}).setSaveConsumer(Config::setAutoUpdate).setDefaultValue(false).build());
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startBooleanToggle((class_2561)new class_2588("option.illuminations.viewAurasFP"), Config.getViewAurasFP()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.viewAurasFP")}).setSaveConsumer(Config::setViewAurasFP).setDefaultValue(false).build());
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startBooleanToggle((class_2561)new class_2588("option.illuminations.displayDonationToast"), Config.isDisplayDonationToast()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.displayDonationToast")}).setSaveConsumer(Config::setDisplayDonationToast).setDefaultValue(true).build());
        general.addEntry((AbstractConfigListEntry)this.entryBuilder.startBooleanToggle((class_2561)new class_2588("option.illuminations.debugMode"), Config.isDebugMode()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.debugMode")}).setSaveConsumer(Config::setDebugMode).setDefaultValue(false).build());
    }

    private void GenerateBiomeSettings() {
        HashMap<class_2960, ConfigCategory> biomeCategories = new HashMap<class_2960, ConfigCategory>();
        for (class_2960 dimension : BiomeCategory.getDimensions()) {
            String name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, dimension.method_12832());
            ConfigCategory category = this.builder.getOrCreateCategory((class_2561)new class_2588("category.illuminations." + name));
            category.setDescription(new class_5348[]{new class_2588("category.illuminations." + name + ".description")});
            biomeCategories.put(dimension, category);
        }
        for (BiomeCategory biome : BiomeCategory.values()) {
            ConfigCategory category = (ConfigCategory)biomeCategories.get(biome.getDimension());
            String name = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, biome.name());
            BiomeSettings defaultSettings = DefaultConfig.getBiomeSettings(biome);
            BiomeSettings settings = Config.getBiomeSettings(biome);
            class_2561[] tooltip = new class_2561[biome.getBiomes().length + 1];
            tooltip[0] = new class_2588("option.tooltip.illuminations.biome");
            for (int i = 0; i < biome.getBiomes().length; ++i) {
                tooltip[i + 1] = new class_2588("biome.minecraft." + biome.getBiomes()[i].method_12832());
            }
            SubCategoryBuilder biomeCategoryBuilder = this.entryBuilder.startSubCategory((class_2561)new class_2588("option.illuminations.biome." + name)).setTooltip(tooltip);
            biomeCategoryBuilder.add((AbstractConfigListEntry)this.entryBuilder.startEnumSelector((class_2561)new class_2588("option.illuminations.fireflySpawnRate"), FireflySpawnRate.class, (Enum)settings.fireflySpawnRate()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.fireflySpawnRate"), new class_2588("option.tooltip.illuminations.fireflySpawnRate.disable"), new class_2588("option.tooltip.illuminations.fireflySpawnRate.low"), new class_2588("option.tooltip.illuminations.fireflySpawnRate.medium"), new class_2588("option.tooltip.illuminations.fireflySpawnRate.high")}).setSaveConsumer(x -> Config.setFireflySettings(biome, x)).setDefaultValue((Enum)defaultSettings.fireflySpawnRate()).build());
            biomeCategoryBuilder.add((AbstractConfigListEntry)this.entryBuilder.startColorField((class_2561)new class_2588("option.illuminations.fireflyColor"), settings.fireflyColor()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.fireflyColor")}).setSaveConsumer(x -> Config.setFireflyColorSettings(biome, x)).setDefaultValue(defaultSettings.fireflyColor()).build());
            if (settings.glowwormSpawnRate() != null) {
                biomeCategoryBuilder.add((AbstractConfigListEntry)this.entryBuilder.startEnumSelector((class_2561)new class_2588("option.illuminations.glowwormSpawnRate"), GlowwormSpawnRate.class, (Enum)settings.glowwormSpawnRate()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.glowwormSpawnRate"), new class_2588("option.tooltip.illuminations.glowwormSpawnRate.disable"), new class_2588("option.tooltip.illuminations.glowwormSpawnRate.low"), new class_2588("option.tooltip.illuminations.glowwormSpawnRate.medium"), new class_2588("option.tooltip.illuminations.glowwormSpawnRate.high")}).setSaveConsumer(x -> Config.setGlowwormSettings(biome, x)).setDefaultValue((Enum)defaultSettings.glowwormSpawnRate()).build());
            }
            if (settings.planktonSpawnRate() != null) {
                biomeCategoryBuilder.add((AbstractConfigListEntry)this.entryBuilder.startEnumSelector((class_2561)new class_2588("option.illuminations.planktonSpawnRate"), PlanktonSpawnRate.class, (Enum)settings.planktonSpawnRate()).setTooltip(new class_2561[]{new class_2588("option.tooltip.illuminations.planktonSpawnRate"), new class_2588("option.tooltip.illuminations.planktonSpawnRate.disable"), new class_2588("option.tooltip.illuminations.planktonSpawnRate.low"), new class_2588("option.tooltip.illuminations.planktonSpawnRate.medium"), new class_2588("option.tooltip.illuminations.planktonSpawnRate.high")}).setSaveConsumer(x -> Config.setPlanktonSettings(biome, x)).setDefaultValue((Enum)defaultSettings.planktonSpawnRate()).build());
            }
            if (biome == BiomeCategory.OTHER) {
                biomeCategoryBuilder.forEach(arg_0 -> ((ConfigCategory)category).addEntry(arg_0));
                continue;
            }
            category.addEntry((AbstractConfigListEntry)biomeCategoryBuilder.build());
        }
    }
}

