/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.darkenchanting.config;

import com.google.common.collect.Lists;
import draylar.omegaconfig.api.Comment;
import draylar.omegaconfig.api.Config;
import draylar.omegaconfig.api.Syncing;
import io.github.frqnny.darkenchanting.config.ConfigEnchantment;
import java.util.ArrayList;

@Syncing
public class DarkEnchantingConfig
implements Config {
    @Comment(value="\nPerformance: Decide whether Dark Conduits emit particles.\nTrue means they do emit particles.\nDefault: true\n")
    public boolean hasFancyShrineParticle = true;
    @Syncing
    @Comment(value="\nEnchantments will cost this many levels for any transactions.\nDefault: 3.0\n")
    public float baseCost = 3.0f;
    @Syncing
    @Comment(value="\nEach enchantment's cost is multiplied by this value.\nDefault: 1.0\n")
    public float costFactor = 1.0f;
    @Syncing
    @Comment(value="\nRemoving an enchantment from gear will give XP back.\nThe amount received back is multiplied by this value.\nDefault: 0.49\n")
    public float receiveFactor = 0.49f;
    @Syncing
    @Comment(value="\nEach CURSE enchantment's cost is multiplied by this value.\nCurse Enchantments will show up as red on the Dark Enchanter.\nDefault: 3.0\n")
    public float curseFactor = 3.0f;
    @Syncing
    @Comment(value="\nEach TREASURE enchantment's cost is multiplied by this value.\nTREASURE Enchantments will show up as blue on the Dark Enchanter.\nDefault: 4.0\n")
    public float treasureFactor = 4.0f;
    @Syncing
    @Comment(value="\nEnchantments contain a certain weight, viewable in the Minecraft Wiki.\nWeight Divisor is used to determine a specialWeightFactor.\nWe perform the calculation:\n\n(11 - weight) / weightDivisor = specialWeightFactor\n\nspecialWeightFactor will ALWAYS be greater than 1. Meaning, if the calculation provides a specialWeightFactor less than 1, we will just use 1 instead.\n\nFor example, Sharpness has a weight of 10, while Mending will have a weight of 2.\nIn the equation, Sharpness will have a factor of 1 while Mending will have a factor of 4.5 (WITH DEFAULTS).\n\nTLDR: higher values means that this will DECREASE rarer enchantment's cost, while lower values will INCREASE the cost.\nDefault: 2.0\n")
    public float weightDivisor = 2.0f;
    @Syncing
    @Comment(value="\nRepairing any item will have its cost multiplied by this value.\nDefault: 1.0\n")
    public float repairFactor = 1.0f;
    @Syncing
    @Comment(value="\nThis number represents the discount from bookshelves.\nDefault: 0.4 (40%)\n")
    public float bookshelvesDiscount = 0.4f;
    @Syncing
    @Comment(value="\nThis number represents the discount from Dark Conduits.\nDefault: 0.1 (10%)\n")
    public float conduitDiscount = 0.1f;
    @Syncing
    @Comment(value="\nThis list can be used to configure specific enchantments.\nThe values are as follows:\n\n    enchantmentId: The In-Game identification of the Enchantment.\n        No Default.\n    activated: Determines whether the enchantment will be available in the Dark Enchanter.\n        Default: true\n    personalFactor: During transactions, the cost of the specific enchantment is multiplied by this value.\n        Default: 1.0\n    personalReceiveFactor: Removing enchantments allows you to receive back some XP. The amount received is multiplied by this value.\n\nBelow is an example entry for Sharpness with its defaults.\n")
    public ArrayList<ConfigEnchantment> configEnchantments = Lists.newArrayList((Object[])new ConfigEnchantment[]{ConfigEnchantment.of("minecraft:sharpness", 1.0f, true, 1.0f)});

    public String getName() {
        return "dark-enchanting";
    }

    public String getExtension() {
        return "json5";
    }
}

