/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.darkenchanting.client.gui;

import com.google.common.collect.ImmutableList;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.SyncedGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WBox;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WItemSlot;
import io.github.cottonmc.cotton.gui.widget.WLabeledSlider;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WScrollPanel;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Axis;
import io.github.frqnny.darkenchanting.blockentity.inventory.DarkEnchanterInventory;
import io.github.frqnny.darkenchanting.client.gui.WDynamicTooltipLabel;
import io.github.frqnny.darkenchanting.config.ConfigEnchantment;
import io.github.frqnny.darkenchanting.init.ModGUIs;
import io.github.frqnny.darkenchanting.init.ModPackets;
import io.github.frqnny.darkenchanting.util.BookcaseUtils;
import io.github.frqnny.darkenchanting.util.EnchHelp;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3914;

public class DarkEnchanterGUI
extends SyncedGuiDescription {
    public final DarkEnchanterInventory inv;
    public final WBox box;
    public final List<WLabeledSlider> enchantmentSliders;
    public final class_3914 context;
    public final Object2IntLinkedOpenHashMap<class_1887> enchantmentsToApply;
    public final Object2IntLinkedOpenHashMap<class_1887> enchantmentsOnStack;
    public final WButton enchantButton;
    public final WButton repairButton;
    public int enchantCost = 0;
    public int repairCost = 0;
    public int bookshelfDiscount = 0;
    public String bookcase_stats_1;
    public String bookcase_stats_2;
    public String bookcase_stats_3;

    public DarkEnchanterGUI(int syncId, class_1661 playerInventory, class_3914 context) {
        super(ModGUIs.DARK_ENCHANTER_GUI, syncId, playerInventory);
        playerInventory.field_7546.method_7316(0);
        this.inv = new DarkEnchanterInventory(this);
        this.context = context;
        this.enchantmentSliders = new ArrayList<WLabeledSlider>(15);
        this.enchantmentsToApply = new Object2IntLinkedOpenHashMap(15);
        this.enchantmentsOnStack = new Object2IntLinkedOpenHashMap(15);
        WPlainPanel root = new WPlainPanel();
        this.setRootPanel((WPanel)root);
        root.setSize(235, 250);
        WItemSlot slot = WItemSlot.of((class_1263)this.inv, (int)0);
        slot.setFilter(stack -> this.inv.method_5437(0, (class_1799)stack));
        root.add((WWidget)slot, 35, 17);
        this.box = new WBox(Axis.VERTICAL);
        WScrollPanel scrollPanel = new WScrollPanel((WWidget)this.box);
        root.add((WWidget)scrollPanel, 65, 17, 150, 135);
        this.enchantButton = new WButton();
        root.add((WWidget)this.enchantButton, 35, 60, 20, 20);
        this.enchantButton.setLabel((class_2561)new class_2585("E"));
        this.enchantButton.setOnClick(this::enchant);
        this.repairButton = new WButton();
        root.add((WWidget)this.repairButton, 35, 85, 20, 20);
        this.repairButton.setLabel((class_2561)new class_2585("R"));
        this.repairButton.setOnClick(this::repair);
        WDynamicTooltipLabel tooltip = new WDynamicTooltipLabel(() -> {
            String string = this.enchantCost > 0 ? "Pay: " + this.enchantCost + " XP" : "Receive: " + -this.enchantCost + " XP";
            return ImmutableList.of((Object)new class_2585("Enchant Cost:").method_27692(class_124.field_1077), (Object)new class_2585(string), (Object)new class_2585(""), (Object)new class_2585(""), (Object)new class_2585("Repair Cost:").method_27692(class_124.field_1078), (Object)new class_2585("Pay: " + this.repairCost + " XP"), (Object)new class_2585(""), (Object)new class_2585(""), (Object)new class_2585("Bookshelf Discount:").method_27692(class_124.field_1064), (Object)new class_2585(this.bookcase_stats_1 + this.bookcase_stats_2 + this.bookcase_stats_3 + " " + this.bookshelfDiscount + " %"), (Object)new class_2585(""), (Object)new class_2585(""), (Object[])new class_2561[]{new class_2585("You have: " + this.playerInventory.field_7546.field_7495 + " XP").method_27692(class_124.field_1065), new class_2585(""), new class_2585("")});
        });
        root.add((WWidget)tooltip, -120, 43);
        root.add((WWidget)this.createPlayerInventoryPanel(true), 36, 153);
        root.validate((GuiDescription)this);
    }

    public static class_2561 getLabel(class_1887 enchantment, int level) {
        class_2588 mutableText = new class_2588(enchantment.method_8184());
        if (enchantment.method_8195()) {
            mutableText.method_27692(class_124.field_1061);
        } else if (enchantment.method_8193()) {
            mutableText.method_27692(class_124.field_1078);
        } else {
            mutableText.method_27692(class_124.field_1080);
        }
        if (level > 0) {
            mutableText.method_27693(" ").method_10852((class_2561)new class_2588("enchantment.level." + level));
        }
        return mutableText;
    }

    public void fillBox() {
        for (WLabeledSlider slider : this.enchantmentSliders) {
            this.box.remove((WWidget)slider);
        }
        this.populateList();
        for (WLabeledSlider slider : this.enchantmentSliders) {
            this.box.add((WWidget)slider, 140, 18);
        }
        this.getRootPanel().layout();
    }

    public void populateList() {
        this.enchantmentSliders.clear();
        class_1799 stack = this.inv.getActualStack();
        if (stack.method_7960()) {
            return;
        }
        Map enchantments = class_1890.method_8222((class_1799)stack);
        for (class_1887 enchantment : class_2378.field_11160) {
            class_1887 enchantmentOnStack;
            Optional<ConfigEnchantment> configEnchantmentOptional = ConfigEnchantment.getConfigEnchantmentFor(enchantment);
            if (configEnchantmentOptional.isPresent()) {
                ConfigEnchantment configEnchantment = configEnchantmentOptional.get();
                if (!configEnchantment.activated) continue;
            }
            if (enchantment.method_8183() < 1 || !enchantment.method_8192(stack)) continue;
            WLabeledSlider enchantmentSlider = this.enchantmentsToApply.containsKey((Object)enchantment) ? this.addNewWidgetToList(this.enchantmentsToApply.getInt((Object)enchantment), enchantment) : (enchantments.containsKey(enchantment) ? (!this.isEnchantmentRemoved(enchantment) ? this.addNewWidgetToList((Integer)enchantments.get(enchantment), enchantment) : this.addNewWidgetToList(0, enchantment)) : this.addNewWidgetToList(0, enchantment));
            for (Map.Entry entry : enchantments.entrySet()) {
                enchantmentOnStack = (class_1887)entry.getKey();
                if (this.isEnchantmentRemoved(enchantmentOnStack) || enchantmentOnStack.method_8188(enchantment) || enchantmentOnStack.equals(enchantment)) continue;
                this.enchantmentSliders.remove(enchantmentSlider);
            }
            for (Object2IntMap.Entry entry : this.enchantmentsToApply.object2IntEntrySet()) {
                enchantmentOnStack = (class_1887)entry.getKey();
                if (enchantmentOnStack.method_8188(enchantment) || enchantmentOnStack.equals(enchantment) || entry.getIntValue() <= 0) continue;
                this.enchantmentSliders.remove(enchantmentSlider);
            }
        }
    }

    public WLabeledSlider addNewWidgetToList(int value, class_1887 enchantment) {
        WLabeledSlider slider = new WLabeledSlider(0, enchantment.method_8183());
        slider.setLabel(DarkEnchanterGUI.getLabel(enchantment, value));
        slider.setLabelUpdater(power -> DarkEnchanterGUI.getLabel(enchantment, power));
        slider.setValue(value);
        slider.setValueChangeListener(power -> this.changeInMap(enchantment, power));
        slider.setHost((GuiDescription)this);
        this.enchantmentSliders.add(slider);
        return slider;
    }

    public void changeInMap(class_1887 enchantment, int level) {
        if (this.enchantmentsToApply.containsKey((Object)enchantment)) {
            this.enchantmentsToApply.replace((Object)enchantment, level);
        } else {
            this.enchantmentsToApply.put((Object)enchantment, level);
        }
        this.fillBox();
        this.recalculateEnchantmentCost();
    }

    public void recalculateEnchantmentCost() {
        this.context.method_17393((world, blockPos) -> {
            int level;
            class_1887 enchantment;
            int totalExperience = this.playerInventory.field_7546.field_7495;
            this.enchantCost = BookcaseUtils.applyDiscount(EnchHelp.getXpCost(this.enchantmentsToApply, this.enchantmentsOnStack), world, blockPos);
            this.bookcase_stats_1 = BookcaseUtils.getObsidianCount(world, blockPos) ? "\u2606" : "";
            this.bookcase_stats_2 = BookcaseUtils.getObsidianCount_2(world, blockPos) ? "\u2606" : "";
            this.bookcase_stats_3 = BookcaseUtils.getConduits(world, blockPos) ? "\u2606" : "";
            this.bookshelfDiscount = (int)(BookcaseUtils.getDiscount(world, blockPos) * 100.0);
            boolean enchantmentsHaveChanged = true;
            for (Object2IntMap.Entry entrySet : this.enchantmentsToApply.object2IntEntrySet()) {
                enchantment = (class_1887)entrySet.getKey();
                level = entrySet.getIntValue();
                if (this.enchantmentsOnStack.containsKey((Object)enchantment) && this.enchantmentsOnStack.getInt((Object)enchantment) == level) continue;
                enchantmentsHaveChanged = false;
            }
            if (enchantmentsHaveChanged) {
                for (Object2IntMap.Entry entrySet : this.enchantmentsOnStack.object2IntEntrySet()) {
                    enchantment = (class_1887)entrySet.getKey();
                    level = entrySet.getIntValue();
                    if (this.enchantmentsToApply.containsKey((Object)enchantment) && this.enchantmentsToApply.getInt((Object)enchantment) == level) continue;
                    enchantmentsHaveChanged = false;
                }
            }
            this.enchantButton.setEnabled(totalExperience >= this.enchantCost && !enchantmentsHaveChanged || this.playerInventory.field_7546.method_7337());
        });
    }

    public void recalculateRepairCost() {
        this.context.method_17393((world, pos) -> {
            this.repairCost = BookcaseUtils.applyDiscount(EnchHelp.getRepairCost(this.inv.getActualStack()), world, pos);
        });
        this.repairButton.setEnabled(this.inv.getActualStack().method_7986() || this.playerInventory.field_7546.method_7337());
    }

    public void enchant() {
        this.context.method_17393((world, pos) -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10807(pos);
            buf.method_10804(this.enchantmentsToApply.size());
            for (Object2IntMap.Entry entry : this.enchantmentsToApply.object2IntEntrySet()) {
                buf.method_10812(class_2378.field_11160.method_10221((Object)((class_1887)entry.getKey())));
                buf.method_10804(entry.getIntValue());
            }
            this.getPacketSender().sendPacket(ModPackets.APPLY_ENCHANTMENTS, buf);
            this.inv.method_5431();
        });
    }

    public void repair() {
        this.context.method_17393((world, pos) -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10807(pos);
            this.getPacketSender().sendPacket(ModPackets.APPLY_REPAIR, buf);
        });
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inv));
    }

    public boolean isEnchantmentRemoved(class_1887 enchantment) {
        return this.enchantmentsToApply.getInt((Object)enchantment) <= 0;
    }
}

