/*
 * Decompiled with CFR 0.152.
 */
package draylar.inmis;

import draylar.inmis.config.BackpackInfo;
import draylar.inmis.config.InmisConfig;
import draylar.inmis.item.BackpackItem;
import draylar.inmis.item.EnderBackpackItem;
import draylar.inmis.network.ServerNetworking;
import draylar.inmis.ui.BackpackScreenHandler;
import draylar.omegaconfig.OmegaConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ScreenHandlerRegistry;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Inmis
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 CONTAINER_ID = Inmis.id("backpack");
    public static final class_1761 GROUP = FabricItemGroupBuilder.build((class_2960)CONTAINER_ID, () -> new class_1799((class_1935)class_2378.field_11142.method_10223(Inmis.id("frayed_backpack"))));
    public static final InmisConfig CONFIG = (InmisConfig)OmegaConfig.register(InmisConfig.class);
    public static final class_3917<BackpackScreenHandler> CONTAINER_TYPE = ScreenHandlerRegistry.registerExtended((class_2960)CONTAINER_ID, BackpackScreenHandler::new);
    public static final List<class_1792> BACKPACKS = new ArrayList<class_1792>();
    public static final class_1792 ENDER_POUCH = (class_1792)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)Inmis.id("ender_pouch"), (Object)((Object)new EnderBackpackItem()));

    public void onInitialize() {
        this.registerBackpacks();
        ServerNetworking.init();
    }

    private void registerBackpacks() {
        InmisConfig defaultConfig = new InmisConfig();
        for (BackpackInfo backpack : Inmis.CONFIG.backpacks) {
            class_1792.class_1793 settings = new class_1792.class_1793().method_7892(GROUP).method_7889(1);
            if (backpack.isFireImmune()) {
                settings.method_24359();
            }
            if (backpack.getOpenSound() == null) {
                Optional<BackpackInfo> any = defaultConfig.backpacks.stream().filter(info -> info.getName().equals(backpack.getName())).findAny();
                any.ifPresent(backpackInfo -> backpack.setOpenSound(backpackInfo.getOpenSound()));
                if (backpack.getOpenSound() == null) {
                    LOGGER.info(String.format("Could not find a sound event for %s in inmis.json config.", backpack.getName()));
                    LOGGER.info("Consider regenerating your config, or assigning the openSound value. Rolling with defaults for now.");
                    backpack.setOpenSound("minecraft:item.armor.equip_leather");
                }
            }
            BackpackItem registered = (BackpackItem)((Object)class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960("inmis", backpack.getName().toLowerCase() + "_backpack"), (Object)((Object)new BackpackItem(backpack, settings))));
            BACKPACKS.add(registered);
        }
    }

    public static class_2960 id(String name) {
        return new class_2960("inmis", name);
    }
}

