/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.message;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.network.message.AbstractMessageWithLocation;

public final class PipeLockedStateMessage
extends AbstractMessageWithLocation {
    public Face face;
    public Port port;
    public boolean isLocked;

    public PipeLockedStateMessage(CasingBlockEntity casing, Face face, Port port, boolean isLocked) {
        super(Objects.requireNonNull(casing.method_10997()), casing.method_11016());
        this.face = face;
        this.port = port;
        this.isLocked = isLocked;
    }

    public PipeLockedStateMessage() {
    }

    public Face getFace() {
        return this.face;
    }

    public Port getPort() {
        return this.port;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        byte compressed = buf.readByte();
        this.face = Face.VALUES[compressed >>> 3 & 7];
        this.port = Port.VALUES[compressed >>> 1 & 3];
        this.isLocked = (compressed & 1) == 1;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        byte compressed = (byte)(this.face.ordinal() << 3 | this.port.ordinal() << 1 | (this.isLocked ? 1 : 0));
        buf.writeByte((int)compressed);
    }
}

