/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.gui.GuiHelper;
import li.cil.tis3d.client.gui.TerminalModuleGui;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.client.render.font.AbstractFontRenderer;
import li.cil.tis3d.client.render.font.NormalFontRenderer;
import li.cil.tis3d.util.ColorUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public final class TerminalModule
extends AbstractModuleWithRotation {
    private final LinkedList<StringBuilder> display = new LinkedList();
    private final StringBuilder output = new StringBuilder();
    private final StringBuilder input = new StringBuilder();
    private static final String TAG_DISPLAY = "display";
    private static final String TAG_OUTPUT = "output";
    private static final byte DATA_TYPE_INPUT = 0;
    private static final byte PACKET_INPUT = 0;
    private static final byte PACKET_DISPLAY = 1;
    private static final byte PACKET_CLEAR = 2;
    private static final int MAX_ROWS = 21;
    private static final int MAX_COLUMNS = 40;
    private static final int TAB_WIDTH = 2;
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final Charset CP437 = Charset.forName("Cp437");
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(1);
    private final CharBuffer charBuffer = CharBuffer.allocate(1);
    private final CharsetDecoder decoder = CP437.newDecoder();
    private final CharsetEncoder encoder = CP437.newEncoder();
    private ByteBuf sendBuffer;
    private long lastSendTick = 0L;
    private boolean isInputEnabled;

    public TerminalModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepOutput();
        this.stepInput();
        class_1937 world = this.getCasing().getCasingWorld();
        if (this.sendBuffer != null && world.method_8510() > this.lastSendTick) {
            this.getCasing().sendData(this.getFace(), this.sendBuffer);
            this.sendBuffer = null;
        }
        this.lastSendTick = world.method_8510();
    }

    @Override
    public void onDisabled() {
        this.display.clear();
        this.output.setLength(0);
        ByteBuf data = Unpooled.buffer();
        data.writeByte(2);
        this.getCasing().sendData(this.getFace(), data);
    }

    @Override
    public void onDisposed() {
        if (this.getCasing().getCasingWorld().field_9236) {
            this.closeGui();
        }
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.output.setLength(this.output.length() - 1);
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.cancelWrite();
        if (!this.isWriting()) {
            this.sendInputEnabled(true);
        } else {
            this.stepOutput();
        }
    }

    @Override
    public boolean onActivate(class_1657 player, class_1268 hand, class_243 hit) {
        if (player.method_5715()) {
            return false;
        }
        if (!this.getCasing().isEnabled()) {
            return true;
        }
        class_1937 world = player.method_5770();
        if (world.field_9236) {
            GuiHelper.openTerminalGui(this);
        }
        return true;
    }

    @Override
    public void onData(ByteBuf data) {
        if (this.getCasing().getCasingWorld().field_9236) {
            switch (data.readByte()) {
                case 0: {
                    this.isInputEnabled = data.readBoolean();
                    if (this.isInputEnabled) break;
                    this.input.setLength(0);
                    break;
                }
                case 1: {
                    while (data.isReadable()) {
                        this.writeToDisplay(data.readChar());
                    }
                    break;
                }
                case 2: {
                    this.display.clear();
                    this.output.setLength(0);
                    this.input.setLength(0);
                    this.isInputEnabled = true;
                }
            }
        } else if (!this.isWriting()) {
            this.beginWriting(TerminalModule.readString(data));
            this.sendInputEnabled(false);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        if (!this.getCasing().isEnabled() || !this.isVisible()) {
            return;
        }
        matrices.method_22903();
        this.rotateForRendering(matrices);
        if (rendererDispatcher.field_4344.method_19328().method_10262((class_2382)this.getCasing().getPosition()) < 64.0) {
            this.renderText(matrices, vcp, RenderUtil.maxLight, overlay);
        } else {
            class_1058 baseSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_MODULE_TERMINAL);
            class_4588 vc = vcp.getBuffer(class_1921.method_23579());
            RenderUtil.drawQuad(baseSprite, matrices.method_23760(), vc, RenderUtil.maxLight, overlay);
        }
        matrices.method_22909();
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
        super.readFromNBT(nbt);
        class_2499 lines = nbt.method_10554(TAG_DISPLAY, 8);
        this.display.clear();
        for (int tagIndex = 0; tagIndex < lines.size(); ++tagIndex) {
            this.display.add(new StringBuilder(lines.method_10608(tagIndex)));
        }
        this.output.setLength(0);
        this.output.append(nbt.method_10558(TAG_OUTPUT));
        this.isInputEnabled = this.output.length() == 0;
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
        super.writeToNBT(nbt);
        class_2499 lines = new class_2499();
        for (StringBuilder line : this.display) {
            lines.add((Object)class_2519.method_23256((String)line.toString()));
        }
        nbt.method_10566(TAG_DISPLAY, (class_2520)lines);
        nbt.method_10582(TAG_OUTPUT, this.output.toString());
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            char ch = this.toChar(receivingPipe.read());
            this.writeToDisplay(ch);
            this.sendDisplayToClient(ch);
        }
    }

    private void stepOutput() {
        if (this.isWriting()) {
            for (Port port : Port.VALUES) {
                Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
                if (sendingPipe.isWriting()) continue;
                sendingPipe.beginWrite(this.toShort(this.peekChar()));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void renderText(class_4587 matrices, class_4597 vcp, int light, int overlay) {
        matrices.method_22904(0.125, 0.125, 0.0);
        matrices.method_22905(0.001953125f, 0.001953125f, 1.0f);
        AbstractFontRenderer fontRenderer = (AbstractFontRenderer)NormalFontRenderer.INSTANCE;
        class_4588 vcFont = fontRenderer.chooseVertexConsumer(vcp);
        int charWidth = fontRenderer.getCharWidth();
        int charHeight = fontRenderer.getCharHeight();
        int totalWidth = 384;
        int textWidth = 40 * charWidth;
        float offsetX = (float)(384 - textWidth) / 2.0f;
        matrices.method_22904((double)offsetX, 10.0, 0.0);
        this.renderDisplay(matrices, vcFont, light, overlay, fontRenderer);
        matrices.method_22904(0.0, (double)((21 - this.display.size()) * charHeight + 4), 0.0);
        this.renderInput(matrices, vcFont, vcp, light, overlay, fontRenderer, textWidth);
    }

    @Environment(value=EnvType.CLIENT)
    private void renderDisplay(class_4587 matrices, class_4588 vcFont, int light, int overlay, AbstractFontRenderer fontRenderer) {
        for (StringBuilder line : this.display) {
            fontRenderer.drawString(matrices.method_23760(), vcFont, light, overlay, line);
            matrices.method_22904(0.0, (double)fontRenderer.getCharHeight(), 0.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void renderInput(class_4587 matrices, class_4588 vcFont, class_4597 vcp, int light, int overlay, AbstractFontRenderer fontRenderer, int textWidth) {
        int color = ColorUtils.WHITE;
        matrices.method_22904(0.0, 4.0, 0.0);
        fontRenderer.drawString(matrices.method_23760(), vcFont, light, overlay, this.input);
        class_4588 vcColor = vcp.getBuffer(class_1921.method_23577());
        if (this.isInputEnabled && this.input.length() < 40 && System.currentTimeMillis() % 800L > 400L) {
            int charWidth = fontRenderer.getCharWidth();
            int charHeight = fontRenderer.getCharHeight();
            RenderUtil.drawColorQuad(matrices.method_23760(), vcColor, this.input.length() * charWidth, 0.0f, charWidth, charHeight, color, light, overlay);
        }
        if (!this.isInputEnabled) {
            color = -8355712;
        }
        RenderUtil.drawColorQuad(matrices.method_23760(), vcColor, -4.0f, -4.0f, textWidth + 8, 2.0f, color, light, overlay);
        RenderUtil.drawColorQuad(matrices.method_23760(), vcColor, -4.0f, 18.0f, textWidth + 8, 2.0f, color, light, overlay);
        RenderUtil.drawColorQuad(matrices.method_23760(), vcColor, -4.0f, -4.0f, 2.0f, 24.0f, color, light, overlay);
        RenderUtil.drawColorQuad(matrices.method_23760(), vcColor, textWidth + 2, -4.0f, 2.0f, 24.0f, color, light, overlay);
        int grey = -15066598;
        matrices.method_22904(0.0, 0.0, (double)0.0025f);
        RenderUtil.drawColorQuad(matrices.method_23760(), vcColor, -4.0f, -4.0f, textWidth + 8, 24.0f, -15066598, light, overlay);
    }

    @Environment(value=EnvType.CLIENT)
    private void closeGui() {
        TerminalModuleGui gui;
        class_310 mc = class_310.method_1551();
        if (mc == null) {
            return;
        }
        class_437 screen = mc.field_1755;
        if (screen instanceof TerminalModuleGui && (gui = (TerminalModuleGui)screen).isFor(this)) {
            mc.method_1507(null);
        }
    }

    private void sendInputEnabled(boolean value) {
        ByteBuf response = Unpooled.buffer();
        response.writeByte(0);
        response.writeBoolean(value);
        this.getCasing().sendData(this.getFace(), response, (byte)0);
    }

    private void sendDisplayToClient(char ch) {
        if (this.sendBuffer == null) {
            this.sendBuffer = Unpooled.buffer();
            this.sendBuffer.writeByte(1);
        }
        this.sendBuffer.writeChar((int)ch);
    }

    private void sendInputToServer() {
        ByteBuf data = Unpooled.buffer();
        TerminalModule.writeString(data, this.input.toString());
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    private static void writeString(ByteBuf data, String value) {
        byte[] bytes = value.getBytes(UTF_8);
        int byteCount = Math.min(255, bytes.length);
        data.writeByte((int)((byte)byteCount));
        data.writeBytes(bytes, 0, byteCount);
    }

    private static String readString(ByteBuf data) {
        int byteCount = data.readByte() & 0xFF;
        byte[] bytes = new byte[byteCount];
        data.readBytes(bytes);
        return new String(bytes, UTF_8);
    }

    private char toChar(short value) {
        this.byteBuffer.clear();
        this.charBuffer.clear();
        this.decoder.reset();
        this.byteBuffer.put((byte)value);
        this.byteBuffer.rewind();
        this.decoder.decode(this.byteBuffer, this.charBuffer, true);
        this.charBuffer.rewind();
        if (this.charBuffer.hasRemaining()) {
            return this.charBuffer.get();
        }
        return '\u0000';
    }

    private short toShort(char ch) {
        this.byteBuffer.clear();
        this.charBuffer.clear();
        this.encoder.reset();
        this.charBuffer.put(ch);
        this.charBuffer.rewind();
        this.encoder.encode(this.charBuffer, this.byteBuffer, true);
        this.byteBuffer.rewind();
        if (this.byteBuffer.hasRemaining()) {
            return (short)(this.byteBuffer.get() & 0xFF);
        }
        return 0;
    }

    private void writeToDisplay(char ch) {
        if (this.display.isEmpty()) {
            this.display.add(new StringBuilder());
        }
        if (ch == '\u0007') {
            this.bell();
        } else if (ch == '\b') {
            TerminalModule.backspace(this.display.getLast());
        } else if (ch == '\t') {
            this.wrapIfNecessary();
            TerminalModule.tab(this.display.getLast());
        } else if (ch == '\n' || ch == '\r') {
            this.newLine();
        } else {
            this.wrapIfNecessary();
            TerminalModule.character(this.display.getLast(), ch);
        }
    }

    public void writeToInput(char ch) {
        if (ch == '\b') {
            TerminalModule.backspace(this.input);
        } else if (ch == '\t') {
            TerminalModule.tab(this.input);
        } else if (ch == '\n' || ch == '\r') {
            this.sendInputToServer();
        } else if (this.toShort(ch) != 0) {
            TerminalModule.character(this.input, this.toChar(this.toShort(ch)));
        }
    }

    private void bell() {
        class_1937 world = this.getCasing().getCasingWorld();
        if (!world.field_9236) {
            world.method_8396(null, this.getCasing().getPosition(), class_3417.field_15114, class_3419.field_15245, 0.3f, 2.0f);
        }
    }

    private static void backspace(StringBuilder line) {
        if (line.length() > 0) {
            line.setLength(line.length() - 1);
        }
    }

    private static void tab(StringBuilder line) {
        if (line.length() < 40) {
            do {
                line.append(' ');
            } while (line.length() % 2 != 0 && line.length() < 40);
        }
    }

    private static void character(StringBuilder line, char ch) {
        if (line.length() < 40) {
            line.append(ch);
        }
    }

    private void wrapIfNecessary() {
        if (this.display.getLast().length() >= 40) {
            this.newLine();
        }
    }

    private void newLine() {
        StringBuilder line = null;
        while (this.display.size() >= 21) {
            line = this.display.removeFirst();
        }
        if (line == null) {
            line = new StringBuilder();
        } else {
            line.setLength(0);
        }
        this.display.addLast(line);
    }

    private boolean isWriting() {
        return this.output.length() > 0;
    }

    private void beginWriting(String value) {
        this.stopWriting();
        this.output.append(value);
        this.output.append('\u0000');
        this.output.reverse();
    }

    private char peekChar() {
        return this.output.charAt(this.output.length() - 1);
    }

    private void stopWriting() {
        this.output.setLength(0);
    }
}

