/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.util.Side;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public final class SequencerModule
extends AbstractModuleWithRotation {
    private final boolean[][] configuration = new boolean[8][8];
    private int position = -1;
    private int delay = 4;
    private int stepsRemaining = 0;
    private static final String TAG_CONFIGURATION = "configuration";
    private static final String TAG_POSITION = "position";
    private static final String TAG_DELAY = "delay";
    private static final String TAG_STEPS_REMAINING = "stepsRemaining";
    private static final byte DATA_TYPE_CONFIGURATION = 0;
    private static final byte DATA_TYPE_POSITION = 1;
    private static final int COL_COUNT = 8;
    private static final int ROW_COUNT = 8;
    private static final float CELLS_U0 = 0.15625f;
    private static final float CELLS_V0 = 0.15625f;
    private static final float CELLS_SIZE_U = 0.03125f;
    private static final float CELLS_SIZE_V = 0.03125f;
    private static final float CELLS_STEP_U = 0.09375f;
    private static final float CELLS_STEP_V = 0.09375f;
    private static final float CELLS_OUTER_U0 = 0.125f;
    private static final float CELLS_OUTER_V0 = 0.125f;
    private static final float CELLS_OUTER_SIZE_U = 0.09375f;
    private static final float CELLS_OUTER_SIZE_V = 0.09375f;
    private static final float CELLS_OUTER_STEP_U = 0.09375f;
    private static final float CELLS_OUTER_STEP_V = 0.09375f;
    private static final float BAR_U0 = 0.125f;
    private static final float BAR_V0 = 0.125f;
    private static final float BAR_SIZE_U = 0.09375f;
    private static final float BAR_SIZE_V = 0.75f;
    private static final float BAR_STEP_U = 0.09375f;
    private short output;

    public SequencerModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepInput();
        this.stepOutput();
    }

    @Override
    public void onDisabled() {
        this.position = -1;
        this.stepsRemaining = 0;
    }

    @Override
    public boolean onActivate(class_1657 player, class_1268 hand, class_243 hit) {
        if (player.method_5715()) {
            return false;
        }
        class_1937 world = this.getCasing().getCasingWorld();
        if (world.field_9236) {
            class_243 uv = this.hitToUV(hit);
            int col = this.uvToCol((float)uv.field_1352);
            int row = this.uvToRow((float)uv.field_1351);
            if (col >= 0 && row >= 0) {
                this.configuration[col][row] = !this.configuration[col][row];
                this.sendConfiguration(Side.SERVER);
            }
        }
        return true;
    }

    @Override
    public void onData(ByteBuf data) {
        if (this.getCasing().getCasingWorld().field_9236) {
            if (data.readBoolean()) {
                SequencerModule.decodeConfiguration(data.readLong(), this.configuration);
            } else {
                this.position = data.readByte();
            }
        } else {
            SequencerModule.decodeConfiguration(data.readLong(), this.configuration);
            this.sendConfiguration(Side.CLIENT);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        class_243 hitPos;
        if (!this.isVisible()) {
            return;
        }
        matrices.method_22903();
        this.rotateForRendering(matrices);
        class_4588 vc = vcp.getBuffer(class_1921.method_23579());
        class_4587.class_4665 mat = matrices.method_23760();
        boolean enabled = this.getCasing().isEnabled();
        int numLayers = 3;
        float layerBump = 0.0016666666f;
        class_1058 baseSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_MODULE_SEQUENCER);
        int baseBrightness = enabled ? 255 : 128;
        RenderUtil.drawQuad(baseSprite, mat, vc, 255, baseBrightness, baseBrightness, baseBrightness, RenderUtil.maxLight, overlay);
        if (rendererDispatcher.field_4344.method_19328().method_10262((class_2382)this.getCasing().getPosition()) < 64.0) {
            int confColor = enabled ? -3352353 : -10064785;
            for (int col = 0; col < 8; ++col) {
                for (int row = 0; row < 8; ++row) {
                    if (!this.configuration[col][row]) continue;
                    float u0 = 0.15625f + 0.09375f * (float)col;
                    float v0 = 0.15625f + 0.09375f * (float)row;
                    RenderUtil.drawColorQuad(mat, vc, u0, v0, 0.03125f, 0.03125f, confColor, RenderUtil.maxLight, overlay);
                }
            }
        }
        if ((hitPos = this.getObserverLookAt(rendererDispatcher)) != null) {
            class_243 uv = this.hitToUV(hitPos);
            int col = this.uvToCol((float)uv.field_1352);
            int row = this.uvToRow((float)uv.field_1351);
            if (col >= 0 && row >= 0) {
                float u = 0.125f + (float)col * 0.09375f;
                float v = 0.125f + (float)row * 0.09375f;
                matrices.method_22904(0.0, 0.0, 0.0016666665906086564);
                RenderUtil.drawColorQuad(mat, vc, u, v, 0.09375f, 0.09375f, enabled ? -10918285 : -13880519, RenderUtil.maxLight, overlay);
            }
        }
        if (enabled) {
            float barU0 = 0.125f + 0.09375f * (float)this.position;
            float brightness = 0.75f + 0.25f * (this.delay == 0 ? 1.0f : 1.0f - (float)(this.delay - this.stepsRemaining) / (float)this.delay);
            int barRed = (int)(51.0f * brightness);
            int barGreen = (int)(76.0f * brightness);
            int barBlue = (int)(89.0f * brightness);
            matrices.method_22904(0.0, 0.0, 0.0016666665906086564);
            RenderUtil.drawColorQuad(mat, vc, barU0, 0.125f, 0.09375f, 0.75f, 255, barRed, barGreen, barBlue, RenderUtil.maxLight, overlay);
        }
        matrices.method_22909();
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
        super.readFromNBT(nbt);
        SequencerModule.decodeConfiguration(nbt.method_10537(TAG_CONFIGURATION), this.configuration);
        this.position = Math.min(Math.max(nbt.method_10550(TAG_POSITION), 0), 7);
        this.delay = Math.min(Math.max(nbt.method_10550(TAG_DELAY), 0), 65535);
        this.stepsRemaining = Math.min(Math.max(nbt.method_10550(TAG_STEPS_REMAINING), 0), 65535);
        this.initializeOutput();
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
        super.writeToNBT(nbt);
        nbt.method_10544(TAG_CONFIGURATION, SequencerModule.encodeConfiguration(this.configuration));
        nbt.method_10569(TAG_POSITION, this.position);
        nbt.method_10569(TAG_DELAY, this.delay);
        nbt.method_10569(TAG_STEPS_REMAINING, this.stepsRemaining);
    }

    private void stepOutput() {
        if (this.stepsRemaining-- <= 0) {
            this.stepsRemaining = this.delay;
            this.cancelWrite();
            this.position = (this.position + 1) % 8;
            this.sendPosition();
            this.initializeOutput();
            for (Port port : Port.VALUES) {
                Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
                if (sendingPipe.isWriting()) continue;
                sendingPipe.beginWrite(this.output);
            }
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            this.delay = receivingPipe.read() & 0xFFFF;
        }
    }

    private void sendConfiguration(Side toSide) {
        ByteBuf data = Unpooled.buffer();
        if (toSide == Side.CLIENT) {
            data.writeBoolean(true);
        }
        data.writeLong(SequencerModule.encodeConfiguration(this.configuration));
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    private void sendPosition() {
        ByteBuf data = Unpooled.buffer();
        data.writeBoolean(false);
        data.writeByte(this.position);
        this.getCasing().sendData(this.getFace(), data, (byte)1);
    }

    private void initializeOutput() {
        this.output = 0;
        int mask = 1;
        int row = 0;
        while (row < 8) {
            if (this.configuration[this.position][row]) {
                this.output = (short)(this.output | mask);
            }
            ++row;
            mask <<= 1;
        }
    }

    private static long encodeConfiguration(boolean[][] configuration) {
        long encodedConfiguration = 0L;
        long mask = 1L;
        for (int col = 0; col < 8; ++col) {
            int row = 0;
            while (row < 8) {
                if (configuration[col][row]) {
                    encodedConfiguration |= mask;
                }
                ++row;
                mask <<= 1;
            }
        }
        return encodedConfiguration;
    }

    private static void decodeConfiguration(long encodedConfiguration, boolean[][] configuration) {
        long mask = 1L;
        for (int col = 0; col < 8; ++col) {
            int row = 0;
            while (row < 8) {
                configuration[col][row] = (encodedConfiguration & mask) != 0L;
                ++row;
                mask <<= 1;
            }
        }
    }

    private int uvToCol(float u) {
        if (u < 0.125f || u > 0.875f) {
            return -1;
        }
        float mappedU = (u - 0.125f) / 0.75f;
        return (int)(mappedU * 8.0f);
    }

    private int uvToRow(float v) {
        if (v < 0.125f || v > 0.875f) {
            return -1;
        }
        float mappedV = (v - 0.125f) / 0.75f;
        return (int)(mappedV * 8.0f);
    }
}

