/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.client.render.font.AbstractFontRenderer;
import li.cil.tis3d.client.render.font.SmallFontRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public final class QueueModule
extends AbstractModuleWithRotation {
    private final short[] queue = new short[17];
    private int head = 0;
    private int tail = 0;
    private static final String TAG_QUEUE = "queue";
    private static final String TAG_HEAD = "head";
    private static final String TAG_TAIL = "tail";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final int QUEUE_SIZE = 17;

    public QueueModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        this.stepOutput();
        this.stepInput();
    }

    @Override
    public void onDisabled() {
        this.tail = 0;
        this.head = 0;
        this.sendData();
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.pop();
        this.cancelWrite();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.cancelWrite();
        this.stepOutput();
    }

    @Override
    public void onData(ByteBuf data) {
        this.head = data.readByte();
        this.tail = data.readByte();
        for (int i = 0; i < this.queue.length; ++i) {
            this.queue[i] = data.readShort();
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        matrices.method_22903();
        this.rotateForRendering(matrices);
        class_1058 baseSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_MODULE_QUEUE);
        class_4588 vc = vcp.getBuffer(class_1921.method_23579());
        RenderUtil.drawQuad(baseSprite, matrices.method_23760(), vc, RenderUtil.maxLight, overlay);
        if (!this.isEmpty() && rendererDispatcher.field_4344.method_19328().method_10262((class_2382)this.getCasing().getPosition()) < 64.0) {
            this.drawState(matrices, vcp, RenderUtil.maxLight, overlay);
        }
        matrices.method_22909();
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
        super.readFromNBT(nbt);
        int[] queueNbt = nbt.method_10561(TAG_QUEUE);
        int count = Math.min(queueNbt.length, this.queue.length);
        for (int i = 0; i < count; ++i) {
            this.queue[i] = (short)queueNbt[i];
        }
        this.head = class_3532.method_15340((int)nbt.method_10550(TAG_HEAD), (int)0, (int)16);
        this.tail = class_3532.method_15340((int)nbt.method_10550(TAG_TAIL), (int)0, (int)16);
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
        super.writeToNBT(nbt);
        int[] queueNbt = new int[this.queue.length];
        for (int i = 0; i < this.queue.length; ++i) {
            queueNbt[i] = this.queue[i];
        }
        nbt.method_10539(TAG_QUEUE, queueNbt);
        nbt.method_10569(TAG_HEAD, this.head);
        nbt.method_10569(TAG_TAIL, this.tail);
    }

    private boolean isEmpty() {
        return this.head == this.tail;
    }

    private boolean isFull() {
        return (this.head + 1) % 17 == this.tail;
    }

    private void push(short value) {
        this.queue[this.head] = value;
        this.head = (this.head + 1) % 17;
        this.sendData();
    }

    private short peek() {
        return this.queue[this.tail];
    }

    private void pop() {
        this.tail = (this.tail + 1) % 17;
        this.sendData();
    }

    private void stepOutput() {
        if (this.isEmpty()) {
            return;
        }
        for (Port port : Port.VALUES) {
            Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
            if (sendingPipe.isWriting()) continue;
            sendingPipe.beginWrite(this.peek());
        }
    }

    private void stepInput() {
        for (Port port : Port.VALUES) {
            if (this.isFull()) {
                return;
            }
            Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
            if (!receivingPipe.isReading()) {
                receivingPipe.beginRead();
            }
            if (!receivingPipe.canTransfer()) continue;
            boolean wasEmpty = this.isEmpty();
            this.push(receivingPipe.read());
            if (!wasEmpty) continue;
            this.stepOutput();
        }
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeByte(this.head);
        data.writeByte(this.tail);
        for (short value : this.queue) {
            data.writeShort((int)value);
        }
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    @Environment(value=EnvType.CLIENT)
    private void drawState(class_4587 matrices, class_4597 vcp, int light, int overlay) {
        matrices.method_22904(0.1875, 0.3125, 0.0);
        matrices.method_22905(0.0078125f, 0.0078125f, 1.0f);
        matrices.method_22904(4.5, 14.5, 0.0);
        AbstractFontRenderer fontRenderer = (AbstractFontRenderer)SmallFontRenderer.INSTANCE;
        class_4588 vcFont = fontRenderer.chooseVertexConsumer(vcp);
        int charWidth = fontRenderer.getCharWidth();
        int charHeight = fontRenderer.getCharHeight();
        int i = this.tail;
        int j = 0;
        while (i != this.head) {
            String str = String.format("%4X", this.queue[i]);
            fontRenderer.drawString(matrices.method_23760(), vcFont, light, overlay, str);
            matrices.method_22904(0.0, (double)(charHeight + 1), 0.0);
            if ((j + 1) % 4 == 0) {
                matrices.method_22904((double)((charWidth + 1) * 5), (double)((charHeight + 1) * -4), 0.0);
            }
            i = (i + 1) % 17;
            ++j;
        }
    }
}

