/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.LinkedList;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.ext.TextureManagerExt;
import li.cil.tis3d.util.ColorUtils;
import li.cil.tis3d.util.EnumUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public final class DisplayModule
extends AbstractModuleWithRotation {
    private final int[] image = new int[1024];
    private boolean imageDirty = false;
    @Environment(value=EnvType.CLIENT)
    private class_1043 backingTexture;
    @Environment(value=EnvType.CLIENT)
    private class_2960 backingTextureId;
    @Environment(value=EnvType.CLIENT)
    private class_1921 renderLayer;
    private State state = State.COLOR;
    private final byte[] drawCall = new byte[State.values().length];
    private static final int RESOLUTION = 32;
    private static final int MARGIN = 2;
    private static final String TAG_IMAGE = "image";
    private static final String TAG_STATE = "state";
    private static final String TAG_DRAW_CALL = "drawCall";
    private static final byte DATA_TYPE_CLEAR = 0;
    @Environment(value=EnvType.CLIENT)
    private static int textureIdCounter = 1;

    public DisplayModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        for (Port port : Port.VALUES) {
            this.stepInput(port);
        }
    }

    @Override
    public void onDisabled() {
        Arrays.fill(this.image, 0);
        this.state = State.COLOR;
        this.imageDirty = true;
        this.sendClear();
    }

    @Override
    public void onDisposed() {
        if (this.getCasing().getCasingWorld().field_9236) {
            this.deleteTexture();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void finalize() {
        LeakDetector.add(this.backingTexture);
    }

    @Override
    public void onData(ByteBuf data) {
        if (data.readBoolean()) {
            Arrays.fill(this.image, 0);
        } else {
            data.readBytes(this.drawCall);
            this.applyDrawCall(this.drawCall);
        }
        this.imageDirty = true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        if (!this.getCasing().isEnabled()) {
            return;
        }
        matrices.method_22903();
        this.rotateForRendering(matrices);
        class_1921 rl = this.getRenderLayer();
        this.updateBackingTexture();
        class_4588 vc = vcp.getBuffer(rl);
        RenderUtil.drawQuad(matrices.method_23760(), vc, RenderUtil.maxLight, overlay);
        matrices.method_22909();
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
        super.readFromNBT(nbt);
        int[] imageNbt = nbt.method_10561(TAG_IMAGE);
        System.arraycopy(imageNbt, 0, this.image, 0, Math.min(imageNbt.length, this.image.length));
        this.imageDirty = true;
        this.state = EnumUtils.readFromNBT(State.class, TAG_STATE, nbt);
        byte[] drawCallNbt = nbt.method_10547(TAG_DRAW_CALL);
        System.arraycopy(drawCallNbt, 0, this.drawCall, 0, Math.min(drawCallNbt.length, this.drawCall.length));
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
        super.writeToNBT(nbt);
        nbt.method_10539(TAG_IMAGE, this.image);
        EnumUtils.writeToNBT(this.state, TAG_STATE, nbt);
        nbt.method_10570(TAG_DRAW_CALL, (byte[])this.drawCall.clone());
    }

    private void stepInput(Port port) {
        Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
        if (!receivingPipe.isReading()) {
            receivingPipe.beginRead();
        }
        if (receivingPipe.canTransfer()) {
            this.process(receivingPipe.read());
        }
    }

    private void process(short value) {
        this.drawCall[this.state.ordinal()] = (byte)value;
        this.state = this.state.getNext();
        if (this.state == State.COLOR) {
            this.applyDrawCall(this.drawCall);
            this.sendDrawCall();
        }
    }

    private void applyDrawCall(byte[] drawCall) {
        byte color = drawCall[State.COLOR.ordinal()];
        byte xin = drawCall[State.X.ordinal()];
        byte yin = drawCall[State.Y.ordinal()];
        byte w = drawCall[State.W.ordinal()];
        byte h = drawCall[State.H.ordinal()];
        int x0 = 2 + Math.max(0, xin);
        int x1 = 2 + Math.min(28, xin + w);
        int y0 = 2 + Math.max(0, yin);
        int y1 = 2 + Math.min(28, yin + h);
        for (int y = y0; y < y1; ++y) {
            int offset = y * 32;
            for (int x = x0; x < x1; ++x) {
                int index = offset + x;
                int v = ColorUtils.getColorByIndex(Math.max(0, color));
                this.image[index] = v = v & 0xFF00FF00 | (v & 0xFF0000) >> 16 | (v & 0xFF) << 16;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class_1043 getBackingTexture() {
        if (this.backingTexture == null) {
            this.backingTexture = new class_1043(32, 32, false);
        }
        return this.backingTexture;
    }

    @Environment(value=EnvType.CLIENT)
    private void blitToNativeImage(class_1011 img) {
        int ip = 0;
        for (int iy = 0; iy < 32; ++iy) {
            int ix = 0;
            while (ix < 32) {
                img.method_4305(ix, iy, this.image[ip]);
                ++ix;
                ++ip;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void updateBackingTexture() {
        if (!this.imageDirty) {
            return;
        }
        class_1043 texture = this.getBackingTexture();
        this.blitToNativeImage(texture.method_4525());
        texture.method_4524();
        this.imageDirty = false;
    }

    @Environment(value=EnvType.CLIENT)
    private static class_2960 generateDynTextureId() {
        int id = textureIdCounter++;
        return new class_2960("tis3d", "dynamic/dispmod_" + id);
    }

    @Environment(value=EnvType.CLIENT)
    private class_1921 getRenderLayer() {
        if (this.renderLayer == null) {
            class_1060 texMan = class_310.method_1551().method_1531();
            class_1043 tex = this.getBackingTexture();
            this.backingTextureId = DisplayModule.generateDynTextureId();
            texMan.method_4616(this.backingTextureId, (class_1044)tex);
            this.renderLayer = class_1921.method_23578((class_2960)this.backingTextureId);
        }
        return this.renderLayer;
    }

    @Environment(value=EnvType.CLIENT)
    private void deleteTexture() {
        if (this.backingTextureId != null) {
            class_1060 texMan = class_310.method_1551().method_1531();
            TextureManagerExt.from(texMan).unregisterTexture(this.backingTextureId);
        }
        if (this.backingTexture != null) {
            this.backingTexture.close();
            this.backingTexture = null;
        }
    }

    private void sendClear() {
        ByteBuf data = Unpooled.buffer();
        data.writeBoolean(true);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }

    private void sendDrawCall() {
        ByteBuf data = Unpooled.buffer();
        data.writeBoolean(false);
        data.writeBytes(this.drawCall);
        this.getCasing().sendData(this.getFace(), data);
    }

    public static enum State {
        COLOR,
        X,
        Y,
        W,
        H;

        public static final State[] VALUES;

        public State getNext() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        static {
            VALUES = State.values();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class LeakDetector {
        private static final LinkedList<class_1043> leakedTextures = new LinkedList();

        private LeakDetector() {
        }

        public static void add(@Nullable class_1043 texture) {
            if (texture != null) {
                leakedTextures.add(texture);
            }
        }

        public static void tick() {
            while (!leakedTextures.isEmpty()) {
                class_1043 texture = leakedTextures.remove();
                texture.close();
            }
        }
    }
}

