/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import li.cil.tis3d.common.entity.InfraredPacketEntity;

public final class TickHandlerInfraredPacket {
    public static final TickHandlerInfraredPacket INSTANCE = new TickHandlerInfraredPacket();
    private final Set<InfraredPacketEntity> livePackets = new HashSet<InfraredPacketEntity>();
    private final List<InfraredPacketEntity> pendingRemovals = new ArrayList<InfraredPacketEntity>();
    private final List<InfraredPacketEntity> pendingAdds = new ArrayList<InfraredPacketEntity>();

    public void watchPacket(InfraredPacketEntity packet) {
        this.pendingRemovals.remove(packet);
        this.pendingAdds.add(packet);
    }

    public void unwatchPacket(InfraredPacketEntity packet) {
        this.pendingAdds.remove(packet);
        this.pendingRemovals.add(packet);
    }

    public void serverTick() {
        this.livePackets.addAll(this.pendingAdds);
        this.pendingAdds.clear();
        this.livePackets.removeAll(this.pendingRemovals);
        this.pendingRemovals.clear();
        this.livePackets.forEach(InfraredPacketEntity::updateLifetime);
    }

    private TickHandlerInfraredPacket() {
    }
}

