/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.render.font;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.render.font.FontRenderer;
import li.cil.tis3d.util.ColorUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractFontRenderer
implements FontRenderer {
    private final Int2IntMap CHAR_MAP;
    private final int COLUMNS = this.getResolution() / (this.getCharWidth() + this.getGapU());
    private final float U_SIZE = (float)this.getCharWidth() / (float)this.getResolution();
    private final float V_SIZE = (float)this.getCharHeight() / (float)this.getResolution();
    private final float U_STEP = (float)(this.getCharWidth() + this.getGapU()) / (float)this.getResolution();
    private final float V_STEP = (float)(this.getCharHeight() + this.getGapV()) / (float)this.getResolution();
    private class_1921 renderLayer;

    AbstractFontRenderer() {
        this.CHAR_MAP = new Int2IntOpenHashMap();
        CharSequence chars = this.getCharacters();
        for (int index = 0; index < chars.length(); ++index) {
            this.CHAR_MAP.put((int)chars.charAt(index), index);
        }
    }

    @Override
    public void drawString(CharSequence value, int maxChars) {
    }

    @Override
    public void drawString(CharSequence value) {
        this.drawString(value, value.length());
    }

    public void drawString(class_4587 matrices, CharSequence value) {
        this.drawString(matrices, value, value.length());
    }

    public void drawString(class_4587 matrices, CharSequence value, int maxChars) {
        matrices.method_22903();
        RenderSystem.depthMask((boolean)false);
        class_310.method_1551().method_1531().method_22813(this.getTextureLocation());
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        float tx = 0.0f;
        int end = Math.min(maxChars, value.length());
        for (int i = 0; i < end; ++i) {
            char ch = value.charAt(i);
            this.drawChar(tx, ch, buffer);
            tx += (float)(this.getCharWidth() + this.getGapU());
        }
        RenderSystem.enableBlend();
        tessellator.method_1350();
        RenderSystem.depthMask((boolean)true);
        matrices.method_22909();
    }

    public void drawString(class_4587.class_4665 matrices, class_4588 vc, int light, int overlay, CharSequence value) {
        this.drawString(matrices, vc, light, overlay, ColorUtils.WHITE, value, value.length());
    }

    public void drawString(class_4587.class_4665 matrices, class_4588 vc, int light, int overlay, int color, CharSequence value) {
        this.drawString(matrices, vc, light, overlay, color, value, value.length());
    }

    public void drawString(class_4587.class_4665 matrices, class_4588 vc, int light, int overlay, CharSequence value, int maxChars) {
        this.drawString(matrices, vc, light, overlay, ColorUtils.WHITE, value, maxChars);
    }

    @Override
    public void drawString(class_4587.class_4665 matrices, class_4588 vc, int light, int overlay, int color, CharSequence value, int maxChars) {
        float tx = 0.0f;
        int end = Math.min(maxChars, value.length());
        for (int i = 0; i < end; ++i) {
            char ch = value.charAt(i);
            this.drawChar(matrices, vc, light, overlay, color, tx, ch);
            tx += (float)(this.getCharWidth() + this.getGapU());
        }
    }

    @Override
    public class_4588 chooseVertexConsumer(class_4597 vcp) {
        if (this.renderLayer == null) {
            this.renderLayer = class_1921.method_23584((class_2960)this.getTextureLocation());
        }
        return vcp.getBuffer(this.renderLayer);
    }

    protected abstract CharSequence getCharacters();

    protected abstract class_2960 getTextureLocation();

    protected abstract int getResolution();

    protected abstract int getGapU();

    protected abstract int getGapV();

    private void drawChar(float x, char ch, class_287 buffer) {
        if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
            return;
        }
        int index = this.getCharIndex(ch);
        int column = index % this.COLUMNS;
        int row = index / this.COLUMNS;
        float u = (float)column * this.U_STEP;
        float v = (float)row * this.V_STEP;
        buffer.method_22912((double)x, (double)this.getCharHeight(), 0.0).method_22913(u, v + this.V_SIZE).method_1344();
        buffer.method_22912((double)(x + (float)this.getCharWidth()), (double)this.getCharHeight(), 0.0).method_22913(u + this.U_SIZE, v + this.V_SIZE).method_1344();
        buffer.method_22912((double)(x + (float)this.getCharWidth()), 0.0, 0.0).method_22913(u + this.U_SIZE, v).method_1344();
        buffer.method_22912((double)x, 0.0, 0.0).method_22913(u, v).method_1344();
    }

    private void drawChar(class_4587.class_4665 matrices, class_4588 vc, int light, int overlay, int color, float x, char ch) {
        if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
            return;
        }
        int index = this.getCharIndex(ch);
        int column = index % this.COLUMNS;
        int row = index / this.COLUMNS;
        float u = (float)column * this.U_STEP;
        float v = (float)row * this.V_STEP;
        RenderUtil.drawQuad(matrices, vc, x, 0.0f, (float)this.getCharWidth(), (float)this.getCharHeight(), u, v, u + this.U_SIZE, v + this.V_SIZE, color, light, overlay);
    }

    private int getCharIndex(char ch) {
        if (!this.CHAR_MAP.containsKey((int)ch)) {
            return this.CHAR_MAP.get(63);
        }
        return this.CHAR_MAP.get((int)ch);
    }
}

