/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.config;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.api.DeserializationException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import juuxel.adorn.config.Config;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0006\u0010\u0019\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\b\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljuuxel/adorn/config/ConfigManager;", "", "()V", "config", "Ljuuxel/adorn/config/Config;", "getConfig", "()Ljuuxel/adorn/config/Config;", "config$delegate", "Lkotlin/Lazy;", "configDirectory", "Ljava/nio/file/Path;", "getConfigDirectory", "()Ljava/nio/file/Path;", "configPath", "getConfigPath", "configPath$delegate", "finalized", "", "saveScheduled", "finalize", "", "init", "isMissingKeys", "Lblue/endless/jankson/JsonObject;", "defaults", "save", "Companion", "Adorn"})
public abstract class ConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy configPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
        final /* synthetic */ ConfigManager this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final Path invoke() {
            return this.this$0.getConfigDirectory().resolve("Adorn.json5");
        }
    }));
    private boolean saveScheduled;
    private boolean finalized;
    @NotNull
    private final Lazy config$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Config>(this){
        final /* synthetic */ ConfigManager this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final Config invoke() {
            Object object;
            if (Files.notExists(ConfigManager.access$getConfigPath(this.this$0), new LinkOption[0])) {
                ConfigManager.access$save(this.this$0, new Config());
            }
            try {
                Jankson jankson = ConfigManager.access$getJANKSON$cp();
                Object object2 = Files.readAllLines(ConfigManager.access$getConfigPath(this.this$0));
                Intrinsics.checkNotNullExpressionValue(object2, (String)"readAllLines(configPath)");
                JsonObject jsonObject = jankson.load(CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"JANKSON.load(Files.readA\u2026Path).joinToString(\"\\n\"))");
                JsonObject obj = jsonObject;
                try {
                    object2 = (Config)ConfigManager.access$getJANKSON$cp().fromJsonCarefully(obj, Config.class);
                }
                catch (DeserializationException e) {
                    Config config2 = (Config)ConfigManager.access$getJANKSON$cp().fromJson(obj, Config.class);
                    if (config2 == null) {
                        throw e;
                    }
                    object2 = config2;
                }
                Object config3 = object2;
                if (ConfigManager.access$isMissingKeys(this.this$0, obj, ConfigManager.access$getDEFAULT$cp())) {
                    ConfigManager.access$getLOGGER$cp().info("[Adorn] Upgrading config...");
                    Intrinsics.checkNotNullExpressionValue((Object)config3, (String)"config");
                    ConfigManager.access$save(this.this$0, (Config)config3);
                }
                object = config3;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load Adorn config file!", e);
            }
            return object;
        }
    }));
    private static final Jankson JANKSON = Jankson.builder().build();
    @NotNull
    private static final JsonObject DEFAULT;
    private static final Logger LOGGER;

    @NotNull
    protected abstract Path getConfigDirectory();

    private final Path getConfigPath() {
        Lazy lazy = this.configPath$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-configPath>(...)");
        return (Path)object;
    }

    @JvmName(name="getConfig")
    @NotNull
    public final Config getConfig() {
        Lazy lazy = this.config$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-config>(...)");
        return (Config)object;
    }

    public final void init() {
        this.getConfig();
    }

    public final void save() {
        if (this.finalized) {
            this.save(this.getConfig());
        } else {
            this.saveScheduled = true;
        }
    }

    public final void finalize() {
        this.finalized = true;
        if (this.saveScheduled) {
            this.save();
        }
    }

    private final void save(Config config2) {
        Path path = this.getConfigPath();
        String string = JANKSON.toJson((Object)config2).toJson(true, true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JANKSON.toJson(config).toJson(true, true)");
        Files.write(path, (Iterable<? extends CharSequence>)StringsKt.lines((CharSequence)string), new OpenOption[0]);
    }

    private final boolean isMissingKeys(JsonObject config2, JsonObject defaults) {
        for (Map.Entry entry : ((Map)defaults).entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value2 = (JsonElement)entry.getValue();
            if (!config2.containsKey((Object)key)) {
                return true;
            }
            if (!(value2 instanceof JsonObject)) continue;
            JsonObject jsonObject = (JsonObject)config2.get(JsonObject.class, key);
            if (jsonObject == null) {
                return true;
            }
            if (!this.isMissingKeys(jsonObject, (JsonObject)value2)) continue;
            return true;
        }
        return false;
    }

    public static final /* synthetic */ Path access$getConfigPath(ConfigManager $this) {
        return $this.getConfigPath();
    }

    public static final /* synthetic */ void access$save(ConfigManager $this, Config config2) {
        $this.save(config2);
    }

    public static final /* synthetic */ Jankson access$getJANKSON$cp() {
        return JANKSON;
    }

    public static final /* synthetic */ boolean access$isMissingKeys(ConfigManager $this, JsonObject config2, JsonObject defaults) {
        return $this.isMissingKeys(config2, defaults);
    }

    public static final /* synthetic */ JsonObject access$getDEFAULT$cp() {
        return DEFAULT;
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    static {
        JsonElement jsonElement = JANKSON.toJson((Object)new Config());
        if (jsonElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type blue.endless.jankson.JsonObject");
        }
        DEFAULT = (JsonObject)jsonElement;
        LOGGER = LogManager.getLogger();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljuuxel/adorn/config/ConfigManager$Companion;", "", "()V", "DEFAULT", "Lblue/endless/jankson/JsonObject;", "JANKSON", "Lblue/endless/jankson/Jankson;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

