/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.class_2960;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;

@Config(name="fallingleaves")
public class FallingLeavesConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    @ConfigEntry.Category(value="fallingleaves.general")
    public int version = 1;
    @ConfigEntry.Gui.Excluded
    @ConfigEntry.Category(value="fallingleaves.general")
    public boolean displayDebugData = false;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.BoundedDiscrete(min=1L, max=10L)
    private int leafSize = 5;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=100L, max=600L)
    public int leafLifespan = 200;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(max=20L)
    private int leafSpawnRate = 10;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(max=20L)
    private int coniferLeafSpawnRate = 0;
    @ConfigEntry.Category(value="fallingleaves.general")
    public boolean dropFromPlayerPlacedBlocks = true;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=1L, max=20L)
    public int minimumFreeSpaceBelow = 1;
    @ConfigEntry.Category(value="fallingleaves.general")
    @ConfigEntry.Gui.Tooltip
    public boolean windEnabled = true;
    @ConfigEntry.Category(value="fallingleaves.general")
    public Set<class_2960> windlessDimensions = new HashSet<class_2960>(Arrays.asList(new class_2960("the_nether"), new class_2960("the_end")));
    @ConfigEntry.Category(value="fallingleaves.leafsettings")
    @ConfigEntry.Gui.TransitiveObject
    public Map<class_2960, LeafSettingsEntry> leafSettings = new HashMap<class_2960, LeafSettingsEntry>();

    public float getLeafSize() {
        return (float)this.leafSize / 50.0f;
    }

    public double getBaseLeafSpawnChance() {
        double actualSpawnRate = (double)this.leafSpawnRate / 10.0;
        return actualSpawnRate / 75.0;
    }

    public double getBaseConiferLeafSpawnChance() {
        double actualSpawnRate = (double)this.coniferLeafSpawnRate / 10.0;
        return actualSpawnRate / 75.0;
    }

    public void updateLeafSettings(class_2960 blockId, Consumer<LeafSettingsEntry> f) {
        this.leafSettings.compute(blockId, (id, entry) -> {
            if (entry == null) {
                entry = new LeafSettingsEntry((class_2960)id);
            }
            f.accept((LeafSettingsEntry)entry);
            return entry;
        });
    }

    public void setLeafSize(double leafSize) {
        this.leafSize = (int)(leafSize * 50.0);
    }

    public void setLeafSpawnRate(double leafRate) {
        this.leafSpawnRate = (int)(leafRate * 10.0);
    }

    public void setConiferLeafSpawnRate(double coniferLeafRate) {
        this.coniferLeafSpawnRate = (int)(coniferLeafRate * 10.0);
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        this.version = 1;
        this.leafSize = Math.max(this.leafSize, 1);
        this.minimumFreeSpaceBelow = Math.max(this.minimumFreeSpaceBelow, 1);
    }
}

