/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import java.util.Locale;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.util.SpriteCalculator;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class ConnectingCTMProperties
extends BaseCTMProperties {
    protected ConnectionPredicate connectionPredicate;

    public ConnectingCTMProperties(Properties properties, class_2960 id, String packName, int packPriority, String method) {
        super(properties, id, packName, packPriority, method);
    }

    @Override
    public void init() {
        super.init();
        this.parseConnect();
        this.detectConnect();
        this.validateConnect();
    }

    protected void parseConnect() {
        String connectStr = this.properties.getProperty("connect");
        if (connectStr != null) {
            connectStr = connectStr.trim();
            try {
                this.connectionPredicate = ConnectionType.valueOf(connectStr.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    protected void detectConnect() {
        if (this.connectionPredicate == null) {
            if (this.affectsBlockStates()) {
                this.connectionPredicate = ConnectionType.BLOCK;
            } else if (this.affectsTextures()) {
                this.connectionPredicate = ConnectionType.TILE;
            }
        }
    }

    protected void validateConnect() {
        if (this.connectionPredicate == null) {
            ContinuityClient.LOGGER.error("No valid connection type provided in file '" + this.id + "' in pack '" + this.packName + "'");
            this.valid = false;
        }
    }

    public ConnectionPredicate getConnectionPredicate() {
        return this.connectionPredicate;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ConnectionType implements ConnectionPredicate
    {
        BLOCK{

            @Override
            public boolean shouldConnect(class_2680 state, class_1058 quadSprite, class_2338 pos, class_2680 to, class_2350 face, class_1920 blockView) {
                return state.method_26204() == to.method_26204();
            }
        }
        ,
        TILE{

            @Override
            public boolean shouldConnect(class_2680 state, class_1058 quadSprite, class_2338 pos, class_2680 to, class_2350 face, class_1920 blockView) {
                if (state == to) {
                    return true;
                }
                return quadSprite == SpriteCalculator.getSprite(to, face);
            }
        }
        ,
        MATERIAL{

            @Override
            public boolean shouldConnect(class_2680 state, class_1058 quadSprite, class_2338 pos, class_2680 to, class_2350 face, class_1920 blockView) {
                return state.method_26207() == to.method_26207();
            }
        }
        ,
        STATE{

            @Override
            public boolean shouldConnect(class_2680 state, class_1058 quadSprite, class_2338 pos, class_2680 to, class_2350 face, class_1920 blockView) {
                return state == to;
            }
        };

    }
}

