/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.simple;

import java.util.Random;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessorFactory;
import me.pepperbell.continuity.client.processor.BaseProcessingPredicate;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.simple.SpriteProvider;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class SimpleQuadProcessor
implements QuadProcessor {
    protected SpriteProvider spriteProvider;
    protected ProcessingPredicate processingPredicate;

    public SimpleQuadProcessor(SpriteProvider spriteProvider, ProcessingPredicate processingPredicate) {
        this.spriteProvider = spriteProvider;
        this.processingPredicate = processingPredicate;
    }

    @Override
    public QuadProcessor.ProcessingResult processQuad(MutableQuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, int pass, int processorIndex, QuadProcessor.ProcessingContext context) {
        if (!this.processingPredicate.shouldProcessQuad((QuadView)quad, sprite, blockView, state, pos, context)) {
            return QuadProcessor.ProcessingResult.CONTINUE;
        }
        class_1058 newSprite = this.spriteProvider.getSprite((QuadView)quad, sprite, blockView, state, pos, randomSupplier, context);
        return SimpleQuadProcessor.process(quad, sprite, newSprite);
    }

    public static QuadProcessor.ProcessingResult process(MutableQuadView quad, class_1058 oldSprite, class_1058 newSprite) {
        if (newSprite == null) {
            return QuadProcessor.ProcessingResult.ABORT_AND_RENDER_QUAD;
        }
        if (TextureUtil.isMissingSprite(newSprite)) {
            return QuadProcessor.ProcessingResult.CONTINUE;
        }
        QuadUtil.interpolate(quad, oldSprite, newSprite);
        return QuadProcessor.ProcessingResult.STOP;
    }

    public static class Factory<T extends BaseCTMProperties>
    extends AbstractQuadProcessorFactory<T> {
        protected SpriteProvider.Factory<? super T> spriteProviderFactory;

        public Factory(SpriteProvider.Factory<? super T> spriteProviderFactory) {
            this.spriteProviderFactory = spriteProviderFactory;
        }

        @Override
        public QuadProcessor createProcessor(T properties, class_1058[] sprites) {
            return new SimpleQuadProcessor(this.spriteProviderFactory.createSpriteProvider(sprites, properties), BaseProcessingPredicate.fromProperties(properties));
        }

        @Override
        public int getTextureAmount(T properties) {
            return this.spriteProviderFactory.getTextureAmount(properties);
        }
    }
}

