/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.gui.TransparentButton;
import com.chaosthedude.naturescompass.utils.BiomeUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class BiomeInfoScreen
extends class_437 {
    private NaturesCompassScreen parentScreen;
    private class_1959 biome;
    private class_4185 searchButton;
    private class_4185 backButton;
    private String source;
    private String category;
    private String precipitation;
    private String temperature;
    private String rainfall;
    private String highHumidity;

    public BiomeInfoScreen(NaturesCompassScreen parentScreen, class_1959 biome) {
        super((class_2561)new class_2588(BiomeUtils.getBiomeNameForDisplay(parentScreen.world, biome)));
        this.parentScreen = parentScreen;
        this.biome = biome;
        this.source = BiomeUtils.getBiomeSource(parentScreen.world, biome);
        this.category = BiomeUtils.getBiomeCategoryName(parentScreen.world, biome);
        this.precipitation = biome.method_8694() == class_1959.class_1963.field_9383 ? class_1074.method_4662((String)"string.naturescompass.snow", (Object[])new Object[0]) : (biome.method_8694() == class_1959.class_1963.field_9382 ? class_1074.method_4662((String)"string.naturescompass.rain", (Object[])new Object[0]) : class_1074.method_4662((String)"string.naturescompass.none", (Object[])new Object[0]));
        this.temperature = (double)biome.method_8712() <= 0.5 ? class_1074.method_4662((String)"string.naturescompass.cold", (Object[])new Object[0]) : ((double)biome.method_8712() <= 1.5 ? class_1074.method_4662((String)"string.naturescompass.medium", (Object[])new Object[0]) : class_1074.method_4662((String)"string.naturescompass.warm", (Object[])new Object[0]));
        this.rainfall = biome.method_8715() <= 0.0f ? class_1074.method_4662((String)"string.naturescompass.none", (Object[])new Object[0]) : ((double)biome.method_8715() < 0.2 ? class_1074.method_4662((String)"string.naturescompass.veryLow", (Object[])new Object[0]) : ((double)biome.method_8715() < 0.3 ? class_1074.method_4662((String)"string.naturescompass.low", (Object[])new Object[0]) : ((double)biome.method_8715() < 0.5 ? class_1074.method_4662((String)"string.naturescompass.average", (Object[])new Object[0]) : ((double)biome.method_8715() < 0.85 ? class_1074.method_4662((String)"string.naturescompass.high", (Object[])new Object[0]) : class_1074.method_4662((String)"string.naturescompass.veryHigh", (Object[])new Object[0])))));
        this.highHumidity = biome.method_8724() ? class_1074.method_4662((String)"gui.yes", (Object[])new Object[0]) : class_1074.method_4662((String)"gui.no", (Object[])new Object[0]);
    }

    public void method_25426() {
        this.method_37067();
        this.setupButtons();
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(matrixStack);
        this.field_22793.method_1729(matrixStack, BiomeUtils.getBiomeNameForDisplay(this.parentScreen.world, this.biome), (float)(this.field_22789 / 2 - this.field_22793.method_1727(BiomeUtils.getBiomeNameForDisplay(this.parentScreen.world, this.biome)) / 2), 20.0f, 0xFFFFFF);
        this.field_22793.method_1729(matrixStack, class_1074.method_4662((String)"string.naturescompass.source", (Object[])new Object[0]), (float)(this.field_22789 / 2 - 100), 40.0f, 0xFFFFFF);
        this.field_22793.method_1729(matrixStack, this.source, (float)(this.field_22789 / 2 - 100), 50.0f, 0x808080);
        this.field_22793.method_1729(matrixStack, class_1074.method_4662((String)"string.naturescompass.category", (Object[])new Object[0]), (float)(this.field_22789 / 2 + 40), 40.0f, 0xFFFFFF);
        this.field_22793.method_1729(matrixStack, this.category, (float)(this.field_22789 / 2 + 40), 50.0f, 0x808080);
        this.field_22793.method_1729(matrixStack, class_1074.method_4662((String)"string.naturescompass.precipitation", (Object[])new Object[0]), (float)(this.field_22789 / 2 - 100), 70.0f, 0xFFFFFF);
        this.field_22793.method_1729(matrixStack, this.precipitation, (float)(this.field_22789 / 2 - 100), 80.0f, 0x808080);
        this.field_22793.method_1729(matrixStack, class_1074.method_4662((String)"string.naturescompass.rainfall", (Object[])new Object[0]), (float)(this.field_22789 / 2 + 40), 70.0f, 0xFFFFFF);
        this.field_22793.method_1729(matrixStack, this.rainfall, (float)(this.field_22789 / 2 + 40), 80.0f, 0x808080);
        this.field_22793.method_1729(matrixStack, class_1074.method_4662((String)"string.naturescompass.temperature", (Object[])new Object[0]), (float)(this.field_22789 / 2 - 100), 100.0f, 0xFFFFFF);
        this.field_22793.method_1729(matrixStack, this.temperature, (float)(this.field_22789 / 2 - 100), 110.0f, 0x808080);
        this.field_22793.method_1729(matrixStack, class_1074.method_4662((String)"string.naturescompass.highHumidity", (Object[])new Object[0]), (float)(this.field_22789 / 2 + 40), 100.0f, 0xFFFFFF);
        this.field_22793.method_1729(matrixStack, this.highHumidity, (float)(this.field_22789 / 2 + 40), 110.0f, 0x808080);
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void setupButtons() {
        this.backButton = (class_4185)this.method_37063((class_364)new TransparentButton(10, this.field_22790 - 30, 110, 20, (class_2561)new class_2588("string.naturescompass.back"), button -> this.field_22787.method_1507((class_437)this.parentScreen)));
        this.searchButton = (class_4185)this.method_37063((class_364)new TransparentButton(this.field_22789 - 120, this.field_22790 - 30, 110, 20, (class_2561)new class_2588("string.naturescompass.search"), button -> this.parentScreen.searchForBiome(this.biome)));
    }
}

