/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.mixin;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wraith.waystones.Waystones;
import wraith.waystones.access.PlayerEntityMixinAccess;
import wraith.waystones.block.WaystoneBlockEntity;
import wraith.waystones.client.ClientStuff;
import wraith.waystones.util.Config;
import wraith.waystones.util.Utils;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements PlayerEntityMixinAccess {
    private final HashSet<String> discoveredWaystones = new HashSet();
    private boolean viewDiscoveredWaystones = true;
    private boolean viewGlobalWaystones = true;
    private int teleportCooldown = 0;

    private class_1657 _this() {
        return (class_1657)this;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        if (this.teleportCooldown <= 0) {
            return;
        }
        this.teleportCooldown = Math.max(0, this.teleportCooldown - 1);
    }

    @Inject(method={"applyDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;applyArmorToDamage(Lnet/minecraft/entity/damage/DamageSource;F)F")})
    public void applyDamage(class_1282 source, float amount, CallbackInfo ci) {
        if (source == class_1282.field_5849) {
            return;
        }
        this.setTeleportCooldown(Config.getInstance().getCooldownWhenHurt());
    }

    @Override
    public void setTeleportCooldown(int cooldown) {
        if (cooldown > 0) {
            this.teleportCooldown = cooldown;
        }
    }

    @Override
    public int getTeleportCooldown() {
        return this.teleportCooldown;
    }

    @Override
    public void discoverWaystone(WaystoneBlockEntity waystone) {
        this.discoveredWaystones.add(waystone.getHash());
        this.syncData();
    }

    @Override
    public boolean hasDiscoveredWaystone(WaystoneBlockEntity waystone) {
        return this.discoveredWaystones.contains(waystone.getHash());
    }

    @Override
    public void forgetWaystone(WaystoneBlockEntity waystone) {
        this.discoveredWaystones.remove(waystone.getHash());
        this.syncData();
    }

    @Override
    public void forgetWaystone(String hash) {
        this.discoveredWaystones.remove(hash);
        this.syncData();
    }

    @Override
    public void syncData() {
        class_1657 class_16572 = this._this();
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayerEntity = (class_3222)class_16572;
        class_2540 packet = PacketByteBufs.create();
        packet.method_10794(this.toTagW(new class_2487()));
        ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)Utils.ID("sync_player"), (class_2540)packet);
    }

    @Override
    public HashSet<String> getDiscoveredWaystones() {
        return this.discoveredWaystones;
    }

    @Override
    public int getDiscoveredCount() {
        return this.discoveredWaystones.size();
    }

    @Override
    public ArrayList<String> getWaystonesSorted() {
        ArrayList<String> waystones = new ArrayList<String>();
        HashSet<String> toRemove = new HashSet<String>();
        for (String hash : this.discoveredWaystones) {
            if (Waystones.WAYSTONE_STORAGE.containsHash(hash)) {
                waystones.add(Waystones.WAYSTONE_STORAGE.getWaystone(hash).getWaystoneName());
                continue;
            }
            toRemove.add(hash);
        }
        for (String remove : toRemove) {
            this.discoveredWaystones.remove(remove);
        }
        waystones.sort(String::compareTo);
        return waystones;
    }

    @Override
    public ArrayList<String> getHashesSorted() {
        ArrayList<String> waystones = new ArrayList<String>();
        HashSet<String> toRemove = new HashSet<String>();
        for (String hash : this.discoveredWaystones) {
            if (Waystones.WAYSTONE_STORAGE.containsHash(hash)) {
                waystones.add(hash);
                continue;
            }
            toRemove.add(hash);
        }
        for (String remove : toRemove) {
            this.discoveredWaystones.remove(remove);
        }
        waystones.sort(Comparator.comparing(a -> Waystones.WAYSTONE_STORAGE.getWaystone((String)a).getWaystoneName()));
        return waystones;
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="RETURN")})
    public void writeCustomDataToNbt(class_2487 tag, CallbackInfo ci) {
        this.toTagW(tag);
    }

    @Override
    public class_2487 toTagW(class_2487 tag) {
        class_2487 customTag = new class_2487();
        class_2499 waystones = new class_2499();
        for (String waystone : this.discoveredWaystones) {
            waystones.add((Object)class_2519.method_23256((String)waystone));
        }
        customTag.method_10566("discovered_waystones", (class_2520)waystones);
        customTag.method_10556("view_discovered_waystones", this.viewDiscoveredWaystones);
        customTag.method_10556("view_global_waystones", this.viewGlobalWaystones);
        tag.method_10566("waystones", (class_2520)customTag);
        return tag;
    }

    @Override
    public void learnWaystones(class_1657 player, boolean overwrite) {
        this.discoveredWaystones.clear();
        this.discoveredWaystones.addAll(((PlayerEntityMixinAccess)player).getDiscoveredWaystones());
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="RETURN")})
    public void readCustomDataFromNbt(class_2487 tag, CallbackInfo ci) {
        this.fromTagW(tag);
    }

    @Override
    public void fromTagW(class_2487 tag) {
        if (!tag.method_10545("waystones")) {
            return;
        }
        if ((tag = tag.method_10562("waystones")).method_10545("discovered_waystones")) {
            HashSet<String> tmpHashes;
            this.discoveredWaystones.clear();
            HashSet<Object> hashes = new HashSet();
            if (Waystones.WAYSTONE_STORAGE != null) {
                hashes = Waystones.WAYSTONE_STORAGE.getAllHashes();
            } else if (this._this().field_6002.field_9236 && (tmpHashes = ClientStuff.getWaystoneHashes()) != null) {
                hashes = tmpHashes;
            }
            class_2499 waystones = tag.method_10554("discovered_waystones", 8);
            for (class_2520 waystone : waystones) {
                if (!hashes.contains(waystone.method_10714())) continue;
                this.discoveredWaystones.add(waystone.method_10714());
            }
        }
        if (tag.method_10545("view_global_waystones")) {
            this.viewGlobalWaystones = tag.method_10577("view_global_waystones");
        }
        if (tag.method_10545("view_discovered_waystones")) {
            this.viewDiscoveredWaystones = tag.method_10577("view_discovered_waystones");
        }
    }

    @Override
    public boolean shouldViewGlobalWaystones() {
        return this.viewGlobalWaystones;
    }

    @Override
    public boolean shouldViewDiscoveredWaystones() {
        return this.viewDiscoveredWaystones;
    }

    @Override
    public void toggleViewGlobalWaystones() {
        this.viewGlobalWaystones = !this.viewGlobalWaystones;
        this.syncData();
    }

    @Override
    public void toggleViewDiscoveredWaystones() {
        this.viewDiscoveredWaystones = !this.viewDiscoveredWaystones;
        this.syncData();
    }

    @Override
    public boolean hasDiscoveredWaystone(String hash) {
        return this.discoveredWaystones.contains(hash);
    }

    @Override
    public void discoverWaystones(HashSet<String> toLearn) {
        if (Waystones.WAYSTONE_STORAGE == null) {
            return;
        }
        for (String waystone : toLearn) {
            if (!Waystones.WAYSTONE_STORAGE.containsHash(waystone)) continue;
            this.discoveredWaystones.add(waystone);
        }
        this.syncData();
    }

    @Override
    public void forgetWaystones(HashSet<String> toForget) {
        for (String hash : toForget) {
            this.discoveredWaystones.remove(hash);
        }
        this.syncData();
    }
}

