/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.chisel.legacy.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.matthewperiut.chisel.Chisel;
import com.matthewperiut.chisel.legacy.Ref;
import com.matthewperiut.chisel.legacy.config.BlockVariant;
import java.util.ArrayList;
import java.util.List;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4970;

public class BlockType {
    private final String packDir;
    private String typeName;
    private String chiselGroupName;
    private FabricBlockSettings settings;
    private List<BlockVariant> variants;
    private List<class_2960> tagsToInclude;
    private List<class_2960> itemsToInclude;

    public BlockType(String packDir, JsonObject typeJson) {
        this.packDir = packDir;
        this.parse(typeJson);
    }

    public void parse(JsonObject typeJson) {
        this.typeName = this.getName(typeJson);
        this.chiselGroupName = this.getChiselGroupName(typeJson);
        this.settings = this.getBlockSettings(typeJson);
        this.variants = this.getVariants(typeJson);
        this.tagsToInclude = this.getTagsToInclude(typeJson);
        this.itemsToInclude = this.getItemsToInclude(typeJson);
    }

    public void register(RuntimeResourcePack resourcePack) {
        this.registerBlocks();
        this.registerResources(resourcePack);
    }

    public void registerBlocks() {
        for (int i = 0; i < this.variants.size(); ++i) {
            BlockVariant variant = this.variants.get(i);
            variant.registerBlock();
        }
    }

    public void registerResources(RuntimeResourcePack resourcePack) {
        for (int i = 0; i < this.variants.size(); ++i) {
            BlockVariant variant = this.variants.get(i);
            variant.registerDrop(resourcePack);
            variant.registerBlockModel(resourcePack);
            variant.registerItemModel(resourcePack);
            variant.registerBlockState(resourcePack);
        }
    }

    public void registerChiselGroup() {
    }

    public String getName(JsonObject typeJson) {
        JsonElement nameElement = typeJson.get("name");
        if (nameElement == null) {
            return null;
        }
        try {
            return nameElement.getAsString();
        }
        catch (ClassCastException e) {
            String msg = String.format("Blocktype from blockpack %s has no name!", this.packDir);
            Chisel.LOGGER.info(msg);
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getChiselGroupName(JsonObject typeJson) {
        JsonElement chiselGroupNameElement = typeJson.get("chisel_group");
        if (chiselGroupNameElement == null) {
            return this.packDir + "/" + this.typeName;
        }
        try {
            return chiselGroupNameElement.getAsString();
        }
        catch (ClassCastException e) {
            String msg = String.format("Blocktype %s from blockpack %s has an invalid chisel group! Setting to default", this.typeName, this.packDir);
            Chisel.LOGGER.info(msg);
            return this.packDir + "/" + this.typeName;
        }
    }

    public List<BlockVariant> getVariants(JsonObject typeJson) {
        JsonElement removeElement;
        JsonElement newVariants;
        ArrayList<BlockVariant> tempVariants = new ArrayList<BlockVariant>();
        JsonElement element = typeJson.get("variants");
        if (element == null || !element.isJsonObject()) {
            return tempVariants;
        }
        JsonObject variantJson = element.getAsJsonObject();
        JsonElement parentElement = variantJson.get("parent");
        if (parentElement != null) {
            String parent = parentElement.getAsString();
            tempVariants.addAll(Ref.getInheritedVariants(this.packDir, this.typeName, parent));
        }
        if ((newVariants = variantJson.get("new")) != null && newVariants.isJsonArray()) {
            tempVariants.addAll(this.parseNewVariants(newVariants.getAsJsonArray()));
        }
        if ((removeElement = variantJson.get("remove")) != null && removeElement.isJsonArray()) {
            JsonArray removeArray = removeElement.getAsJsonArray();
            ArrayList<String> variantsToRemove = new ArrayList<String>();
            for (int i = 0; i < removeArray.size(); ++i) {
                variantsToRemove.add(removeArray.get(i).getAsString());
            }
            tempVariants.removeIf(a -> variantsToRemove.contains(a.getVariantName()));
        }
        return tempVariants;
    }

    public List<BlockVariant> parseNewVariants(JsonArray newVariantsJson) {
        ArrayList<BlockVariant> newVariants = new ArrayList<BlockVariant>();
        for (int i = 0; i < newVariantsJson.size(); ++i) {
            JsonElement namesJsonElement;
            JsonElement variantElement = newVariantsJson.get(i);
            if (variantElement == null || !variantElement.isJsonObject()) continue;
            JsonObject variant = variantElement.getAsJsonObject();
            JsonElement modelElement = variant.get("model");
            String model = modelElement != null ? modelElement.getAsString() : "";
            boolean transparent = false;
            JsonElement transparentElement = variant.get("transparent");
            if (transparentElement != null) {
                transparent = transparentElement.getAsBoolean();
            }
            if ((namesJsonElement = variant.get("names")) == null || !namesJsonElement.isJsonArray()) continue;
            JsonArray namesJson = namesJsonElement.getAsJsonArray();
            for (int j = 0; j < namesJson.size(); ++j) {
                String variantName = namesJson.get(j).getAsString();
                newVariants.add(new BlockVariant(this.packDir, this.typeName, variantName, this.settings, model, transparent));
            }
        }
        return newVariants;
    }

    public List<class_2960> getTagsToInclude(JsonObject typeJson) {
        ArrayList<class_2960> tempTagsToInclude = new ArrayList<class_2960>();
        JsonElement element = typeJson.get("tags_to_include");
        if (element == null || !element.isJsonArray()) {
            return tempTagsToInclude;
        }
        JsonArray tagsToIncludeJson = element.getAsJsonArray();
        for (int i = 0; i < tagsToIncludeJson.size(); ++i) {
            JsonElement subElement = tagsToIncludeJson.get(i);
            if (subElement == null) continue;
            class_2960 id = class_2960.method_12838((String)subElement.getAsString(), (char)':');
            tempTagsToInclude.add(id);
        }
        return tempTagsToInclude;
    }

    public List<class_2960> getItemsToInclude(JsonObject typeJson) {
        ArrayList<class_2960> tempItemsToInclude = new ArrayList<class_2960>();
        JsonElement element = typeJson.get("items_to_include");
        if (element == null || !element.isJsonArray()) {
            return tempItemsToInclude;
        }
        JsonArray itemsToIncludeJson = element.getAsJsonArray();
        for (int i = 0; i < itemsToIncludeJson.size(); ++i) {
            JsonElement subElement = itemsToIncludeJson.get(i);
            if (subElement == null) continue;
            class_2960 id = class_2960.method_12838((String)subElement.getAsString(), (char)':');
            tempItemsToInclude.add(id);
        }
        return tempItemsToInclude;
    }

    public FabricBlockSettings getBlockSettings(JsonObject typeJson) {
        JsonElement settingsJsonElement = typeJson.get("settings");
        if (settingsJsonElement == null || !settingsJsonElement.isJsonObject()) {
            return this.blockTypeSettingsErrorMessage();
        }
        JsonObject settingsJson = settingsJsonElement.getAsJsonObject();
        JsonElement imitateJson = settingsJson.get("imitate");
        if (imitateJson != null) {
            try {
                String blockToImitate = imitateJson.getAsString();
                class_2960 blockIdentifier = class_2960.method_12838((String)blockToImitate, (char)':');
                class_2248 block = (class_2248)class_2378.field_11146.method_10223(blockIdentifier);
                if (block == class_2246.field_10124) {
                    return this.blockTypeSettingsErrorMessage();
                }
                return FabricBlockSettings.copyOf((class_4970)block);
            }
            catch (ClassCastException | IllegalStateException e) {
                return this.blockTypeSettingsErrorMessage();
            }
        }
        return FabricBlockSettings.copyOf((class_4970)class_2246.field_10340);
    }

    public FabricBlockSettings blockTypeSettingsErrorMessage() {
        String msg = String.format("Blockpack %s contains invalid settings for type %s. Inheriting settings from minecraft:stone", this.packDir, this.typeName);
        Chisel.LOGGER.info(msg);
        return FabricBlockSettings.copyOf((class_4970)class_2246.field_10340);
    }
}

