/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module.execution.target;

import java.util.Optional;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.module.ExecutionModule;
import li.cil.tis3d.common.module.execution.Machine;
import li.cil.tis3d.common.module.execution.target.AbstractTargetInterfaceSide;

public final class AnyTargetInterface
extends AbstractTargetInterfaceSide {
    public AnyTargetInterface(Machine machine, ExecutionModule module, Face face) {
        super(machine, module, face);
    }

    @Override
    public boolean beginWrite(short value) {
        for (Port port : Port.VALUES) {
            if (this.isWriting(port)) continue;
            this.beginWrite(port, value);
        }
        return false;
    }

    @Override
    public boolean isWriting() {
        return this.isWriting(Port.LEFT) && this.isWriting(Port.RIGHT) && this.isWriting(Port.UP) && this.isWriting(Port.DOWN);
    }

    @Override
    public void beginRead() {
        for (Port port : Port.VALUES) {
            if (this.isReading(port)) continue;
            this.beginRead(port);
        }
    }

    @Override
    public boolean isReading() {
        return this.isReading(Port.LEFT) && this.isReading(Port.RIGHT) && this.isReading(Port.UP) && this.isReading(Port.DOWN);
    }

    @Override
    public boolean canTransfer() {
        return this.canTransfer(Port.LEFT) || this.canTransfer(Port.RIGHT) || this.canTransfer(Port.UP) || this.canTransfer(Port.DOWN);
    }

    @Override
    public short read() {
        for (Port port : Port.VALUES) {
            if (!this.canTransfer(port)) continue;
            for (Port otherPort : Port.VALUES) {
                if (otherPort == port) continue;
                this.cancelRead(otherPort);
            }
            this.getMachine().getState().last = Optional.of(port);
            return this.read(port);
        }
        throw new IllegalStateException("No data to read. Check canTransfer().");
    }

    @Override
    public void onBeforeWriteComplete(Port port) {
        this.cancelWrite();
        this.getMachine().getState().last = Optional.of(port);
    }

    public String toString() {
        return "ANY";
    }

    public void cancelWrite() {
        for (Port port : Port.VALUES) {
            this.cancelWrite(port);
        }
    }
}

