/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.module;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Pipe;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.traits.Redstone;
import li.cil.tis3d.api.prefab.module.AbstractModuleWithRotation;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.client.init.Textures;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public final class RedstoneModule
extends AbstractModuleWithRotation
implements Redstone {
    private short output = 0;
    private short input = 0;
    private static final String TAG_OUTPUT = "output";
    private static final String TAG_INPUT = "input";
    private static final byte DATA_TYPE_UPDATE = 0;
    private static final float LEFT_U0 = 0.28125f;
    private static final float LEFT_U1 = 0.375f;
    private static final float RIGHT_U0 = 0.625f;
    private static final float RIGHT_U1 = 0.71875f;
    private static final float SHARED_V0 = 0.3125f;
    private static final float SHARED_V1 = 0.78125f;
    private static final float SHARED_W = 0.09375f;
    private static final float SHARED_H = 0.46875f;
    private long lastStep = 0L;
    private boolean scheduledNeighborUpdate = false;

    public RedstoneModule(Casing casing, Face face) {
        super(casing, face);
    }

    @Override
    public void step() {
        class_1937 world = this.getCasing().getCasingWorld();
        for (Port port : Port.VALUES) {
            this.stepOutput(port);
            this.stepInput(port);
        }
        if (this.scheduledNeighborUpdate && world.method_8510() > this.lastStep) {
            this.notifyNeighbors();
        }
        this.lastStep = world.method_8510();
    }

    @Override
    public void onDisabled() {
        this.input = 0;
        this.output = 0;
        this.notifyNeighbors();
        this.sendData();
    }

    @Override
    public void onEnabled() {
        this.sendData();
    }

    @Override
    public void onWriteComplete(Port port) {
        this.stepOutput(port);
    }

    @Override
    public void onData(ByteBuf data) {
        this.input = data.readShort();
        this.output = data.readShort();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void render(class_824 rendererDispatcher, float partialTicks, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        matrices.method_22903();
        this.rotateForRendering(matrices);
        class_1058 baseSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_MODULE_REDSTONE);
        class_4588 vcBase = vcp.getBuffer(class_1921.method_23579());
        RenderUtil.drawQuad(baseSprite, matrices.method_23760(), vcBase, RenderUtil.maxLight, overlay);
        if (!this.getCasing().isEnabled()) {
            matrices.method_22909();
            return;
        }
        class_1058 barsSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_MODULE_REDSTONE_BARS);
        float relativeOutput = (float)this.output / 15.0f;
        float heightOutput = relativeOutput * 0.46875f;
        float v0Output = 0.78125f - heightOutput;
        RenderUtil.drawQuad(barsSprite, matrices.method_23760(), vcBase, 0.28125f, v0Output, 0.09375f, heightOutput, 0.28125f, v0Output, 0.375f, 0.78125f, RenderUtil.maxLight, overlay);
        float relativeInput = (float)this.input / 15.0f;
        float heightInput = relativeInput * 0.46875f;
        float v0Input = 0.78125f - heightInput;
        RenderUtil.drawQuad(barsSprite, matrices.method_23760(), vcBase, 0.625f, v0Input, 0.09375f, heightInput, 0.625f, v0Input, 0.71875f, 0.78125f, RenderUtil.maxLight, overlay);
        matrices.method_22909();
    }

    @Override
    public void readFromNBT(class_2487 nbt) {
        super.readFromNBT(nbt);
        this.output = (short)Math.max(0, Math.min(15, nbt.method_10568(TAG_OUTPUT)));
        this.input = (short)Math.max(0, Math.min(15, nbt.method_10568(TAG_INPUT)));
    }

    @Override
    public void writeToNBT(class_2487 nbt) {
        super.writeToNBT(nbt);
        nbt.method_10569(TAG_OUTPUT, (int)this.output);
        nbt.method_10569(TAG_INPUT, (int)this.input);
    }

    @Override
    public short getRedstoneOutput() {
        return this.output;
    }

    @Override
    public void setRedstoneInput(short value) {
        class_1937 world = this.getCasing().getCasingWorld();
        if (world.field_9236) {
            return;
        }
        short validatedValue = (short)Math.max(0, Math.min(15, value));
        if (validatedValue == this.input) {
            return;
        }
        this.input = validatedValue;
        this.getCasing().markDirty();
        this.cancelWrite();
        this.sendData();
    }

    private void stepOutput(Port port) {
        Pipe sendingPipe = this.getCasing().getSendingPipe(this.getFace(), port);
        if (!sendingPipe.isWriting()) {
            sendingPipe.beginWrite(this.input);
        }
    }

    private void stepInput(Port port) {
        Pipe receivingPipe = this.getCasing().getReceivingPipe(this.getFace(), port);
        if (!receivingPipe.isReading()) {
            receivingPipe.beginRead();
        }
        if (receivingPipe.canTransfer()) {
            this.setRedstoneOutput(receivingPipe.read());
        }
    }

    private void setRedstoneOutput(short value) {
        short validatedValue = (short)Math.max(0, Math.min(15, value));
        if (validatedValue == this.output) {
            return;
        }
        this.output = validatedValue;
        this.getCasing().markDirty();
        this.scheduledNeighborUpdate = true;
        this.sendData();
    }

    private void notifyNeighbors() {
        class_1937 world = this.getCasing().getCasingWorld();
        this.scheduledNeighborUpdate = false;
        class_2248 blockType = world.method_8320(this.getCasing().getPosition()).method_26204();
        world.method_8452(this.getCasing().getPosition(), blockType);
    }

    private void sendData() {
        ByteBuf data = Unpooled.buffer();
        data.writeShort((int)this.input);
        data.writeShort((int)this.output);
        this.getCasing().sendData(this.getFace(), data, (byte)0);
    }
}

