/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.item;

import javax.annotation.Nullable;
import li.cil.tis3d.client.gui.GuiHelper;
import li.cil.tis3d.common.block.CasingBlock;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.item.ModuleItem;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.ReadOnlyMemoryModuleDataMessage;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3222;

public class ReadOnlyMemoryModuleItem
extends ModuleItem {
    private static final String TAG_DATA = "data";
    private static final byte[] EMPTY_DATA = new byte[0];

    public ReadOnlyMemoryModuleItem(class_1792.class_1793 builder) {
        super(builder.method_7889(1));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (world.field_9236) {
            GuiHelper.openReadOnlyMemoryGui(player, hand);
        } else {
            ReadOnlyMemoryModuleItem.sendModuleMemory(player, hand);
        }
        return new class_1271(class_1269.field_5812, (Object)player.method_5998(hand));
    }

    public class_1269 method_7884(class_1838 context) {
        return CasingBlock.activate(context) ? class_1269.field_5812 : super.method_7884(context);
    }

    private static void sendModuleMemory(class_1657 player, class_1268 hand) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_1799 heldItem = player.method_5998(hand);
        if (!Items.isModuleReadOnlyMemory(heldItem)) {
            return;
        }
        ReadOnlyMemoryModuleDataMessage message = new ReadOnlyMemoryModuleDataMessage(ReadOnlyMemoryModuleItem.loadFromStack(heldItem), hand);
        Network.INSTANCE.sendToClient(message, player);
    }

    public static byte[] loadFromNBT(@Nullable class_2487 nbt) {
        if (nbt != null) {
            return nbt.method_10547(TAG_DATA);
        }
        return EMPTY_DATA;
    }

    public static byte[] loadFromStack(class_1799 stack) {
        return ReadOnlyMemoryModuleItem.loadFromNBT(stack.method_7969());
    }

    public static void saveToStack(class_1799 stack, byte[] data) {
        byte[] nbtData;
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            nbt = new class_2487();
            stack.method_7980(nbt);
        }
        if ((nbtData = nbt.method_10547(TAG_DATA)).length != data.length) {
            nbtData = new byte[data.length];
        }
        System.arraycopy(data, 0, nbtData, 0, data.length);
        nbt.method_10570(TAG_DATA, nbtData);
    }
}

