/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.block.entity;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import li.cil.tis3d.api.machine.HaltAndCatchFireException;
import li.cil.tis3d.common.Settings;
import li.cil.tis3d.common.block.entity.AbstractComputerBlockEntity;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.machine.CasingProxy;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.HaltAndCatchFireMessage;
import li.cil.tis3d.util.WorldUtils;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public final class ControllerBlockEntity
extends AbstractComputerBlockEntity {
    public static class_2591<ControllerBlockEntity> TYPE;
    private static final int COOLDOWN_HCF = 60;
    private final List<CasingBlockEntity> casings = new ArrayList<CasingBlockEntity>(Settings.maxCasingsPerController);
    private ControllerState state = ControllerState.SCANNING;
    private ControllerState lastSentState = ControllerState.SCANNING;
    private static final String TAG_HCF_COOLDOWN = "hcfCooldown";
    private static final String TAG_STATE = "state";
    private boolean forceStep;
    private int hcfCooldown = 0;

    public ControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(TYPE, pos, state);
    }

    public ControllerState getState() {
        return this.state;
    }

    @Override
    public void scheduleScan() {
        this.state = ControllerState.SCANNING;
    }

    public void forceStep() {
        class_1937 world = Objects.requireNonNull(this.method_10997());
        if (this.state == ControllerState.RUNNING) {
            this.forceStep = true;
            world.method_8465(null, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5, class_3417.field_14791, class_3419.field_15245, 0.2f, 0.8f + world.field_9229.nextFloat() * 0.1f);
        }
    }

    public void haltAndCatchFire() {
        class_1937 world = Objects.requireNonNull(this.method_10997());
        if (!world.field_9236) {
            this.state = ControllerState.READY;
            this.casings.forEach(CasingBlockEntity::onDisabled);
            HaltAndCatchFireMessage message = new HaltAndCatchFireMessage(world, this.method_11016());
            Network.INSTANCE.sendToClientsNearLocation(message, world, this.method_11016(), 32);
        }
        this.hcfCooldown = 60;
    }

    public void method_11012() {
        super.method_11012();
        class_1937 world = Objects.requireNonNull(this.method_10997());
        if (world.field_9236) {
            return;
        }
        this.casings.forEach(CasingBlockEntity::onDisabled);
        for (CasingBlockEntity casing : this.casings) {
            casing.setController(null);
        }
        this.casings.clear();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        for (CasingBlockEntity casing : this.casings) {
            casing.setController(null);
        }
    }

    @Override
    protected void readFromNBTForServer(class_2487 nbt) {
        super.readFromNBTForServer(nbt);
        this.hcfCooldown = nbt.method_10550(TAG_HCF_COOLDOWN);
    }

    @Override
    protected void writeToNBTForServer(class_2487 nbt) {
        super.writeToNBTForServer(nbt);
        nbt.method_10569(TAG_HCF_COOLDOWN, this.hcfCooldown);
    }

    @Override
    public void fromClientTag(class_2487 nbt) {
        super.fromClientTag(nbt);
        this.state = ControllerState.VALUES[nbt.method_10571(TAG_STATE) & 0xFF];
    }

    @Override
    public class_2487 toClientTag(class_2487 nbt) {
        super.toClientTag(nbt);
        nbt.method_10567(TAG_STATE, (byte)this.state.ordinal());
        return nbt;
    }

    public void tick() {
        class_1937 world = Objects.requireNonNull(this.method_10997());
        if (world.field_9236) {
            if (this.hcfCooldown > 0) {
                --this.hcfCooldown;
                for (class_2350 facing : class_2350.values()) {
                    class_2338 neighborPos = this.method_11016().method_10093(facing);
                    class_2680 neighborState = world.method_8320(neighborPos);
                    if (neighborState.method_26225() || world.field_9229.nextFloat() > 0.25f) continue;
                    float ox = (float)neighborPos.method_10263() + world.field_9229.nextFloat();
                    float oy = (float)neighborPos.method_10264() + world.field_9229.nextFloat();
                    float oz = (float)neighborPos.method_10260() + world.field_9229.nextFloat();
                    world.method_8406((class_2394)class_2398.field_11240, (double)ox, (double)oy, (double)oz, 0.0, 0.0, 0.0);
                }
            }
            return;
        }
        if (this.state != this.lastSentState) {
            class_2680 blockState = world.method_8320(this.method_11016());
            world.method_8413(this.getPipeHostPosition(), blockState, blockState, 7);
            this.lastSentState = this.state;
        }
        if (this.hcfCooldown > 0) {
            --this.hcfCooldown;
            return;
        }
        if (this.state == ControllerState.SCANNING) {
            this.scan();
        }
        if (this.state != ControllerState.READY && this.state != ControllerState.RUNNING) {
            return;
        }
        int power = this.computePower();
        if (this.state == ControllerState.READY) {
            if (power < 1) {
                return;
            }
            this.state = ControllerState.RUNNING;
            this.casings.forEach(CasingBlockEntity::onEnabled);
        }
        if (this.state == ControllerState.RUNNING) {
            boolean bl = this.forceStep = this.forceStep && power == 1;
            if (!world.method_8479(this.method_11016())) {
                this.state = ControllerState.READY;
                this.casings.forEach(CasingBlockEntity::onDisabled);
            } else if (power > 1 || this.forceStep) {
                this.casings.forEach(CasingBlockEntity::stepRedstone);
                try {
                    if (power < 15) {
                        int delay = 15 - power;
                        if (world.method_8510() % (long)delay == 0L || this.forceStep) {
                            this.step();
                        }
                    } else {
                        int steps = power / 15;
                        for (int step = 0; step < steps; ++step) {
                            this.step();
                        }
                    }
                }
                catch (HaltAndCatchFireException e) {
                    this.haltAndCatchFire();
                }
            }
            this.forceStep = false;
        }
    }

    static boolean addNeighbors(class_1937 world, class_2586 blockEntity, Set<class_2586> processed, Queue<class_2586> queue) {
        for (class_2350 facing : class_2350.values()) {
            class_2338 neighborPos = blockEntity.method_11016().method_10093(facing);
            if (!WorldUtils.isBlockLoaded((class_1936)world, neighborPos)) {
                return false;
            }
            class_2586 neighborBlockEntity = world.method_8321(neighborPos);
            if (neighborBlockEntity == null || !processed.add(neighborBlockEntity) || !(neighborBlockEntity instanceof ControllerBlockEntity) && !(neighborBlockEntity instanceof CasingBlockEntity)) continue;
            queue.add(neighborBlockEntity);
        }
        return true;
    }

    private void scan() {
        class_1937 world = Objects.requireNonNull(this.method_10997());
        HashSet<class_2586> processed = new HashSet<class_2586>();
        ArrayDeque<class_2586> queue = new ArrayDeque<class_2586>();
        ArrayList<CasingBlockEntity> newCasings = new ArrayList<CasingBlockEntity>(Settings.maxCasingsPerController);
        processed.add(this);
        queue.add(this);
        while (!queue.isEmpty()) {
            class_2586 blockEntity = (class_2586)queue.remove();
            if (blockEntity instanceof ControllerBlockEntity) {
                if (blockEntity == this) {
                    if (ControllerBlockEntity.addNeighbors(world, blockEntity, processed, queue)) continue;
                    this.clear(ControllerState.INCOMPLETE);
                    return;
                }
                this.clear(ControllerState.MULTIPLE_CONTROLLERS);
                return;
            }
            if (newCasings.size() + 1 > Settings.maxCasingsPerController) {
                this.clear(ControllerState.TOO_COMPLEX);
                return;
            }
            CasingBlockEntity casing = (CasingBlockEntity)blockEntity;
            newCasings.add(casing);
            ControllerBlockEntity.addNeighbors(world, casing, processed, queue);
        }
        if (newCasings.stream().anyMatch(c -> !c.method_11002())) {
            return;
        }
        this.casings.removeAll(newCasings);
        this.casings.forEach(c -> c.setController(null));
        this.casings.forEach(CasingBlockEntity::scheduleScan);
        this.casings.clear();
        this.casings.addAll(newCasings);
        this.casings.forEach(c -> c.setController(this));
        this.casings.forEach(AbstractComputerBlockEntity::checkNeighbors);
        this.checkNeighbors();
        this.casings.forEach(AbstractComputerBlockEntity::rebuildOverrides);
        this.rebuildOverrides();
        this.casings.sort(Comparator.comparing(CasingProxy::getPosition));
        this.state = ControllerState.READY;
    }

    private int computePower() {
        class_1937 world = Objects.requireNonNull(this.method_10997());
        int acc = 0;
        for (class_2350 facing : class_2350.values()) {
            acc += Math.max(0, Math.min(15, world.method_8499(this.method_11016().method_10093(facing), facing)));
        }
        return acc;
    }

    private void step() {
        this.casings.forEach(CasingBlockEntity::stepModules);
        this.casings.forEach(AbstractComputerBlockEntity::stepPipes);
        this.stepPipes();
    }

    private void clear(ControllerState toState) {
        for (CasingBlockEntity casing : this.casings) {
            casing.setController(null);
        }
        if (toState != ControllerState.INCOMPLETE) {
            this.casings.forEach(CasingBlockEntity::onDisabled);
        }
        this.casings.clear();
        this.state = toState;
    }

    public static enum ControllerState {
        SCANNING(false),
        MULTIPLE_CONTROLLERS(true),
        TOO_COMPLEX(true),
        INCOMPLETE(true),
        READY(false),
        RUNNING(false);

        public final boolean isError;
        public final String translateKey;
        public static final ControllerState[] VALUES;

        private ControllerState(boolean isError) {
            this.isError = isError;
            this.translateKey = "tis3d.controller.status." + this.name().toLowerCase(Locale.US);
        }

        static {
            VALUES = ControllerState.values();
        }
    }
}

