/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.render.block.entity;

import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.util.RenderUtil;
import li.cil.tis3d.api.util.TransformUtil;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.common.TIS3D;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.init.Items;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public final class CasingBlockEntityRenderer
implements class_827<CasingBlockEntity> {
    private static final Set<Class<?>> BLACKLIST = new HashSet();
    private class_824 dispatcher;
    private final class_776 manager;
    private class_327 textRenderer;

    public CasingBlockEntityRenderer(class_5614.class_5615 context) {
        this.dispatcher = context.method_32139();
        this.textRenderer = context.method_32143();
        this.manager = context.method_32141();
    }

    public void render(CasingBlockEntity casing, float partialTicks, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = casing.method_10997();
        if (world != null) {
            class_2680 blockState = casing.method_11010();
            this.renderModel(casing.method_11016(), blockState, matrices, vertexConsumers, world, false, overlay);
        }
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        for (Face face : Face.VALUES) {
            if (this.isBackFace(casing.method_11016(), face)) continue;
            matrices.method_22903();
            this.setupMatrix(face, matrices);
            if (!this.isObserverHoldingKey() || !this.drawConfigOverlay(casing, face, matrices, vertexConsumers, overlay)) {
                class_2338 neighborPos = casing.method_11016().method_10093(Face.toDirection(face));
                int neighborLight = class_761.method_23794((class_1920)this.dispatcher.field_4348, (class_2338)neighborPos);
                this.drawModuleOverlay(casing, face, partialTicks, matrices, vertexConsumers, neighborLight, overlay);
            }
            matrices.method_22909();
        }
        matrices.method_22909();
    }

    private boolean isBackFace(class_2338 blockPos, Face face) {
        class_243 faceCenter;
        class_243 cameraToFaceCenter;
        class_243 cameraPosition = this.dispatcher.field_4344.method_19326();
        class_243 blockCenter = class_243.method_24954((class_2382)blockPos).method_1031(0.5, 0.5, 0.5);
        class_243 faceNormal = new class_243(Face.toDirection(face).method_23955());
        return faceNormal.method_1026(cameraToFaceCenter = (faceCenter = blockCenter.method_1019(faceNormal.method_1021(0.5))).method_1020(cameraPosition)) > 0.0;
    }

    private void renderModel(class_2338 pos, class_2680 state, class_4587 matrices, class_4597 vertexConsumers, class_1937 world, boolean cull, int overlay) {
        class_1921 renderLayer = class_4696.method_29359((class_2680)state);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(renderLayer);
        this.manager.method_3350().method_3374((class_1920)world, this.manager.method_3349(state), state, pos, matrices, vertexConsumer, cull, new Random(), state.method_26190(pos), overlay);
    }

    private void setupMatrix(Face face, class_4587 matrices) {
        class_1160 axis;
        matrices.method_22907(new class_1158(axis, (float)(switch (face) {
            case Face.Y_NEG -> {
                axis = class_1160.field_20703;
                yield -90;
            }
            case Face.Y_POS -> {
                axis = class_1160.field_20703;
                yield 90;
            }
            case Face.Z_NEG -> {
                axis = class_1160.field_20705;
                yield 0;
            }
            case Face.Z_POS -> {
                axis = class_1160.field_20705;
                yield 180;
            }
            case Face.X_NEG -> {
                axis = class_1160.field_20705;
                yield 90;
            }
            case Face.X_POS -> {
                axis = class_1160.field_20705;
                yield -90;
            }
            default -> throw new RuntimeException("Invalid face");
        }), true));
        matrices.method_22904(0.5, 0.5, (double)-0.505f);
        matrices.method_22905(-1.0f, -1.0f, 1.0f);
    }

    private boolean drawConfigOverlay(CasingBlockEntity casing, Face face, class_4587 matrices, class_4597 vcp, int overlay) {
        if (!this.isObserverKindaClose(casing)) {
            return false;
        }
        class_4588 vc = vcp.getBuffer(class_1921.method_23579());
        if (this.isObserverSneaking() && !casing.isLocked()) {
            Port lookingAtPort;
            class_1058 openSprite;
            class_1058 closedSprite;
            boolean isLookingAt = this.isObserverLookingAt(casing.method_11016(), face);
            if (isLookingAt) {
                closedSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_PORT_CLOSED);
                openSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_PORT_OPEN);
                class_239 hitResult = this.dispatcher.field_4350;
                assert (hitResult.method_17783() == class_239.class_240.field_1332) : "dispatcher.hitResult.getBlockPos().getType() is not of type BLOCK even though it was in isObserverLookingAt";
                assert (hitResult instanceof class_3965) : "dispatcher.hitResult.getBlockPos() is not a BlockHitResult even though it was in isObserverLookingAt";
                class_3965 blockHitResult = (class_3965)hitResult;
                class_2338 pos = blockHitResult.method_17777();
                assert (pos != null) : "dispatcher.hitResult.getBlockPos() is null even though it was non-null in isObserverLookingAt";
                class_243 uv = TransformUtil.hitToUV(face, hitResult.method_17784().method_1020(class_243.method_24954((class_2382)pos)));
                lookingAtPort = Port.fromUVQuadrant(uv);
            } else {
                closedSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_PORT_CLOSED_SMALL);
                openSprite = null;
                lookingAtPort = null;
            }
            matrices.method_22903();
            for (Port port : Port.CLOCKWISE) {
                class_1058 sprite;
                boolean isClosed = casing.isReceivingPipeLocked(face, port);
                class_1058 class_10582 = sprite = isClosed ? closedSprite : openSprite;
                if (sprite != null) {
                    RenderUtil.drawQuad(sprite, matrices.method_23760(), vc, RenderUtil.maxLight, overlay);
                }
                if (port == lookingAtPort) {
                    class_1058 highlightSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_PORT_HIGHLIGHT);
                    RenderUtil.drawQuad(highlightSprite, matrices.method_23760(), vc, RenderUtil.maxLight, overlay);
                }
                matrices.method_22904(0.5, 0.5, 0.5);
                matrices.method_22907(new class_1158(class_1160.field_20707, 90.0f, true));
                matrices.method_22904(-0.5, -0.5, -0.5);
            }
            matrices.method_22909();
            return isLookingAt;
        }
        class_1058 sprite = casing.isLocked() ? RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_LOCKED) : RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_UNLOCKED);
        RenderUtil.drawQuad(sprite, matrices.method_23760(), vc, RenderUtil.maxLight, overlay);
        return true;
    }

    private void drawModuleOverlay(CasingBlockEntity casing, Face face, float partialTicks, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        class_4588 vc = vcp.getBuffer(class_1921.method_23579());
        class_1058 closedSprite = RenderUtil.getSprite(Textures.LOCATION_OVERLAY_CASING_PORT_CLOSED_SMALL);
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, (double)-0.005f);
        for (Port port : Port.CLOCKWISE) {
            boolean isClosed = casing.isReceivingPipeLocked(face, port);
            if (isClosed) {
                RenderUtil.drawQuad(closedSprite, matrices.method_23760(), vc, RenderUtil.maxLight, overlay);
            }
            matrices.method_22904(0.5, 0.5, 0.5);
            matrices.method_22907(new class_1158(class_1160.field_20707, 90.0f, true));
            matrices.method_22904(-0.5, -0.5, -0.5);
        }
        matrices.method_22909();
        Module module = casing.getModule(face);
        if (module == null) {
            return;
        }
        if (BLACKLIST.contains(module.getClass())) {
            return;
        }
        try {
            module.render(this.dispatcher, partialTicks, matrices, vcp, light, overlay);
        }
        catch (Exception e) {
            BLACKLIST.add(module.getClass());
            TIS3D.getLog().error("A module threw an exception while rendering, won't render again!", (Throwable)e);
        }
    }

    private boolean isObserverKindaClose(CasingBlockEntity casing) {
        return this.dispatcher.field_4344.method_19328().method_10262((class_2382)casing.method_11016()) < 256.0;
    }

    private boolean isObserverHoldingKey() {
        for (class_1799 stack : this.dispatcher.field_4344.method_19331().method_5743()) {
            if (!Items.isKey(stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isObserverSneaking() {
        return this.dispatcher.field_4344.method_19331().method_5715();
    }

    private boolean isObserverLookingAt(class_2338 pos, Face face) {
        class_239 hitResult = this.dispatcher.field_4350;
        if (hitResult == null) {
            return false;
        }
        if (hitResult.method_17783() != class_239.class_240.field_1332) {
            return false;
        }
        class_3965 blockHitResult = (class_3965)hitResult;
        if (blockHitResult.method_17780() == null) {
            return false;
        }
        if (Face.fromDirection(blockHitResult.method_17780()) != face) {
            return false;
        }
        if (blockHitResult.method_17777() == null) {
            return false;
        }
        return Objects.equals(blockHitResult.method_17777(), pos);
    }
}

