/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.manual.segment;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import li.cil.tis3d.api.manual.ImageRenderer;
import li.cil.tis3d.api.manual.InteractiveImageRenderer;
import li.cil.tis3d.client.manual.Document;
import li.cil.tis3d.client.manual.segment.AbstractSegment;
import li.cil.tis3d.client.manual.segment.InteractiveSegment;
import li.cil.tis3d.client.manual.segment.Segment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public final class RenderSegment
extends AbstractSegment
implements InteractiveSegment {
    private final Segment parent;
    private final String title;
    private final ImageRenderer imageRenderer;
    private int lastX = 0;
    private int lastY = 0;

    public RenderSegment(Segment parent, String title, ImageRenderer imageRenderer) {
        this.parent = parent;
        this.title = title;
        this.imageRenderer = imageRenderer;
    }

    @Override
    public Segment parent() {
        return this.parent;
    }

    @Override
    public Optional<String> tooltip() {
        if (this.imageRenderer instanceof InteractiveImageRenderer) {
            return Optional.of(((InteractiveImageRenderer)this.imageRenderer).getTooltip(this.title));
        }
        return Optional.of(this.title);
    }

    @Override
    public boolean onMouseClick(int mouseX, int mouseY) {
        return this.imageRenderer instanceof InteractiveImageRenderer && ((InteractiveImageRenderer)this.imageRenderer).onMouseClick(mouseX - this.lastX, mouseY - this.lastY);
    }

    @Override
    public void notifyHover() {
    }

    @Override
    public int nextY(int indent, int maxWidth, class_327 renderer) {
        return this.imageHeight(maxWidth) + (indent > 0 ? Document.lineHeight(renderer) : 0);
    }

    @Override
    public int nextX(int indent, int maxWidth, class_327 renderer) {
        return 0;
    }

    @Override
    public Optional<InteractiveSegment> render(class_4587 matrices, int x, int y, int indent, int maxWidth, class_327 renderer, int mouseX, int mouseY) {
        int width = this.imageWidth(maxWidth);
        int height = this.imageHeight(maxWidth);
        int xOffset = (maxWidth - width) / 2;
        int yOffset = 2 + (indent > 0 ? Document.lineHeight(renderer) : 0);
        float s = this.scale(maxWidth);
        this.lastX = x + xOffset;
        this.lastY = y + yOffset;
        Optional<InteractiveSegment> hovered = this.checkHovered(mouseX, mouseY, x + xOffset, y + yOffset, width, height);
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrices.method_22903();
        matrices.method_22904((double)(x + xOffset), (double)(y + yOffset), 0.0);
        matrices.method_22905(s, s, s);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        if (hovered.isPresent()) {
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
            RenderSystem.disableTexture();
            class_289 t = class_289.method_1348();
            class_287 b = t.method_1349();
            b.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            b.method_22912(0.0, 0.0, 0.0);
            b.method_22912(0.0, (double)this.imageRenderer.getHeight(), 0.0);
            b.method_22912((double)this.imageRenderer.getWidth(), (double)this.imageRenderer.getHeight(), 0.0);
            b.method_22912((double)this.imageRenderer.getWidth(), 0.0, 0.0);
            t.method_1350();
            RenderSystem.enableTexture();
        }
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22904((double)x, (double)y, 0.0);
        float xImage = (float)this.imageRenderer.getWidth() / 16.0f;
        float yImage = (float)this.imageRenderer.getHeight() / 16.0f;
        matrixStack.method_22905(xImage, yImage, 1.0f);
        this.imageRenderer.render(matrices, mouseX - x, mouseY - y);
        matrices.method_22909();
        matrices.method_22905(1.0f / xImage, 1.0f / yImage, 0.0f);
        matrices.method_22904((double)(-x), (double)(-y), 0.0);
        return hovered;
    }

    public String toString() {
        return String.format("![%s](%s)", this.title, this.imageRenderer);
    }

    private float scale(int maxWidth) {
        return Math.min(1.0f, (float)maxWidth / (float)this.imageRenderer.getWidth());
    }

    private int imageWidth(int maxWidth) {
        return Math.min(maxWidth, this.imageRenderer.getWidth());
    }

    private int imageHeight(int maxWidth) {
        return class_3532.method_15386((float)((float)this.imageRenderer.getHeight() * this.scale(maxWidth))) + 4;
    }
}

