/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import li.cil.tis3d.client.init.Textures;
import li.cil.tis3d.client.render.font.SmallFontRenderer;
import li.cil.tis3d.common.init.Items;
import li.cil.tis3d.common.network.Network;
import li.cil.tis3d.common.network.message.ReadOnlyMemoryModuleDataMessage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public final class ReadOnlyMemoryModuleGui
extends class_437 {
    private static final int GUI_WIDTH = 190;
    private static final int GUI_HEIGHT = 130;
    private static final int GRID_LEFT = 25;
    private static final int GRID_TOP = 13;
    private static final int CELL_WIDTH = 10;
    private static final int CELL_HEIGHT = 7;
    private static final String LABEL_INITIALIZING = "INITIALIZING...";
    private final class_1657 player;
    private final class_1268 hand;
    private final byte[] data = new byte[256];
    private int guiX = 0;
    private int guiY = 0;
    private static int selectedCell = 0;
    private boolean highNibble = true;
    private boolean receivedData;
    private long initTime;

    ReadOnlyMemoryModuleGui(class_1657 player, class_1268 hand) {
        super((class_2561)new class_2585("Read-Only Module"));
        this.player = player;
        this.hand = hand;
    }

    public void setData(byte[] data) {
        System.arraycopy(data, 0, this.data, 0, Math.min(data.length, this.data.length));
        this.receivedData = true;
        this.initTime = System.currentTimeMillis();
    }

    public void method_25426() {
        super.method_25426();
        this.guiX = (this.field_22789 - 190) / 2;
        this.guiY = (this.field_22790 - 130) / 2;
        this.field_22787.field_1774.method_1462(true);
    }

    public void method_25419() {
        super.method_25419();
        if (this.receivedData) {
            Network.INSTANCE.sendToServer(new ReadOnlyMemoryModuleDataMessage(this.data, this.hand));
        }
        this.field_22787.field_1774.method_1462(false);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float partialTicks) {
        if (this.player.method_31481() || !Items.isModuleReadOnlyMemory(this.player.method_5998(this.hand))) {
            this.field_22787.method_1507(null);
            return;
        }
        this.field_22787.method_1531().method_22813(Textures.LOCATION_GUI_MEMORY);
        this.method_25302(matrices, this.guiX, this.guiY, 0, 0, 190, 130);
        this.drawHeaders(matrices);
        this.drawInitializing(matrices);
        if (!this.receivedData) {
            return;
        }
        this.drawMemory(matrices);
        this.drawSelectionBox(matrices);
    }

    public boolean method_25402(double mouseXd, double mouseYd, int mouseButton) {
        if (super.method_25402(mouseXd, mouseYd, mouseButton)) {
            return true;
        }
        int mouseX = (int)Math.round(mouseXd);
        int mouseY = (int)Math.round(mouseYd);
        this.selectCellAt(mouseX, mouseY);
        return true;
    }

    public boolean method_25403(double mouseXd, double mouseYd, int clickedMouseButton, double da, double db) {
        if (super.method_25403(mouseXd, mouseYd, clickedMouseButton, da, db)) {
            return true;
        }
        int mouseX = (int)Math.round(mouseXd);
        int mouseY = (int)Math.round(mouseYd);
        this.selectCellAt(mouseX, mouseY);
        return true;
    }

    public boolean method_25404(int keyCode, int scancode, int mods) {
        if (super.method_25404(keyCode, scancode, mods)) {
            return true;
        }
        if (!this.receivedData) {
            return false;
        }
        int digit = Character.digit(keyCode, 16);
        if (digit >= 0) {
            if (this.highNibble) {
                byte value = this.data[selectedCell];
                value = (byte)(value & 0xF);
                this.data[ReadOnlyMemoryModuleGui.selectedCell] = value = (byte)(value | (digit & 0xF) << 4);
            } else {
                byte value = this.data[selectedCell];
                value = (byte)(value & 0xF0);
                this.data[ReadOnlyMemoryModuleGui.selectedCell] = value = (byte)(value | digit & 0xF);
            }
            boolean bl = this.highNibble = !this.highNibble;
            if (this.highNibble) {
                selectedCell = (selectedCell + 1) % this.data.length;
            }
        } else if (keyCode == 261) {
            this.data[ReadOnlyMemoryModuleGui.selectedCell] = 0;
            this.highNibble = true;
        } else if (keyCode == 259) {
            if (this.highNibble) {
                selectedCell = (selectedCell - 1 + this.data.length) % this.data.length;
            }
            this.data[ReadOnlyMemoryModuleGui.selectedCell] = 0;
            this.highNibble = true;
        } else {
            int col = selectedCell & 0xF;
            int row = (selectedCell & 0xF0) >> 4;
            switch (keyCode) {
                case 72: 
                case 263: {
                    if (col == 0) {
                        col = 15;
                        row = (row - 1 + 16) % 16;
                        break;
                    }
                    --col;
                    break;
                }
                case 76: 
                case 262: {
                    if (col == 15) {
                        col = 0;
                        row = (row + 1) % 16;
                        break;
                    }
                    ++col;
                    break;
                }
                case 75: 
                case 265: {
                    row = (row - 1 + 16) % 16;
                    break;
                }
                case 74: 
                case 264: {
                    row = (row + 1) % 16;
                    break;
                }
                default: {
                    return false;
                }
            }
            selectedCell = row << 4 | col;
            this.highNibble = true;
        }
        return true;
    }

    public boolean method_25421() {
        return false;
    }

    private void selectCellAt(int mouseX, int mouseY) {
        if (!this.receivedData) {
            return;
        }
        int col = (mouseX + 1 - this.guiX - 25) / 10;
        int row = (mouseY + 1 - this.guiY - 13) / 7;
        if (this.isInGridArea(col, row)) {
            selectedCell = row << 4 | col;
            this.highNibble = true;
        }
    }

    private boolean isInGridArea(int col, int row) {
        return col >= 0 && row >= 0 && col <= 15 && row <= 15;
    }

    private void drawHeaders(class_4587 matrices) {
        RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        matrices.method_22903();
        matrices.method_22904((double)(this.guiX + 25 + 3), (double)(this.guiY + 6), 0.0);
        for (int col = 0; col < 16; ++col) {
            SmallFontRenderer.INSTANCE.drawString(String.format("%X", col));
            matrices.method_22904(10.0, 0.0, 0.0);
        }
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_22904((double)(this.guiX + 7), (double)(this.guiY + 14), 0.0);
        for (int row = 0; row < 16; ++row) {
            SmallFontRenderer.INSTANCE.drawString(String.format("0X%X0", row));
            matrices.method_22904(0.0, 7.0, 0.0);
        }
        matrices.method_22909();
    }

    private void drawInitializing(class_4587 matrices) {
        float sinceInitialized = (float)(System.currentTimeMillis() - this.initTime) / 1000.0f;
        if (this.receivedData && sinceInitialized > 0.5f) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - sinceInitialized / 0.5f));
        GlStateManager._enableBlend();
        int labelWidth = SmallFontRenderer.INSTANCE.getCharWidth() * LABEL_INITIALIZING.length();
        matrices.method_22903();
        matrices.method_22904((double)(this.guiX + 25 + 3 + 70 - labelWidth / 2), (double)(this.guiY + 13 + 1 + 49), 0.0);
        SmallFontRenderer.INSTANCE.drawString(LABEL_INITIALIZING);
        matrices.method_22909();
    }

    private void drawMemory(class_4587 matrices) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int visibleCells = (int)(System.currentTimeMillis() - this.initTime);
        matrices.method_22903();
        matrices.method_22904((double)(this.guiX + 25 + 1), (double)(this.guiY + 13 + 1), 0.0);
        int count = Math.min(visibleCells, this.data.length);
        for (int i = 0; i < count; ++i) {
            SmallFontRenderer.INSTANCE.drawString(String.format("%02X", this.data[i]));
            int col = i & 0xF;
            if (col < 15) {
                matrices.method_22904(10.0, 0.0, 0.0);
                continue;
            }
            matrices.method_22904(-150.0, 7.0, 0.0);
        }
        matrices.method_22909();
    }

    private void drawSelectionBox(class_4587 matrices) {
        int visibleCells = (int)(System.currentTimeMillis() - this.initTime) * 2;
        if (selectedCell > visibleCells) {
            return;
        }
        int col = selectedCell & 0xF;
        int row = (selectedCell & 0xF0) >> 4;
        int x = this.guiX + 25 + 10 * col - 1;
        int y = this.guiY + 13 + 7 * row - 1;
        matrices.method_22903();
        matrices.method_22904((double)x, (double)y, 0.0);
        this.field_22787.method_1531().method_22813(Textures.LOCATION_GUI_MEMORY);
        int vPos = (int)(this.field_22787.field_1687.method_8510() % 16L) * 8;
        this.method_25302(matrices, 0, 0, 245, vPos, 11, 8);
        matrices.method_22909();
    }
}

