/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.cloth;

import com.google.common.collect.Lists;
import fr.mrcraftcod.fallingtree.common.FallingTreeCommon;
import fr.mrcraftcod.fallingtree.common.config.Configuration;
import fr.mrcraftcod.fallingtree.common.config.ToolConfiguration;
import fr.mrcraftcod.fallingtree.common.config.TreeConfiguration;
import fr.mrcraftcod.fallingtree.common.config.cloth.ClothHookBase;
import fr.mrcraftcod.fallingtree.common.config.enums.AdjacentStopMode;
import fr.mrcraftcod.fallingtree.common.config.enums.BreakMode;
import fr.mrcraftcod.fallingtree.common.config.enums.BreakOrder;
import fr.mrcraftcod.fallingtree.common.config.enums.DamageRounding;
import fr.mrcraftcod.fallingtree.common.config.enums.DetectionMode;
import fr.mrcraftcod.fallingtree.common.config.enums.MaxSizeAction;
import fr.mrcraftcod.fallingtree.common.config.enums.NotificationMode;
import fr.mrcraftcod.fallingtree.common.wrapper.IComponent;
import fr.mrcraftcod.fallingtree.common.wrapper.IWrapper;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.StringListListEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.fml.ModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothConfigHook
extends ClothHookBase {
    public ClothConfigHook(@NotNull FallingTreeCommon<?> mod) {
        super(mod);
    }

    public void load() {
        ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((minecraft, screen) -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(screen).setTitle((Component)new TextComponent("FallingTree"));
            Configuration configuration = this.getMod().getConfiguration();
            builder.setSavingRunnable(configuration::onUpdate);
            this.fillConfigScreen(builder, configuration);
            return builder.build();
        }));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigScreen(@NotNull ConfigBuilder builder, @NotNull Configuration config) {
        BooleanListEntry reverseSneakingEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName(null, "reverseSneaking")), config.isReverseSneaking()).setDefaultValue(false).setTooltip(this.getTooltips(null, "reverseSneaking", 2)).setSaveConsumer(config::setReverseSneaking).build();
        BooleanListEntry breakInCreativeEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName(null, "breakInCreative")), config.isBreakInCreative()).setDefaultValue(false).setTooltip(this.getTooltips(null, "breakInCreative", 2)).setSaveConsumer(config::setBreakInCreative).build();
        EnumListEntry notificationModeEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName(null, "notificationMode")), NotificationMode.class, (Enum)config.getNotificationMode()).setDefaultValue((Enum)NotificationMode.ACTION_BAR).setTooltip(this.getTooltips(null, "notificationMode", 5)).setSaveConsumer(config::setNotificationMode).build();
        ConfigCategory general = builder.getOrCreateCategory((Component)new TranslatableComponent("text.autoconfig.fallingtree.category.default"));
        general.addEntry((AbstractConfigListEntry)reverseSneakingEntry);
        general.addEntry((AbstractConfigListEntry)breakInCreativeEntry);
        general.addEntry((AbstractConfigListEntry)notificationModeEntry);
        this.fillTreesConfigScreen(builder, config.getTrees());
        this.fillToolsConfigScreen(builder, config.getTools());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void fillTreesConfigScreen(@NotNull ConfigBuilder builder, @NotNull TreeConfiguration config) {
        EnumListEntry breakModeEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName("trees", "breakMode")), BreakMode.class, (Enum)config.getBreakMode()).setDefaultValue((Enum)BreakMode.INSTANTANEOUS).setTooltip(this.getTooltips("trees", "breakMode", 7)).setSaveConsumer(config::setBreakMode).build();
        EnumListEntry detectionModeEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName("trees", "detectionMode")), DetectionMode.class, (Enum)config.getDetectionMode()).setDefaultValue((Enum)DetectionMode.WHOLE_TREE).setTooltip(this.getTooltips("trees", "detectionMode", 9)).setSaveConsumer(config::setDetectionMode).build();
        StringListListEntry allowedLogsEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("trees", "allowedLogs")), config.getAllowedLogs()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "allowedLogs", 5)).setSaveConsumer(config::setAllowedLogs).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        StringListListEntry deniedLogsEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("trees", "deniedLogs")), config.getDeniedLogs()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "deniedLogs", 3)).setSaveConsumer(config::setDeniedLogs).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        StringListListEntry allowedLeavesEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("trees", "allowedLeaves")), config.getAllowedLeaves()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "allowedLeaves", 5)).setSaveConsumer(config::setAllowedLeaves).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        StringListListEntry allowedNonDecayLeavesEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("trees", "allowedNonDecayLeaves")), config.getAllowedNonDecayLeaves()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "allowedNonDecayLeaves", 2)).setSaveConsumer(config::setAllowedNonDecayLeaves).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        StringListListEntry deniedLeavesEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("trees", "deniedLeaves")), config.getDeniedLeaves()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "deniedLeaves", 3)).setSaveConsumer(config::setDeniedLeaves).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        IntegerListEntry maxScanSizeEntry = builder.entryBuilder().startIntField((Component)new TranslatableComponent(this.getFieldName("trees", "maxScanSize")), config.getMaxScanSize()).setDefaultValue(500).setMin(1).setTooltip(this.getTooltips("trees", "maxScanSize", 3)).setSaveConsumer(config::setMaxScanSize).build();
        IntegerListEntry maxSizeEntry = builder.entryBuilder().startIntField((Component)new TranslatableComponent(this.getFieldName("trees", "maxSize")), config.getMaxSize()).setDefaultValue(100).setMin(1).setTooltip(this.getTooltips("trees", "maxSize", 2)).setSaveConsumer(config::setMaxSize).build();
        EnumListEntry maxSizeActionEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName("trees", "maxSizeAction")), MaxSizeAction.class, (Enum)config.getMaxSizeAction()).setDefaultValue((Enum)MaxSizeAction.ABORT).setTooltip(this.getTooltips("trees", "maxSizeAction", 4)).setSaveConsumer(config::setMaxSizeAction).build();
        EnumListEntry breakOrderEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName("trees", "breakOrder")), BreakOrder.class, (Enum)config.getBreakOrder()).setDefaultValue((Enum)BreakOrder.FURTHEST_FIRST).setTooltip(this.getTooltips("trees", "breakOrder", 4)).setSaveConsumer(config::setBreakOrder).build();
        BooleanListEntry treeBreakingEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("trees", "treeBreaking")), config.isTreeBreaking()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "treeBreaking", 1)).setSaveConsumer(config::setTreeBreaking).build();
        BooleanListEntry leavesBreakingEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("trees", "leavesBreaking")), config.isLeavesBreaking()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "leavesBreaking", 2)).setSaveConsumer(config::setLeavesBreaking).build();
        IntegerListEntry leavesBreakingForceRadiusEntry = builder.entryBuilder().startIntField((Component)new TranslatableComponent(this.getFieldName("trees", "leavesBreakingForceRadius")), config.getLeavesBreakingForceRadius()).setDefaultValue(0).setMin(0).setMax(10).setTooltip(this.getTooltips("trees", "leavesBreakingForceRadius", 8)).setSaveConsumer(config::setLeavesBreakingForceRadius).build();
        IntegerListEntry minimumLeavesAroundRequiredEntry = builder.entryBuilder().startIntField((Component)new TranslatableComponent(this.getFieldName("trees", "minimumLeavesAroundRequired")), config.getMinimumLeavesAroundRequired()).setDefaultValue(1).setMin(0).setMax(5).setTooltip(this.getTooltips("trees", "minimumLeavesAroundRequired", 4)).setSaveConsumer(config::setMinimumLeavesAroundRequired).build();
        BooleanListEntry includePersistentLeavesInRequiredCountEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("trees", "includePersistentLeavesInRequiredCount")), config.isIncludePersistentLeavesInRequiredCount()).setDefaultValue(true).setTooltip(this.getTooltips("trees", "includePersistentLeavesInRequiredCount", 5)).setSaveConsumer(config::setIncludePersistentLeavesInRequiredCount).build();
        BooleanListEntry allowMixedLogsEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("trees", "allowMixedLogs")), config.isAllowMixedLogs()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "allowMixedLogs", 4)).setSaveConsumer(config::setAllowMixedLogs).build();
        BooleanListEntry breakNetherTreeWartsEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("trees", "breakNetherTreeWarts")), config.isBreakNetherTreeWarts()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "breakNetherTreeWarts", 2)).setSaveConsumer(config::setBreakNetherTreeWarts).build();
        BooleanListEntry instantlyBreakWartsEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("trees", "instantlyBreakWarts")), config.isInstantlyBreakWarts()).setDefaultValue(false).setTooltip(this.getTooltips("trees", "instantlyBreakWarts", 2)).setSaveConsumer(config::setInstantlyBreakWarts).build();
        IntegerListEntry searchAreaRadiusEntry = builder.entryBuilder().startIntField((Component)new TranslatableComponent(this.getFieldName("trees", "searchAreaRadius")), config.getSearchAreaRadius()).setDefaultValue(-1).setTooltip(this.getTooltips("trees", "searchAreaRadius", 5)).setSaveConsumer(config::setSearchAreaRadius).build();
        StringListListEntry allowedAdjacentBlocks = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("trees", "allowedAdjacentBlocks")), config.getAllowedAdjacentBlocks()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("trees", "allowedAdjacentBlocks", 9)).setSaveConsumer(config::setAllowedAdjacentBlocks).setCellErrorSupplier(this.map(this.getMinecraftBlockIdCellError())).build();
        EnumListEntry adjacentStopModeEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName("trees", "adjacentStopMode")), AdjacentStopMode.class, (Enum)config.getAdjacentStopMode()).setDefaultValue((Enum)AdjacentStopMode.STOP_ALL).setTooltip(this.getTooltips("trees", "adjacentStopMode", 9)).setSaveConsumer(config::setAdjacentStopMode).build();
        ConfigCategory trees = builder.getOrCreateCategory((Component)new TranslatableComponent("text.autoconfig.fallingtree.category.trees"));
        trees.addEntry((AbstractConfigListEntry)breakModeEntry);
        trees.addEntry((AbstractConfigListEntry)detectionModeEntry);
        trees.addEntry((AbstractConfigListEntry)allowedLogsEntry);
        trees.addEntry((AbstractConfigListEntry)deniedLogsEntry);
        trees.addEntry((AbstractConfigListEntry)allowedLeavesEntry);
        trees.addEntry((AbstractConfigListEntry)allowedNonDecayLeavesEntry);
        trees.addEntry((AbstractConfigListEntry)deniedLeavesEntry);
        trees.addEntry((AbstractConfigListEntry)maxScanSizeEntry);
        trees.addEntry((AbstractConfigListEntry)maxSizeEntry);
        trees.addEntry((AbstractConfigListEntry)maxSizeActionEntry);
        trees.addEntry((AbstractConfigListEntry)breakOrderEntry);
        trees.addEntry((AbstractConfigListEntry)treeBreakingEntry);
        trees.addEntry((AbstractConfigListEntry)leavesBreakingEntry);
        trees.addEntry((AbstractConfigListEntry)leavesBreakingForceRadiusEntry);
        trees.addEntry((AbstractConfigListEntry)minimumLeavesAroundRequiredEntry);
        trees.addEntry((AbstractConfigListEntry)includePersistentLeavesInRequiredCountEntry);
        trees.addEntry((AbstractConfigListEntry)allowMixedLogsEntry);
        trees.addEntry((AbstractConfigListEntry)breakNetherTreeWartsEntry);
        trees.addEntry((AbstractConfigListEntry)instantlyBreakWartsEntry);
        trees.addEntry((AbstractConfigListEntry)searchAreaRadiusEntry);
        trees.addEntry((AbstractConfigListEntry)allowedAdjacentBlocks);
        trees.addEntry((AbstractConfigListEntry)adjacentStopModeEntry);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void fillToolsConfigScreen(@NotNull ConfigBuilder builder, @NotNull ToolConfiguration config) {
        BooleanListEntry ignoreToolsEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("tools", "ignoreTools")), config.isIgnoreTools()).setDefaultValue(false).setTooltip(this.getTooltips("tools", "ignoreTools", 4)).setSaveConsumer(config::setIgnoreTools).build();
        BooleanListEntry requireEnchantEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("tools", "requireEnchant")), config.isRequireEnchant()).setDefaultValue(true).setTooltip(this.getTooltips("tools", "requireEnchant", 2)).setSaveConsumer(config::setRequireEnchant).build();
        StringListListEntry allowedEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("tools", "allowed")), config.getAllowed()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("tools", "allowed", 3)).setSaveConsumer(config::setAllowed).setCellErrorSupplier(this.map(this.getMinecraftItemIdCellError())).build();
        StringListListEntry deniedEntry = builder.entryBuilder().startStrList((Component)new TranslatableComponent(this.getFieldName("tools", "denied")), config.getDenied()).setDefaultValue((List)Lists.newArrayList()).setTooltip(this.getTooltips("tools", "denied", 3)).setSaveConsumer(config::setDenied).setCellErrorSupplier(this.map(this.getMinecraftItemIdCellError())).build();
        DoubleListEntry damageMultiplicandEntry = builder.entryBuilder().startDoubleField((Component)new TranslatableComponent(this.getFieldName("tools", "damageMultiplicand")), config.getDamageMultiplicand()).setDefaultValue(1.0).setMin(0.0).setMax(100.0).setTooltip(this.getTooltips("tools", "damageMultiplicand", 7)).setSaveConsumer(config::setDamageMultiplicand).build();
        EnumListEntry damageRoundingEntry = builder.entryBuilder().startEnumSelector((Component)new TranslatableComponent(this.getFieldName("tools", "damageRounding")), DamageRounding.class, (Enum)config.getDamageRounding()).setDefaultValue((Enum)DamageRounding.ROUND_DOWN).setTooltip(this.getTooltips("tools", "damageRounding", 8)).setSaveConsumer(config::setDamageRounding).build();
        DoubleListEntry speedMultiplicandEntry = builder.entryBuilder().startDoubleField((Component)new TranslatableComponent(this.getFieldName("tools", "speedMultiplicand")), config.getSpeedMultiplicand()).setDefaultValue(0.0).setMin(0.0).setMax(50.0).setTooltip(this.getTooltips("tools", "speedMultiplicand", 15)).setSaveConsumer(config::setSpeedMultiplicand).build();
        BooleanListEntry preserveEntry = builder.entryBuilder().startBooleanToggle((Component)new TranslatableComponent(this.getFieldName("tools", "preserve")), config.isPreserve()).setDefaultValue(false).setTooltip(this.getTooltips("tools", "preserve", 3)).setSaveConsumer(config::setPreserve).build();
        ConfigCategory tools = builder.getOrCreateCategory((Component)new TranslatableComponent("text.autoconfig.fallingtree.category.tools"));
        tools.addEntry((AbstractConfigListEntry)ignoreToolsEntry);
        tools.addEntry((AbstractConfigListEntry)requireEnchantEntry);
        tools.addEntry((AbstractConfigListEntry)allowedEntry);
        tools.addEntry((AbstractConfigListEntry)deniedEntry);
        tools.addEntry((AbstractConfigListEntry)damageMultiplicandEntry);
        tools.addEntry((AbstractConfigListEntry)damageRoundingEntry);
        tools.addEntry((AbstractConfigListEntry)speedMultiplicandEntry);
        tools.addEntry((AbstractConfigListEntry)preserveEntry);
    }

    @NotNull
    private Function<String, Optional<Component>> map(@NotNull Function<String, Optional<IComponent>> fct) {
        return str -> ((Optional)fct.apply((String)str)).map(IWrapper::getRaw).map(Component.class::cast);
    }

    @NotNull
    protected Component[] getTooltips(@Nullable String category, @NotNull String fieldName, int count) {
        return (Component[])this.getTooltipsInternal(category, fieldName, count).map(IWrapper::getRaw).map(Component.class::cast).toArray(Component[]::new);
    }
}

