/*
 * Decompiled with CFR 0.152.
 */
package fr.mrcraftcod.fallingtree.common.tree.breaking;

import fr.mrcraftcod.fallingtree.common.FallingTreeCommon;
import fr.mrcraftcod.fallingtree.common.tree.Tree;
import fr.mrcraftcod.fallingtree.common.tree.TreePart;
import fr.mrcraftcod.fallingtree.common.tree.breaking.BreakTreeTooBigException;
import fr.mrcraftcod.fallingtree.common.tree.breaking.ITreeBreakingHandler;
import fr.mrcraftcod.fallingtree.common.tree.breaking.ToolDamageHandler;
import fr.mrcraftcod.fallingtree.common.wrapper.IBlock;
import fr.mrcraftcod.fallingtree.common.wrapper.IBlockPos;
import fr.mrcraftcod.fallingtree.common.wrapper.IBlockState;
import fr.mrcraftcod.fallingtree.common.wrapper.IItemStack;
import fr.mrcraftcod.fallingtree.common.wrapper.ILevel;
import fr.mrcraftcod.fallingtree.common.wrapper.IPlayer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantaneousTreeBreakingHandler
implements ITreeBreakingHandler {
    private static final Logger log = LoggerFactory.getLogger(InstantaneousTreeBreakingHandler.class);
    private static InstantaneousTreeBreakingHandler INSTANCE;
    private final FallingTreeCommon<?> mod;

    @Override
    public boolean breakTree(@NotNull IPlayer player, @NotNull Tree tree) throws BreakTreeTooBigException {
        IItemStack tool = player.getMainHandItem();
        ILevel level = tree.getLevel();
        ToolDamageHandler toolHandler = new ToolDamageHandler(tool, this.mod.getConfiguration().getTools().getDamageMultiplicand(), this.mod.getConfiguration().getTools().isPreserve(), tree.getBreakableCount(), this.mod.getConfiguration().getTrees().getMaxSize(), this.mod.getConfiguration().getTrees().getMaxSizeAction(), this.mod.getConfiguration().getTools().getDamageRounding());
        if (toolHandler.getMaxBreakCount() <= 0) {
            log.debug("Didn't break tree at {} as {}'s tool was about to break", (Object)tree.getHitPos(), (Object)player);
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.prevented_break_tool", new Object[0]));
            return false;
        }
        int brokenCount = tree.getBreakableParts().stream().sorted(this.mod.getConfiguration().getTrees().getBreakOrder().getComparator()).limit(toolHandler.getMaxBreakCount()).map(TreePart::blockPos).mapToInt(logBlockPos -> {
            IBlockState logState = level.getBlockState((IBlockPos)logBlockPos);
            if (!tree.getHitPos().equals(logBlockPos) && !this.mod.checkCanBreakBlock(level, (IBlockPos)logBlockPos, logState, player)) {
                return 0;
            }
            player.awardItemUsed(tool.getItem());
            logState.getBlock().playerDestroy(level, player, (IBlockPos)logBlockPos, logState, level.getBlockEntity((IBlockPos)logBlockPos), tool);
            boolean isRemoved = level.removeBlock((IBlockPos)logBlockPos, false);
            return isRemoved ? 1 : 0;
        }).sum();
        int toolDamage = toolHandler.getActualDamage(brokenCount) - 1;
        if (toolDamage > 0) {
            tool.damage(toolDamage, player);
        }
        if (brokenCount >= toolHandler.getMaxBreakCount()) {
            this.forceBreakDecayLeaves(tree, level);
        }
        return true;
    }

    private void forceBreakDecayLeaves(@NotNull Tree tree, @NotNull ILevel level) {
        int radius = this.mod.getConfiguration().getTrees().getLeavesBreakingForceRadius();
        if (radius > 0) {
            tree.getTopMostLog().ifPresent(topLog -> {
                IBlockPos start = topLog.offset(-radius, -radius, -radius);
                IBlockPos end = topLog.offset(radius, radius, radius);
                topLog.betweenClosedStream(start, end).forEach(checkPos -> {
                    IBlockState checkState = level.getBlockState((IBlockPos)checkPos);
                    IBlock checkBlock = checkState.getBlock();
                    if (this.mod.isLeafBlock(checkBlock)) {
                        checkState.dropResources(level, (IBlockPos)checkPos);
                        level.removeBlock((IBlockPos)checkPos, false);
                    }
                });
            });
        }
    }

    @NotNull
    public static InstantaneousTreeBreakingHandler getInstance(@NotNull FallingTreeCommon<?> common) {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new InstantaneousTreeBreakingHandler(common);
        }
        return INSTANCE;
    }

    public InstantaneousTreeBreakingHandler(FallingTreeCommon<?> mod) {
        this.mod = mod;
    }
}

