/*
 * Decompiled with CFR 0.152.
 */
package me.thonk.croptopia.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import me.thonk.croptopia.Constants;
import me.thonk.croptopia.Croptopia;
import me.thonk.croptopia.config.ConfigurableSeed;
import me.thonk.croptopia.config.TreeConfiguration;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class CroptopiaConfig {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected HoconConfigurationLoader loader;
    protected ConfigurationNode rootNode;
    protected final String configName;
    protected final boolean devEnvironment;
    private TypeSerializerCollection.Builder serializers;

    public CroptopiaConfig(boolean devEnvironment, String configName) {
        this.devEnvironment = devEnvironment;
        this.configName = configName;
        this.serializers = TypeSerializerCollection.builder();
    }

    public CroptopiaConfig(boolean devEnvironment) {
        this(devEnvironment, "croptopia.conf");
    }

    public <T, V extends TypeSerializer<T>> void addSerializer(Class<T> clazz, V instance) {
        this.serializers.register(clazz, instance);
    }

    public void addSerializer(TypeSerializerCollection collection) {
        this.serializers.registerAll(collection);
    }

    public boolean loadConfig() {
        File configDirectory = new File(FabricLoader.getInstance().getConfigDir().toFile(), "croptopia");
        File file = new File(configDirectory, this.configName);
        URL path = null;
        if (this.devEnvironment) {
            path = this.getClass().getClassLoader().getResource(this.configName);
        } else {
            try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.configName);){
                byte[] bytes = new byte[stream.available()];
                stream.read(bytes);
                LOGGER.debug("Creating default config file: " + this.configName);
                if (this.createdFile(file)) {
                    try (FileOutputStream outputStream = new FileOutputStream(file);){
                        outputStream.write(bytes);
                    }
                }
                path = file.toURI().toURL();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().sink(() -> {
            if (!this.canCreateFile(file)) {
                return null;
            }
            return new BufferedWriter(new FileWriter(file));
        })).defaultOptions(options -> options.serializers(builder -> builder.registerAll(this.serializers.build())))).url(path)).build();
        try {
            this.rootNode = this.loader.load();
            this.parseConfig(this.rootNode);
        }
        catch (ConfigurateException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void parseConfig(ConfigurationNode node) {
        File configDirectory = new File(FabricLoader.getInstance().getConfigDir().toFile(), "croptopia");
        if (configDirectory.exists()) {
            File file = new File(configDirectory, "options.json");
            if (file.exists()) {
                ConfigurationNode cropsNode = node.node(new Object[]{"configuredSeeds"});
                try {
                    Constants.OPTIONS.readOptionsFile(file);
                    cropsNode.setList(ConfigurableSeed.class, Constants.OPTIONS.readConfiguredSeeds(file));
                    node.node(new Object[]{"generateSaltInWorld"}).set((Object)(!Constants.OPTIONS.disableSaltOre ? 1 : 0));
                }
                catch (SerializationException e) {
                    e.printStackTrace();
                }
                try {
                    this.loader.save(node);
                }
                catch (ConfigurateException e) {
                    e.printStackTrace();
                }
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                LOGGER.info("Deleted old options json file");
            } else {
                this.addTreeConfigIfDoesNotExist(node, "treeConfig");
                if (!node.hasChild(new Object[]{"configuredSeeds"})) {
                    ConfigurationNode cropsNode = node.node(new Object[]{"configuredSeeds"});
                    try {
                        cropsNode.setList(ConfigurableSeed.class, Croptopia.getSeeds());
                    }
                    catch (SerializationException e) {
                        e.printStackTrace();
                    }
                    try {
                        this.loader.save(node);
                    }
                    catch (ConfigurateException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private boolean canCreateFile(File file) {
        return file.exists();
    }

    private boolean createdFile(File file) {
        try {
            if (!file.getParentFile().exists() && file.getParentFile().mkdirs()) {
                LOGGER.debug("Created directory for: " + file.getParentFile().getCanonicalPath());
            }
            if (!file.exists() && file.createNewFile()) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error creating new config file ", (Throwable)e);
            return false;
        }
        return false;
    }

    public ConfigurationNode getRootNode() {
        return this.rootNode;
    }

    public boolean generateSaltInWorld() {
        return this.getRootNode().node(new Object[]{"generateSaltInWorld"}).getBoolean();
    }

    private boolean addTreeConfigIfDoesNotExist(ConfigurationNode node, String nodeToAdd) {
        if (!node.hasChild(new Object[]{nodeToAdd})) {
            List<class_5321<class_1959>> forestBiomes = Arrays.asList(class_1972.field_9409, class_1972.field_35120, class_1972.field_9414);
            List<class_5321<class_1959>> jungleBiomes = Arrays.asList(class_1972.field_9417, class_1972.field_35118);
            List<class_5321<class_1959>> plainsKeys = Arrays.asList(class_1972.field_9451, class_1972.field_9455);
            List<class_5321<class_1959>> darkForestKeys = Arrays.asList(class_1972.field_9475);
            HashMultimap biomes = HashMultimap.create();
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, forestBiomes, "lime_tree_configured", "pear_tree_configured", "apricot_tree_configured", "avocado_tree_configured", "star_fruit_tree_configured", "lemon_tree_configured", "cherry_tree_configured", "plum_tree_configured", "persimmon_tree_configured", "orange_tree_configured", "nectarine_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, jungleBiomes, "date_tree_configured", "dragon_fruit_tree_configured", "mango_tree_configured", "nutmeg_tree_configured", "coconut_tree_configured", "kumquat_tree_configured", "grapefruit_tree_configured", "banana_tree_configured", "fig_tree_configured", "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, plainsKeys, "apple_tree_configured", "orange_tree_configured", "peach_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, darkForestKeys, "almond_tree_configured", "cashew_tree_configured", "pecan_tree_configured", "walnut_tree_configured");
            class_5321 woodlands = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("woodlands"));
            class_5321 wooded_plateau = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("wooded_plateau"));
            class_5321 wooded_island = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("wooded_island"));
            class_5321 autumnal_woods = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("autumnal_woods"));
            class_5321 autumnal_wooded_hills = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("autumnal_wooded_hills"));
            class_5321 lush_swamp = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("lush_swamp"));
            class_5321 mini_jungle = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)CroptopiaConfig.travID("mini_jungle"));
            List<class_5321<class_1959>> wooded = Arrays.asList(wooded_island, wooded_plateau, woodlands);
            List<class_5321<class_1959>> autumnal = Arrays.asList(autumnal_woods, autumnal_wooded_hills);
            List<class_5321<class_1959>> jungle = Arrays.asList(mini_jungle);
            List<class_5321<class_1959>> lush = Arrays.asList(lush_swamp);
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, wooded, "apple_tree_configured", "cherry_tree_configured", "plum_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, autumnal, "pear_tree_configured", "persimmon_tree_configured", "plum_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, jungle, "date_tree_configured", "dragon_fruit_tree_configured", "mango_tree_configured", "nutmeg_tree_configured", "coconut_tree_configured", "kumquat_tree_configured", "grapefruit_tree_configured", "banana_tree_configured", "fig_tree_configured", "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, class_5321<class_1959>>)biomes, lush, "cinnamon_tree_configured");
            ArrayList<TreeConfiguration> allTreeConfigs = new ArrayList<TreeConfiguration>();
            for (Map.Entry entry : biomes.asMap().entrySet()) {
                allTreeConfigs.add(new TreeConfiguration((String)entry.getKey(), (Collection)entry.getValue()));
            }
            ConfigurationNode node1 = node.node(new Object[]{nodeToAdd});
            try {
                node1.setList(TreeConfiguration.class, allTreeConfigs);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
            try {
                this.loader.save(node);
            }
            catch (ConfigurateException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private static class_2960 travID(String name) {
        return new class_2960("traverse", name);
    }
}

