/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.Symmetry;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.util.PropertiesParsingHelper;
import me.pepperbell.continuity.client.util.RandomIndexProvider;
import net.minecraft.class_2960;

public class RandomCTMProperties
extends BaseCTMProperties {
    protected RandomIndexProvider.Factory indexProviderFactory = RandomIndexProvider.UnweightedFactory.INSTANCE;
    protected int randomLoops = 0;
    protected Symmetry symmetry = Symmetry.NONE;
    protected boolean linked = false;

    public RandomCTMProperties(Properties properties, class_2960 id, String packName, int packPriority, String method) {
        super(properties, id, packName, packPriority, method);
    }

    @Override
    public void init() {
        super.init();
        this.parseWeights();
        this.parseRandomLoops();
        this.parseSymmetry();
        this.parseLinked();
    }

    protected void parseWeights() {
        String[] weightStrs;
        String weightsStr = this.properties.getProperty("weights");
        if (weightsStr != null && (weightStrs = (weightsStr = weightsStr.trim()).split("[ ,]")).length != 0) {
            IntArrayList weights = new IntArrayList();
            for (int i = 0; i < weightStrs.length; ++i) {
                String weightStr;
                block8: {
                    weightStr = weightStrs[i];
                    if (weightStr.isEmpty()) continue;
                    String[] parts = weightStr.split("-");
                    int length = parts.length;
                    try {
                        int weight;
                        if (length == 2) {
                            int min = Integer.parseInt(parts[0]);
                            int max = Integer.parseInt(parts[1]);
                            if (max < min) break block8;
                            for (int weight2 = min; weight2 <= max; ++weight2) {
                                weights.add(weight2);
                            }
                            continue;
                        }
                        if (length == 1 && (weight = Integer.parseInt(parts[0])) > 0) {
                            weights.add(weight);
                            continue;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ContinuityClient.LOGGER.warn("Invalid 'weights' element '" + weightStr + "' at index '" + i + "' in file '" + this.id + "' in pack '" + this.packName + "'");
            }
            if (weights.size() > 1) {
                this.indexProviderFactory = new RandomIndexProvider.WeightedFactory(weights.toIntArray());
            }
        }
    }

    protected void parseRandomLoops() {
        String randomLoopsStr = this.properties.getProperty("randomLoops");
        if (randomLoopsStr != null) {
            randomLoopsStr = randomLoopsStr.trim();
            try {
                int randomLoops = Integer.parseInt(randomLoopsStr);
                if (randomLoops >= 0 && randomLoops <= 9) {
                    this.randomLoops = randomLoops;
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ContinuityClient.LOGGER.warn("Invalid 'randomLoops' value '" + randomLoopsStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
        }
    }

    protected void parseSymmetry() {
        Symmetry symmetry = PropertiesParsingHelper.parseSymmetry(this.properties, "symmetry", this.id, this.packName);
        if (symmetry != null) {
            this.symmetry = symmetry;
        }
    }

    protected void parseLinked() {
        String linkedStr = this.properties.getProperty("linked");
        if (linkedStr != null) {
            linkedStr = linkedStr.trim();
            this.linked = Boolean.parseBoolean(linkedStr);
        }
    }

    public RandomIndexProvider.Factory getIndexProviderFactory() {
        return this.indexProviderFactory;
    }

    public int getRandomLoops() {
        return this.randomLoops;
    }

    public Symmetry getSymmetry() {
        return this.symmetry;
    }

    public boolean getLinked() {
        return this.linked;
    }
}

