/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.opus;

import de.maxhenkel.voicechat.api.opus.OpusEncoderMode;
import de.maxhenkel.voicechat.config.ServerConfig;
import de.maxhenkel.voicechat.voice.client.OpusEncoder;
import javax.annotation.Nullable;

public class OpusEncoderImpl
implements de.maxhenkel.voicechat.api.opus.OpusEncoder {
    private final OpusEncoder encoder;

    public OpusEncoderImpl(OpusEncoder encoder) {
        this.encoder = encoder;
    }

    @Nullable
    public static OpusEncoderImpl create(@Nullable OpusEncoderMode mode) {
        OpusEncoder encoder;
        int application = ServerConfig.Codec.VOIP.getOpusValue();
        if (mode != null) {
            switch (mode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case VOIP: {
                    int n = ServerConfig.Codec.VOIP.getOpusValue();
                    break;
                }
                case AUDIO: {
                    int n = ServerConfig.Codec.AUDIO.getOpusValue();
                    break;
                }
                case RESTRICTED_LOWDELAY: {
                    int n = application = ServerConfig.Codec.RESTRICTED_LOWDELAY.getOpusValue();
                }
            }
        }
        if ((encoder = OpusEncoder.createEncoder(48000, 960, 1024, application)) == null) {
            return null;
        }
        return new OpusEncoderImpl(encoder);
    }

    @Override
    public byte[] encode(short[] rawAudio) {
        return this.encoder.encode(rawAudio);
    }

    @Override
    public void resetState() {
        this.encoder.resetState();
    }

    @Override
    public boolean isClosed() {
        return this.encoder.isClosed();
    }

    @Override
    public void close() {
        this.encoder.close();
    }
}

