/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.gui.AdjustVolumeScreen;
import de.maxhenkel.voicechat.gui.SkinUtils;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.widgets.WidgetBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class GroupList
extends WidgetBase {
    private static final class_2960 TEXTURE = new class_2960("voicechat", "textures/gui/gui_group.png");
    private static final class_2960 SPEAKER_OFF = new class_2960("voicechat", "textures/icons/speaker_small_off.png");
    private static final class_2960 SPEAKER = new class_2960("voicechat", "textures/icons/speaker_small.png");
    private static final class_2960 CHANGE_VOLUME = new class_2960("voicechat", "textures/icons/change_volume.png");
    protected Supplier<List<PlayerState>> playerStates;
    protected int offset;
    private final VoiceChatScreenBase.HoverArea[] hoverAreas;
    private final int columnHeight;
    private final int columnCount;
    private final ClientVoicechat voiceChatClient;

    public GroupList(VoiceChatScreenBase screen, int posX, int posY, int xSize, int ySize, Supplier<List<PlayerState>> playerStates) {
        super(screen, posX, posY, xSize, ySize);
        this.playerStates = playerStates;
        this.columnHeight = 22;
        this.columnCount = 8;
        this.hoverAreas = new VoiceChatScreenBase.HoverArea[this.columnCount];
        for (int i = 0; i < this.hoverAreas.length; ++i) {
            this.hoverAreas[i] = new VoiceChatScreenBase.HoverArea(0, i * this.columnHeight, xSize, this.columnHeight);
        }
        this.voiceChatClient = ClientManager.getClient();
        if (this.voiceChatClient == null) {
            this.mc.method_1507(null);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.voiceChatClient.getConnection() == null || !this.voiceChatClient.getConnection().isAuthenticated()) {
            this.mc.method_1507(null);
        }
    }

    @Override
    public void drawGuiContainerForegroundLayer(class_4587 matrixStack, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        List<PlayerState> entries = this.playerStates.get();
        for (int i = this.getOffset(); i < entries.size() && i < this.getOffset() + this.columnCount; ++i) {
            int pos = i - this.getOffset();
            int startY = this.guiTop + pos * this.columnHeight;
            PlayerState state = entries.get(i);
            this.mc.field_1772.method_30883(matrixStack, (class_2561)new class_2585(state.getGameProfile().getName()), (float)(this.guiLeft + 3 + 16 + 1 + 16 + 3), (float)(startY + 7), 0);
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(class_4587 matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        List<PlayerState> entries = this.playerStates.get();
        for (int i = this.getOffset(); i < entries.size() && i < this.getOffset() + this.columnCount; ++i) {
            PlayerState state = entries.get(i);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            int pos = i - this.getOffset();
            VoiceChatScreenBase.HoverArea hoverArea = this.hoverAreas[pos];
            boolean hovered = hoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY) && !state.getGameProfile().getId().equals(this.mc.field_1724.method_5667());
            int startY = this.guiTop + pos * this.columnHeight;
            if (hovered) {
                class_437.method_25290((class_4587)matrixStack, (int)this.guiLeft, (int)startY, (float)195.0f, (float)39.0f, (int)160, (int)this.columnHeight, (int)512, (int)512);
            } else {
                class_437.method_25290((class_4587)matrixStack, (int)this.guiLeft, (int)startY, (float)195.0f, (float)17.0f, (int)160, (int)this.columnHeight, (int)512, (int)512);
            }
            matrixStack.method_22903();
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderTexture((int)0, (class_2960)SkinUtils.getSkin(state.getGameProfile().getId()));
            matrixStack.method_22904((double)(this.guiLeft + 3), (double)(startY + 3), 0.0);
            matrixStack.method_22905(2.0f, 2.0f, 1.0f);
            class_437.method_25290((class_4587)matrixStack, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            class_437.method_25290((class_4587)matrixStack, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            matrixStack.method_22909();
            if (state.isDisabled()) {
                this.drawIcon(matrixStack, startY, SPEAKER_OFF);
            } else if (this.voiceChatClient.getTalkCache().isTalking(state.getGameProfile().getId())) {
                this.drawIcon(matrixStack, startY, SPEAKER);
            }
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)CHANGE_VOLUME);
            if (!hovered) continue;
            class_437.method_25290((class_4587)matrixStack, (int)(this.guiLeft + this.xSize - 3 - 16), (int)(startY + 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        if (entries.size() > this.columnCount) {
            float h = this.ySize - 17;
            float perc = (float)this.getOffset() / (float)(entries.size() - this.columnCount);
            int posY = this.guiTop + (int)(h * perc);
            class_437.method_25290((class_4587)matrixStack, (int)(this.guiLeft + this.xSize + 6), (int)posY, (float)195.0f, (float)0.0f, (int)12, (int)17, (int)512, (int)512);
        } else {
            class_437.method_25290((class_4587)matrixStack, (int)(this.guiLeft + this.xSize + 6), (int)this.guiTop, (float)207.0f, (float)0.0f, (int)12, (int)17, (int)512, (int)512);
        }
    }

    private void drawIcon(class_4587 matrixStack, int startY, class_2960 texture) {
        matrixStack.method_22903();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        matrixStack.method_22904((double)(this.guiLeft + 3 + 16 + 1), (double)(startY + 3), 0.0);
        class_437.method_25290((class_4587)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        matrixStack.method_22909();
    }

    public int getOffset() {
        List<PlayerState> entries = this.playerStates.get();
        if (entries.size() <= this.columnCount) {
            this.offset = 0;
        } else if (this.offset > entries.size() - this.columnCount) {
            this.offset = entries.size() - this.columnCount;
        }
        return this.offset;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        List<PlayerState> entries = this.playerStates.get();
        if (entries.size() > this.columnCount) {
            this.offset = delta < 0.0 ? Math.min(this.getOffset() + 1, entries.size() - this.columnCount) : Math.max(this.getOffset() - 1, 0);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        List<PlayerState> entries = this.playerStates.get();
        for (int i = 0; i < this.hoverAreas.length && this.getOffset() + i < entries.size(); ++i) {
            PlayerState state;
            if (!this.hoverAreas[i].isHovered(this.guiLeft, this.guiTop, (int)mouseX, (int)mouseY) || (state = entries.get(this.getOffset() + i)).getGameProfile().getId().equals(this.mc.field_1724.method_5667())) continue;
            this.mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
            this.mc.method_1507((class_437)new AdjustVolumeScreen(this.screen, Collections.singletonList(state)));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

