/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.audio;

import com.sonicether.soundphysics.SoundPhysics;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.SpeakerException;
import de.maxhenkel.voicechat.voice.common.NamedThreadPoolFactory;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;

public class FabricSoundManager
extends SoundManager {
    private boolean soundPhysicsLoaded;
    private boolean soundPhysicsRemasteredLoaded;
    private Method setEnvironment;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(NamedThreadPoolFactory.create("VoiceChatSoundPhysicsThread"));

    public FabricSoundManager(@Nullable String deviceName) throws SpeakerException {
        super(deviceName);
        if (!VoicechatClient.CLIENT_CONFIG.soundPhysics.get().booleanValue()) {
            return;
        }
        if (FabricLoader.getInstance().isModLoaded("soundphysics")) {
            try {
                Class.forName("com.sonicether.soundphysics.SoundPhysics");
                this.initSoundPhysics();
                this.soundPhysicsLoaded = true;
                Voicechat.LOGGER.warn("Sound Physics can cause very bad performance. Use Sound Physics Remastered instead!");
                Voicechat.LOGGER.info("Successfully initialized Sound Physics");
            }
            catch (Exception e) {
                Voicechat.LOGGER.warn("Failed to load Sound Physics Remastered: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
        if (FabricLoader.getInstance().isModLoaded("sound_physics_remastered")) {
            try {
                Class.forName("com.sonicether.soundphysics.SoundPhysics");
                this.runInContext(this.executor, SoundPhysics::init);
                this.soundPhysicsRemasteredLoaded = true;
                Voicechat.LOGGER.info("Successfully initialized Sound Physics Remastered");
            }
            catch (Exception e) {
                Voicechat.LOGGER.warn("Failed to load Sound Physics Remastered: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void initSoundPhysics() throws Exception {
        this.setEnvironment = SoundPhysics.class.getDeclaredMethod("setEnvironment", Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
        this.setEnvironment.setAccessible(true);
        this.runInContext(this.executor, SoundPhysics::init);
    }

    public void resetEnvironment(int source) {
        if (this.setEnvironment == null) {
            SoundPhysics.setDefaultEnvironment((int)source);
            return;
        }
        try {
            this.setEnvironment.invoke(null, source, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f));
        }
        catch (Exception e) {
            Voicechat.LOGGER.warn("Failed to execute setEnvironment: {}", (Object)e.getMessage());
            e.printStackTrace();
            this.setEnvironment = null;
        }
    }

    public boolean isSoundPhysicsLoaded() {
        return this.soundPhysicsLoaded;
    }

    public boolean isSoundPhysicsRemasteredLoaded() {
        return this.soundPhysicsRemasteredLoaded;
    }

    @Override
    public void close() {
        super.close();
        this.executor.shutdown();
    }
}

