/*
 * Decompiled with CFR 0.152.
 */
package win.baruna.blockmeter;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import win.baruna.blockmeter.BlockMeter;
import win.baruna.blockmeter.measurebox.MeasureBox;

public class BlockMeterServer
implements ModInitializer {
    private Map<UUID, List<MeasureBox>> playerBoxes;
    private MinecraftServer server;
    private static BlockMeterServer instance;

    public void onInitialize() {
        instance = this;
        this.playerBoxes = new HashMap<UUID, List<MeasureBox>>();
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BlockMeter.C2SPacketIdentifier, this::processClientPacket);
        ServerLifecycleEvents.SERVER_STARTED.register(this::onStartServer);
    }

    public static void removePlayer(class_3222 player) {
        if (instance != null && BlockMeterServer.instance.playerBoxes.containsKey(player.method_5667())) {
            BlockMeterServer.instance.playerBoxes.remove(player.method_5667());
            instance.informAllPlayers();
        }
    }

    private void onStartServer(MinecraftServer server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClientPacket(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 attachedData, PacketSender responseSender) {
        int size = attachedData.readInt();
        try {
            ArrayList<MeasureBox> clientBoxes = new ArrayList<MeasureBox>(size);
            for (int i = 0; i < size; ++i) {
                clientBoxes.add(MeasureBox.fromPacketByteBuf(attachedData));
            }
            Map<UUID, List<MeasureBox>> map = this.playerBoxes;
            synchronized (map) {
                this.playerBoxes.put(player.method_5667(), clientBoxes);
            }
        }
        catch (IllegalArgumentException ex) {
            Map<UUID, List<MeasureBox>> map = this.playerBoxes;
            synchronized (map) {
                this.playerBoxes.remove(player.method_5667());
            }
        }
        server.execute(this::informAllPlayers);
    }

    private void informAllPlayers() {
        class_2540 data = this.buildS2CPacket();
        for (class_3222 player : this.server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)BlockMeter.S2CPacketIdentifier, (class_2540)data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private class_2540 buildS2CPacket() {
        class_2540 data = new class_2540(Unpooled.buffer());
        Map<UUID, List<MeasureBox>> map = this.playerBoxes;
        synchronized (map) {
            data.writeInt(this.playerBoxes.size());
            Set<Map.Entry<UUID, List<MeasureBox>>> knownPlayers = this.playerBoxes.entrySet();
            for (Map.Entry<UUID, List<MeasureBox>> playerBoxEntry : knownPlayers) {
                class_3222 player = this.server.method_3760().method_14602(playerBoxEntry.getKey());
                data.method_10805(player.method_5476());
                data.writeInt(playerBoxEntry.getValue().size());
                for (int i = 0; i < playerBoxEntry.getValue().size(); ++i) {
                    playerBoxEntry.getValue().get(i).writePacketBuf(data);
                }
            }
        }
        return data;
    }
}

