/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.bukkit.SpigotBlockMeterReflector;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class Main
extends JavaPlugin
implements Listener,
PluginMessageListener {
    public static final String MODID = "blockmeter";
    public static final String C2SPacketIdentifier = "blockmeter:c2s";
    public static final String S2CPacketIdentifier = "blockmeter:s2c";
    private Map<UUID, byte[]> playerBoxes;

    public void onEnable() {
        this.playerBoxes = new HashMap<UUID, byte[]>();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, C2SPacketIdentifier, (PluginMessageListener)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, S2CPacketIdentifier);
    }

    @EventHandler
    public void onPlayerQuitEvent(PlayerQuitEvent ev) {
        UUID uuid = ev.getPlayer().getUniqueId();
        if (this.playerBoxes.containsKey(uuid)) {
            this.playerBoxes.remove(uuid);
            this.informAllPlayers();
        }
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] bytes) {
        if (channel.equals(C2SPacketIdentifier)) {
            this.playerBoxes.put(player.getUniqueId(), bytes);
        }
        this.informAllPlayers();
    }

    private void informAllPlayers() {
        byte[] data = this.buildS2CPacket();
        for (Player player : this.getServer().getOnlinePlayers()) {
            player.sendPluginMessage((Plugin)this, S2CPacketIdentifier, data);
        }
    }

    private byte[] buildS2CPacket() {
        HashMap<UUID, CallSite> playerNames = new HashMap<UUID, CallSite>();
        int neededSize = 4;
        for (UUID uuid : this.playerBoxes.keySet()) {
            String json = "{ \"text\":\"" + this.getServer().getPlayer(uuid).getDisplayName() + "\"}";
            playerNames.put(uuid, (CallSite)((Object)json));
            neededSize += this.playerBoxes.get(uuid).length + 1 + json.getBytes().length;
        }
        byte[] result = new byte[neededSize];
        result[0] = 0;
        result[1] = 0;
        result[2] = 0;
        result[3] = (byte)this.playerBoxes.size();
        int pos = 4;
        for (UUID uuid : this.playerBoxes.keySet()) {
            byte[] name = ((String)playerNames.get(uuid)).getBytes();
            result[pos++] = (byte)name.length;
            System.arraycopy(name, 0, result, pos, name.length);
            byte[] boxes = this.playerBoxes.get(uuid);
            System.arraycopy(boxes, 0, result, pos += name.length, boxes.length);
            pos += this.playerBoxes.get(uuid).length;
        }
        return result;
    }
}

