/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.gl.texture.PixelFormat;
import net.coderbot.iris.gl.texture.PixelType;
import net.coderbot.iris.rendertarget.DepthTexture;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL20C;

public class ShadowRenderTargets {
    public static int MAX_SHADOW_RENDER_TARGETS = 8;
    private final int[] targets;
    private final DepthTexture depthTexture;
    private final DepthTexture noTranslucents;
    private final GlFramebuffer framebuffer;
    private static final ByteBuffer NULL_BUFFER = null;

    public ShadowRenderTargets(int resolution, InternalTextureFormat[] formats) {
        if (formats.length > MAX_SHADOW_RENDER_TARGETS) {
            throw new IllegalStateException("Too many shadow render targets, requested " + formats.length + " but only " + MAX_SHADOW_RENDER_TARGETS + " are allowed.");
        }
        int[] drawBuffers = new int[formats.length];
        this.targets = new int[formats.length];
        GL20C.glGenTextures((int[])this.targets);
        this.depthTexture = new DepthTexture(resolution, resolution);
        this.noTranslucents = new DepthTexture(resolution, resolution);
        this.framebuffer = new GlFramebuffer();
        this.framebuffer.addDepthAttachment(this.depthTexture.getTextureId());
        for (int i = 0; i < formats.length; ++i) {
            InternalTextureFormat format = formats[i];
            RenderSystem.bindTexture((int)this.targets[i]);
            GL11C.glTexImage2D((int)3553, (int)0, (int)format.getGlFormat(), (int)resolution, (int)resolution, (int)0, (int)PixelFormat.RGBA.getGlFormat(), (int)PixelType.UNSIGNED_BYTE.getGlFormat(), (ByteBuffer)NULL_BUFFER);
            GL11C.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11C.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11C.glTexParameteri((int)3553, (int)10242, (int)33069);
            GL11C.glTexParameteri((int)3553, (int)10243, (int)33069);
            this.framebuffer.addColorAttachment(i, this.targets[i]);
            drawBuffers[i] = i;
        }
        this.framebuffer.drawBuffers(drawBuffers);
        RenderSystem.bindTexture((int)0);
    }

    public GlFramebuffer getFramebuffer() {
        return this.framebuffer;
    }

    public DepthTexture getDepthTexture() {
        return this.depthTexture;
    }

    public DepthTexture getDepthTextureNoTranslucents() {
        return this.noTranslucents;
    }

    public int getColorTextureId(int index) {
        return this.targets[index];
    }

    public void destroy() {
        this.framebuffer.destroy();
        GL20C.glDeleteTextures((int[])this.targets);
        this.depthTexture.destroy();
        this.noTranslucents.destroy();
    }
}

