/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class CommentDirectiveParser {
    private CommentDirectiveParser() {
    }

    public static Optional<String> findDirectiveInLines(List<String> lines, String key) {
        for (int index = lines.size() - 1; index >= 0; --index) {
            String line = lines.get(index);
            Optional<String> found = CommentDirectiveParser.findDirective(line, key);
            if (!found.isPresent()) continue;
            return found;
        }
        return Optional.empty();
    }

    public static Optional<String> findDirective(String haystack, String needle) {
        String prefix = needle + ":";
        String suffix = "*/";
        int indexOfPrefix = haystack.lastIndexOf(prefix);
        if (indexOfPrefix == -1) {
            return Optional.empty();
        }
        String before = haystack.substring(0, indexOfPrefix).trim();
        if (!before.endsWith("/*")) {
            return Optional.empty();
        }
        int indexOfSuffix = (haystack = haystack.substring(indexOfPrefix + prefix.length())).indexOf(suffix);
        if (indexOfSuffix == -1) {
            return Optional.empty();
        }
        haystack = haystack.substring(0, indexOfSuffix).trim();
        return Optional.of(haystack);
    }

    private static class Tests {
        private Tests() {
        }

        private static <T> void test(String name, T expected, Supplier<T> testCase) {
            T actual;
            try {
                actual = testCase.get();
            }
            catch (Throwable e) {
                System.err.println("Test \"" + name + "\" failed with an exception:");
                e.printStackTrace();
                return;
            }
            if (!expected.equals(actual)) {
                System.err.println("Test \"" + name + "\" failed: Expected " + expected + ", got " + actual);
            } else {
                System.out.println("Test \"" + name + "\" passed");
            }
        }

        public static void main(String[] args) {
            Tests.test("normal text", Optional.empty(), () -> {
                String line = "Some normal text that doesn't contain a DRAWBUFFERS directive of any sort";
                return CommentDirectiveParser.findDirective(line, "DRAWBUFFERS");
            });
            Tests.test("partial directive", Optional.empty(), () -> {
                String line = "Some normal text that doesn't contain a /* DRAWBUFFERS: directive of any sort";
                return CommentDirectiveParser.findDirective(line, "DRAWBUFFERS");
            });
            Tests.test("bad spacing", Optional.of("321"), () -> {
                String line = "/*DRAWBUFFERS:321*/ OptiFine will detect this directive, but ShadersMod will not...";
                return CommentDirectiveParser.findDirective(line, "DRAWBUFFERS");
            });
            Tests.test("matchAtEnd", Optional.of("321"), () -> {
                String line = "A line containg a drawbuffers directive: /* DRAWBUFFERS:321 */";
                return CommentDirectiveParser.findDirective(line, "DRAWBUFFERS");
            });
            Tests.test("matchAtStart", Optional.of("31"), () -> {
                String line = "/* DRAWBUFFERS:31 */ This is a line containg a drawbuffers directive";
                return CommentDirectiveParser.findDirective(line, "DRAWBUFFERS");
            });
            Tests.test("matchInMiddle", Optional.of("31"), () -> {
                String line = "This is a line /* DRAWBUFFERS:31 */ containg a drawbuffers directive";
                return CommentDirectiveParser.findDirective(line, "DRAWBUFFERS");
            });
            Tests.test("emptyMatch", Optional.of(""), () -> {
                String line = "/* DRAWBUFFERS: */ This is a line containg an invalid but still matching drawbuffers directive";
                return CommentDirectiveParser.findDirective(line, "DRAWBUFFERS");
            });
            Tests.test("duplicates", Optional.of("3"), () -> {
                String line = "/* TEST:2 */ This line contains multiple directives, the last one should be used /* TEST:3 */";
                return CommentDirectiveParser.findDirective(line, "TEST");
            });
            Tests.test("lines", Optional.of("It works"), () -> {
                String[] linesArray = new String[]{"/* Here's a random comment line */", "/* Test directive:Duplicate handling? */", "uniform sampler2D test;", "/* Test directive:Duplicate handling within a line? */ Let's see /* Test directive:It works */"};
                List<String> lines = Arrays.asList(linesArray);
                return CommentDirectiveParser.findDirectiveInLines(lines, "Test directive");
            });
            Tests.test("bad spacing from BSL composite6", Optional.of("12"), () -> {
                String line = "    /*DRAWBUFFERS:12*/";
                return CommentDirectiveParser.findDirective(line, "DRAWBUFFERS");
            });
        }
    }
}

